/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils.bytecode;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.utils.Messages;

public class ClassReader
extends ByteArrayInputStream {
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;
    private int[] cpoolIndex;
    private Object[] cpool;
    private Map attrMethods;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getBytes(Class c2) throws IOException {
        InputStream fin = c2.getResourceAsStream('/' + c2.getName().replace('.', '/') + ".class");
        if (fin == null) {
            throw new IOException(Messages.getMessage("cantLoadByecode", c2.getName()));
        }
        try {
            int actual;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            do {
                if ((actual = fin.read(buf)) <= 0) continue;
                out.write(buf, 0, actual);
            } while (actual > 0);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            fin.close();
        }
    }

    static String classDescriptorToName(String desc) {
        return desc.replace('/', '.');
    }

    protected static Map findAttributeReaders(Class c2) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        Method[] methods = c2.getMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            String name = methods[i2].getName();
            if (!name.startsWith("read") || methods[i2].getReturnType() != Void.TYPE) continue;
            map.put(name.substring(4), methods[i2]);
        }
        return map;
    }

    protected static String getSignature(Member method, Class[] paramTypes) {
        StringBuffer b2 = new StringBuffer(method instanceof Method ? method.getName() : "<init>");
        b2.append('(');
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            ClassReader.addDescriptor(b2, paramTypes[i2]);
        }
        b2.append(')');
        if (method instanceof Method) {
            ClassReader.addDescriptor(b2, ((Method)method).getReturnType());
        } else if (method instanceof Constructor) {
            ClassReader.addDescriptor(b2, Void.TYPE);
        }
        return b2.toString();
    }

    private static void addDescriptor(StringBuffer b2, Class c2) {
        if (c2.isPrimitive()) {
            if (c2 == Void.TYPE) {
                b2.append('V');
            } else if (c2 == Integer.TYPE) {
                b2.append('I');
            } else if (c2 == Boolean.TYPE) {
                b2.append('Z');
            } else if (c2 == Byte.TYPE) {
                b2.append('B');
            } else if (c2 == Short.TYPE) {
                b2.append('S');
            } else if (c2 == Long.TYPE) {
                b2.append('J');
            } else if (c2 == Character.TYPE) {
                b2.append('C');
            } else if (c2 == Float.TYPE) {
                b2.append('F');
            } else if (c2 == Double.TYPE) {
                b2.append('D');
            }
        } else if (c2.isArray()) {
            b2.append('[');
            ClassReader.addDescriptor(b2, c2.getComponentType());
        } else {
            b2.append('L').append(c2.getName().replace('.', '/')).append(';');
        }
    }

    protected final int readShort() {
        return this.read() << 8 | this.read();
    }

    protected final int readInt() {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    protected void skipFully(int n) throws IOException {
        while (n > 0) {
            int c2 = (int)this.skip(n);
            if (c2 <= 0) {
                throw new EOFException(Messages.getMessage("unexpectedEOF00"));
            }
            n -= c2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Member resolveMethod(int index) throws IOException, ClassNotFoundException, NoSuchMethodException {
        int oldPos = this.pos;
        try {
            Executable m = (Constructor<?>)this.cpool[index];
            if (m == null) {
                this.pos = this.cpoolIndex[index];
                Class owner = this.resolveClass(this.readShort());
                NameAndType nt = this.resolveNameAndType(this.readShort());
                String signature = nt.name + nt.type;
                if (nt.name.equals("<init>")) {
                    Constructor<?>[] ctors = owner.getConstructors();
                    for (int i2 = 0; i2 < ctors.length; ++i2) {
                        String sig = ClassReader.getSignature(ctors[i2], ctors[i2].getParameterTypes());
                        if (!sig.equals(signature)) continue;
                        this.cpool[index] = m = ctors[i2];
                        Executable executable = m;
                        return executable;
                    }
                } else {
                    Method[] methods = owner.getDeclaredMethods();
                    for (int i3 = 0; i3 < methods.length; ++i3) {
                        String sig = ClassReader.getSignature(methods[i3], methods[i3].getParameterTypes());
                        if (!sig.equals(signature)) continue;
                        m = methods[i3];
                        this.cpool[index] = m;
                        Executable executable = m;
                        return executable;
                    }
                }
                throw new NoSuchMethodException(signature);
            }
            Constructor<?> constructor = m;
            return constructor;
        }
        finally {
            this.pos = oldPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Field resolveField(int i2) throws IOException, ClassNotFoundException, NoSuchFieldException {
        int oldPos = this.pos;
        try {
            Field f2 = (Field)this.cpool[i2];
            if (f2 == null) {
                this.pos = this.cpoolIndex[i2];
                Class owner = this.resolveClass(this.readShort());
                NameAndType nt = this.resolveNameAndType(this.readShort());
                f2 = owner.getDeclaredField(nt.name);
                this.cpool[i2] = f2;
            }
            Field field = f2;
            return field;
        }
        finally {
            this.pos = oldPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NameAndType resolveNameAndType(int i2) throws IOException {
        int oldPos = this.pos;
        try {
            NameAndType nt = (NameAndType)this.cpool[i2];
            if (nt == null) {
                this.pos = this.cpoolIndex[i2];
                String name = this.resolveUtf8(this.readShort());
                String type = this.resolveUtf8(this.readShort());
                nt = new NameAndType(name, type);
                this.cpool[i2] = nt;
            }
            NameAndType nameAndType = nt;
            return nameAndType;
        }
        finally {
            this.pos = oldPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Class resolveClass(int i2) throws IOException, ClassNotFoundException {
        int oldPos = this.pos;
        try {
            Class<?> c2 = (Class<?>)this.cpool[i2];
            if (c2 == null) {
                this.pos = this.cpoolIndex[i2];
                String name = this.resolveUtf8(this.readShort());
                this.cpool[i2] = c2 = Class.forName(ClassReader.classDescriptorToName(name));
            }
            Class<?> clazz = c2;
            return clazz;
        }
        finally {
            this.pos = oldPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String resolveUtf8(int i2) throws IOException {
        int oldPos = this.pos;
        try {
            String s = (String)this.cpool[i2];
            if (s == null) {
                this.pos = this.cpoolIndex[i2];
                int len = this.readShort();
                this.skipFully(len);
                s = new String(this.buf, this.pos - len, len, "utf-8");
                this.cpool[i2] = s;
            }
            String string = s;
            return string;
        }
        finally {
            this.pos = oldPos;
        }
    }

    protected final void readCpool() throws IOException {
        int count = this.readShort();
        this.cpoolIndex = new int[count];
        this.cpool = new Object[count];
        block7: for (int i2 = 1; i2 < count; ++i2) {
            int c2 = this.read();
            this.cpoolIndex[i2] = this.pos;
            switch (c2) {
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.readShort();
                }
                case 7: 
                case 8: {
                    this.readShort();
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.readInt();
                    ++i2;
                }
                case 3: 
                case 4: {
                    this.readInt();
                    continue block7;
                }
                case 1: {
                    int len = this.readShort();
                    this.skipFully(len);
                    continue block7;
                }
                default: {
                    throw new IllegalStateException(Messages.getMessage("unexpectedBytes00"));
                }
            }
        }
    }

    protected final void skipAttributes() throws IOException {
        int count = this.readShort();
        for (int i2 = 0; i2 < count; ++i2) {
            this.readShort();
            this.skipFully(this.readInt());
        }
    }

    protected final void readAttributes() throws IOException {
        int count = this.readShort();
        for (int i2 = 0; i2 < count; ++i2) {
            int nameIndex = this.readShort();
            int attrLen = this.readInt();
            int curPos = this.pos;
            String attrName = this.resolveUtf8(nameIndex);
            Method m = (Method)this.attrMethods.get(attrName);
            if (m != null) {
                try {
                    m.invoke((Object)this, new Object[0]);
                }
                catch (IllegalAccessException e2) {
                    this.pos = curPos;
                    this.skipFully(attrLen);
                }
                catch (InvocationTargetException e3) {
                    try {
                        throw e3.getTargetException();
                    }
                    catch (Error ex) {
                        throw ex;
                    }
                    catch (RuntimeException ex) {
                        throw ex;
                    }
                    catch (IOException ex) {
                        throw ex;
                    }
                    catch (Throwable ex) {
                        this.pos = curPos;
                        this.skipFully(attrLen);
                    }
                }
                continue;
            }
            this.skipFully(attrLen);
        }
    }

    public void readCode() throws IOException {
        this.readShort();
        this.readShort();
        this.skipFully(this.readInt());
        this.skipFully(8 * this.readShort());
        this.readAttributes();
    }

    protected ClassReader(byte[] buf, Map attrMethods) {
        super(buf);
        this.attrMethods = attrMethods;
    }

    private static class NameAndType {
        String name;
        String type;

        public NameAndType(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

