/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.StringTokenizer;

public class URLHashSet
extends HashSet {
    public boolean add(URL url) {
        return super.add(URLHashSet.normalize(url));
    }

    public boolean remove(URL url) {
        return super.remove(URLHashSet.normalize(url));
    }

    public boolean contains(URL url) {
        return super.contains(URLHashSet.normalize(url));
    }

    public static URL normalize(URL url) {
        if (url.getProtocol().equals("file")) {
            try {
                File f2 = new File(URLHashSet.cleanup(url.getFile()));
                if (f2.exists()) {
                    return f2.toURL();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    private static String cleanup(String uri) {
        String[] dirty = URLHashSet.tokenize(uri, "/\\", false);
        int length = dirty.length;
        String[] clean = new String[length];
        while (true) {
            boolean path = false;
            boolean finished = true;
            int j2 = 0;
            for (int i2 = 0; i2 < length && dirty[i2] != null; ++i2) {
                if (".".equals(dirty[i2])) continue;
                if ("..".equals(dirty[i2])) {
                    clean[j2++] = dirty[i2];
                    if (!path) continue;
                    finished = false;
                    continue;
                }
                if (i2 + 1 < length && "..".equals(dirty[i2 + 1])) {
                    ++i2;
                    continue;
                }
                clean[j2++] = dirty[i2];
                path = true;
            }
            if (finished) break;
            dirty = clean;
            clean = new String[length];
        }
        StringBuffer b2 = new StringBuffer(uri.length());
        for (int i3 = 0; i3 < length && clean[i3] != null; ++i3) {
            b2.append(clean[i3]);
            if (i3 + 1 >= length || clean[i3 + 1] == null) continue;
            b2.append("/");
        }
        return b2.toString();
    }

    private static String[] tokenize(String str, String delim, boolean returnTokens) {
        StringTokenizer tokenizer = new StringTokenizer(str, delim, returnTokens);
        String[] tokens = new String[tokenizer.countTokens()];
        int i2 = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i2] = tokenizer.nextToken();
            ++i2;
        }
        return tokens;
    }
}

