/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.ant.wsdl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.axis.encoding.TypeMappingDelegate;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.tools.ant.wsdl.ComplexType;
import org.apache.axis.tools.ant.wsdl.MappingSet;
import org.apache.axis.tools.ant.wsdl.NamespaceMapping;
import org.apache.axis.tools.ant.wsdl.TypeMappingVersionEnum;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.wsdl.fromJava.Emitter;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Java2WsdlAntTask
extends Task {
    private String namespace = "";
    private String namespaceImpl = null;
    private HashMap namespaceMap = new HashMap();
    private String location = "";
    private String locationImport = null;
    private String output = ".";
    private String importSchema = null;
    private String input = null;
    private String outputImpl = null;
    private String className = ".";
    private String servicePortName = null;
    private String portTypeName = null;
    private String bindingName = null;
    private String implClass = null;
    private boolean useInheritedMethods = false;
    private String exclude = null;
    private String stopClasses = null;
    private String typeMappingVersion = "1.1";
    private String style = null;
    private String serviceElementName = null;
    private String methods = null;
    private String use = null;
    private MappingSet mappings = new MappingSet();
    private String extraClasses = null;
    private Path classpath = null;
    private String soapAction = null;
    private List complexTypes = new LinkedList();
    private boolean isDeploy = false;
    private CommandlineJava commandline = new CommandlineJava();

    public void traceParams(int logLevel) {
        this.log("Running Java2WsdlAntTask with parameters:", logLevel);
        this.log("\tnamespace:" + this.namespace, logLevel);
        this.log("\tPkgtoNS:" + this.namespaceMap, logLevel);
        this.log("\tlocation:" + this.location, logLevel);
        this.log("\toutput:" + this.output, logLevel);
        this.log("\timportSchema:" + this.importSchema, logLevel);
        this.log("\tinput:" + this.input, logLevel);
        this.log("\tclassName:" + this.className, logLevel);
        this.log("\tservicePortName:" + this.servicePortName, logLevel);
        this.log("\tportTypeName:" + this.portTypeName, logLevel);
        this.log("\tbindingName:" + this.bindingName, logLevel);
        this.log("\timplClass:" + this.implClass, logLevel);
        this.log("\tinheritance:" + this.useInheritedMethods, logLevel);
        this.log("\texcluded:" + this.exclude, logLevel);
        this.log("\tstopClasses:" + this.stopClasses, logLevel);
        this.log("\ttypeMappingVersion:" + this.typeMappingVersion, logLevel);
        this.log("\tstyle:" + this.style, logLevel);
        this.log("\toutputImpl:" + this.outputImpl, logLevel);
        this.log("\tuse:" + this.use, logLevel);
        this.log("\tnamespaceImpl:" + this.namespaceImpl, logLevel);
        this.log("\tlocationImport:" + this.locationImport, logLevel);
        this.log("\tserviceElementName:" + this.serviceElementName, logLevel);
        this.log("\tmethods:" + this.methods, logLevel);
        this.log("\textraClasses:" + this.extraClasses, logLevel);
        this.log("\tsoapAction:" + this.soapAction, logLevel);
        this.log("\tclasspath:" + this.classpath, logLevel);
    }

    protected void validate() throws BuildException {
        if (this.className == null || this.className.length() == 0) {
            throw new BuildException("No classname was specified");
        }
        if (this.location == null || this.location.length() == 0) {
            throw new BuildException("No location was specified");
        }
    }

    public void execute() throws BuildException {
        CommandlineJava.SysProperties sysProperties;
        AntClassLoader cl = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getProject(), this.classpath == null ? this.createClasspath() : this.classpath, false);
        ClassUtils.setDefaultClassLoader((ClassLoader)cl);
        if (this.extraClasses != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.extraClasses, " ,");
            while (tokenizer.hasMoreTokens()) {
                String clsName = tokenizer.nextToken();
                ClassUtils.setClassLoader(clsName, (ClassLoader)cl);
            }
        }
        if ((sysProperties = this.commandline.getSystemProperties()) != null) {
            sysProperties.setSystem();
        }
        try {
            this.traceParams(3);
            this.validate();
            Emitter emitter = new Emitter();
            this.mappings.execute((ProjectComponent)this, this.namespaceMap, true);
            if (!this.namespaceMap.isEmpty()) {
                emitter.setNamespaceMap(this.namespaceMap);
            }
            if (this.servicePortName != null) {
                emitter.setServicePortName(this.servicePortName);
            }
            if (this.portTypeName != null) {
                emitter.setPortTypeName(this.portTypeName);
            }
            if (this.bindingName != null) {
                emitter.setBindingName(this.bindingName);
            }
            this.log("Java2WSDL " + this.className, 2);
            emitter.setCls(this.className);
            if (this.implClass != null) {
                emitter.setImplCls(this.implClass);
            }
            if (this.exclude != null) {
                emitter.setDisallowedMethods(this.exclude);
            }
            if (this.stopClasses != null) {
                emitter.setStopClasses(this.stopClasses);
            }
            if (this.extraClasses != null) {
                emitter.setExtraClasses(this.extraClasses);
            }
            TypeMappingRegistryImpl tmr = new TypeMappingRegistryImpl();
            tmr.doRegisterFromVersion(this.typeMappingVersion);
            emitter.setTypeMappingRegistry(tmr);
            TypeMappingDelegate tmi = (TypeMappingDelegate)tmr.getDefaultTypeMapping();
            Iterator i2 = this.complexTypes.iterator();
            while (i2.hasNext()) {
                ((ComplexType)i2.next()).register(tmi);
            }
            if (this.style != null) {
                emitter.setStyle(this.style);
            }
            if (this.use != null) {
                emitter.setUse(this.use);
            }
            if (this.importSchema != null) {
                emitter.setInputSchema(this.importSchema);
            }
            if (this.input != null) {
                emitter.setInputWSDL(this.input);
            }
            emitter.setIntfNamespace(this.namespace);
            emitter.setImplNamespace(this.namespaceImpl);
            emitter.setLocationUrl(this.location);
            emitter.setImportUrl(this.locationImport);
            emitter.setUseInheritedMethods(this.useInheritedMethods);
            if (this.serviceElementName != null) {
                emitter.setServiceElementName(this.serviceElementName);
            }
            if (this.methods != null) {
                emitter.setAllowedMethods(this.methods);
            }
            if (this.soapAction != null) {
                emitter.setSoapAction(this.soapAction);
            }
            if (this.outputImpl == null) {
                emitter.emit(this.output, 0);
            } else {
                emitter.emit(this.output, this.outputImpl);
            }
            if (this.isDeploy) {
                this.generateServerSide(emitter, this.outputImpl != null ? this.outputImpl : this.output);
            }
        }
        catch (BuildException b2) {
            throw b2;
        }
        catch (Throwable t) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            this.log(writer.getBuffer().toString(), 0);
            throw new BuildException("Error while running " + ((Object)((Object)this)).getClass().getName(), t);
        }
        finally {
            if (sysProperties != null) {
                sysProperties.restoreSystem();
            }
        }
    }

    public void setOutput(File parameter) {
        this.output = parameter.getPath();
    }

    public void setImportSchema(File parameter) throws BuildException {
        try {
            this.importSchema = parameter.toURL().toString();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public void setInput(File parameter) {
        this.input = parameter.getPath();
    }

    public void setOutputImpl(File parameter) {
        this.outputImpl = parameter.getPath();
    }

    public void setLocation(String parameter) {
        this.location = parameter;
    }

    public void setLocationImport(String parameter) {
        this.locationImport = parameter;
    }

    public void setClassName(String parameter) {
        this.className = parameter;
    }

    public void setImplClass(String parameter) {
        this.implClass = parameter;
    }

    public void setServicePortName(String parameter) {
        this.servicePortName = parameter;
    }

    public void setPortTypeName(String parameter) {
        this.portTypeName = parameter;
    }

    public void setBindingName(String parameter) {
        this.bindingName = parameter;
    }

    public void setNamespace(String parameter) {
        this.namespace = parameter;
    }

    public void setNamespaceImpl(String parameter) {
        this.namespaceImpl = parameter;
    }

    public void setUseInheritedMethods(boolean parameter) {
        this.useInheritedMethods = parameter;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public void setStopClasses(String stopClasses) {
        this.stopClasses = stopClasses;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void addMapping(NamespaceMapping mapping) {
        this.mappings.addMapping(mapping);
    }

    public void addMappingSet(MappingSet mappingset) {
        this.mappings.addMappingSet(mappingset);
    }

    public void setTypeMappingVersion(TypeMappingVersionEnum parameter) {
        this.typeMappingVersion = parameter.getValue();
    }

    public void setMethods(String methods) {
        this.methods = methods;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public void setServiceElementName(String serviceElementName) {
        this.serviceElementName = serviceElementName;
    }

    public void setExtraClasses(String extraClasses) {
        this.extraClasses = extraClasses;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public void addComplexType(ComplexType ct) {
        this.complexTypes.add(ct);
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
            this.classpath = this.classpath.concatSystemClasspath();
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.commandline.addSysproperty(sysp);
    }

    public void setDeploy(boolean deploy) {
        this.isDeploy = deploy;
    }

    protected void generateServerSide(Emitter j2w, String wsdlFileName) throws Exception {
        Map nsmap;
        org.apache.axis.wsdl.toJava.Emitter w2j = new org.apache.axis.wsdl.toJava.Emitter();
        File wsdlFile = new File(wsdlFileName);
        w2j.setServiceDesc(j2w.getServiceDesc());
        w2j.setQName2ClassMap(j2w.getQName2ClassMap());
        w2j.setOutputDir(wsdlFile.getParent());
        w2j.setServerSide(true);
        w2j.setDeploy(true);
        w2j.setHelperWanted(true);
        String ns = j2w.getIntfNamespace();
        String clsName = j2w.getCls().getName();
        int idx = clsName.lastIndexOf(".");
        String pkg = null;
        if (idx > 0) {
            pkg = clsName.substring(0, idx);
            w2j.getNamespaceMap().put(ns, pkg);
        }
        if ((nsmap = j2w.getNamespaceMap()) != null) {
            Iterator i2 = nsmap.keySet().iterator();
            while (i2.hasNext()) {
                pkg = (String)i2.next();
                ns = (String)nsmap.get(pkg);
                w2j.getNamespaceMap().put(ns, pkg);
            }
        }
        w2j.setDeploy(true);
        if (j2w.getImplCls() != null) {
            w2j.setImplementationClassName(j2w.getImplCls().getName());
        } else if (!j2w.getCls().isInterface()) {
            w2j.setImplementationClassName(j2w.getCls().getName());
        } else {
            throw new Exception("implementation class is not specified.");
        }
        w2j.run(wsdlFileName);
    }
}

