/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.util.xml;

import com.ibm.wsdl.util.ObjectRegistry;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOM2Writer {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static String NS_URI_XML = "http://www.w3.org/XML/1998/namespace";
    private static Map xmlEncodingMap = new HashMap();

    public static String nodeToString(Node node) {
        StringWriter stringWriter = new StringWriter();
        DOM2Writer.serializeAsXML(node, stringWriter);
        return stringWriter.toString();
    }

    public static void serializeElementAsDocument(Element element, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer);
        String string = writer instanceof OutputStreamWriter ? ((OutputStreamWriter)writer).getEncoding() : null;
        String string2 = DOM2Writer.java2XMLEncoding(string);
        if (string2 != null) {
            printWriter.println("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>");
        } else {
            printWriter.println("<?xml version=\"1.0\"?>");
        }
        DOM2Writer.serializeAsXML(element, writer);
    }

    public static void serializeAsXML(Node node, Writer writer) {
        ObjectRegistry objectRegistry = new ObjectRegistry();
        objectRegistry.register("xml", NS_URI_XML);
        PrintWriter printWriter = new PrintWriter(writer);
        String string = writer instanceof OutputStreamWriter ? ((OutputStreamWriter)writer).getEncoding() : null;
        DOM2Writer.print(node, objectRegistry, printWriter, DOM2Writer.java2XMLEncoding(string));
    }

    private static void print(Node node, ObjectRegistry objectRegistry, PrintWriter printWriter, String string) {
        if (node == null) {
            return;
        }
        boolean bl = false;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                if (string != null) {
                    printWriter.println("<?xml version=\"1.0\" encoding=\"" + string + "\"?>");
                } else {
                    printWriter.println("<?xml version=\"1.0\"?>");
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                for (int k = 0; k < n; ++k) {
                    DOM2Writer.print(nodeList.item(k), objectRegistry, printWriter, string);
                }
                break;
            }
            case 1: {
                NamedNodeMap namedNodeMap;
                objectRegistry = new ObjectRegistry(objectRegistry);
                printWriter.print('<' + node.getNodeName());
                String string2 = node.getPrefix();
                String string3 = node.getNamespaceURI();
                if (string2 != null && string3 != null) {
                    boolean bl2 = false;
                    try {
                        String string4 = (String)objectRegistry.lookup(string2);
                        if (string3.equals(string4)) {
                            bl2 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (!bl2) {
                        DOM2Writer.printNamespaceDecl(node, objectRegistry, printWriter);
                    }
                }
                int n = (namedNodeMap = node.getAttributes()) != null ? namedNodeMap.getLength() : 0;
                for (int k = 0; k < n; ++k) {
                    Attr attr = (Attr)namedNodeMap.item(k);
                    printWriter.print(' ' + attr.getNodeName() + "=\"" + DOM2Writer.normalize(attr.getValue()) + '\"');
                    String string5 = attr.getPrefix();
                    String string6 = attr.getNamespaceURI();
                    if (string5 == null || string6 == null) continue;
                    boolean bl3 = false;
                    try {
                        String string7 = (String)objectRegistry.lookup(string5);
                        if (string6.equals(string7)) {
                            bl3 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (bl3) continue;
                    DOM2Writer.printNamespaceDecl(attr, objectRegistry, printWriter);
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    int n2 = nodeList.getLength();
                    boolean bl4 = bl = n2 > 0;
                    if (bl) {
                        printWriter.print('>');
                    }
                    for (int k = 0; k < n2; ++k) {
                        DOM2Writer.print(nodeList.item(k), objectRegistry, printWriter, string);
                    }
                } else {
                    bl = false;
                }
                if (bl) break;
                printWriter.print("/>");
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                break;
            }
            case 3: {
                printWriter.print(DOM2Writer.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                printWriter.print("<!--");
                printWriter.print(node.getNodeValue());
                printWriter.print("-->");
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                String string8 = node.getNodeValue();
                if (string8 != null && string8.length() > 0) {
                    printWriter.print(' ');
                    printWriter.print(string8);
                }
                printWriter.println("?>");
            }
        }
        if (s == 1 && bl) {
            printWriter.print("</");
            printWriter.print(node.getNodeName());
            printWriter.print('>');
            bl = false;
        }
    }

    public static String java2XMLEncoding(String string) {
        return (String)xmlEncodingMap.get(string);
    }

    private static void printNamespaceDecl(Node node, ObjectRegistry objectRegistry, PrintWriter printWriter) {
        switch (node.getNodeType()) {
            case 2: {
                DOM2Writer.printNamespaceDecl(((Attr)node).getOwnerElement(), node, objectRegistry, printWriter);
                break;
            }
            case 1: {
                DOM2Writer.printNamespaceDecl((Element)node, node, objectRegistry, printWriter);
            }
        }
    }

    private static void printNamespaceDecl(Element element, Node node, ObjectRegistry objectRegistry, PrintWriter printWriter) {
        String string = node.getNamespaceURI();
        String string2 = node.getPrefix();
        if (!string.equals(NS_URI_XMLNS) || !string2.equals("xmlns")) {
            if (DOMUtils.getAttributeNS(element, NS_URI_XMLNS, string2) == null) {
                printWriter.print(" xmlns:" + string2 + "=\"" + string + '\"');
            }
        } else {
            string2 = node.getLocalName();
            string = node.getNodeValue();
        }
        objectRegistry.register(string2, string);
    }

    private static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int k = 0; k < n; ++k) {
            char c2 = string.charAt(k);
            switch (c2) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    if (k > 0) {
                        char c3 = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c3 != '\r') {
                            stringBuffer.append(StringUtils.lineSeparator);
                            continue block7;
                        }
                        stringBuffer.append('\n');
                        continue block7;
                    }
                    stringBuffer.append(StringUtils.lineSeparator);
                    continue block7;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    static {
        xmlEncodingMap.put(null, "UTF-8");
        xmlEncodingMap.put(System.getProperty("file.encoding"), "UTF-8");
        xmlEncodingMap.put("UTF8", "UTF-8");
        xmlEncodingMap.put("UTF-16", "UTF-16");
        xmlEncodingMap.put("UnicodeBig", "UTF-16");
        xmlEncodingMap.put("UnicodeLittle", "UTF-16");
        xmlEncodingMap.put("ASCII", "US-ASCII");
        xmlEncodingMap.put("ISO8859_1", "ISO-8859-1");
        xmlEncodingMap.put("ISO8859_2", "ISO-8859-2");
        xmlEncodingMap.put("ISO8859_3", "ISO-8859-3");
        xmlEncodingMap.put("ISO8859_4", "ISO-8859-4");
        xmlEncodingMap.put("ISO8859_5", "ISO-8859-5");
        xmlEncodingMap.put("ISO8859_6", "ISO-8859-6");
        xmlEncodingMap.put("ISO8859_7", "ISO-8859-7");
        xmlEncodingMap.put("ISO8859_8", "ISO-8859-8");
        xmlEncodingMap.put("ISO8859_9", "ISO-8859-9");
        xmlEncodingMap.put("ISO8859_13", "ISO-8859-13");
        xmlEncodingMap.put("ISO8859_15_FDIS", "ISO-8859-15");
        xmlEncodingMap.put("GBK", "GBK");
        xmlEncodingMap.put("Big5", "Big5");
    }
}

