/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.VectorSelectionEvent;
import com.borland.jbcl.model.VectorSelectionListener;
import com.borland.jbcl.model.WritableVectorSelection;
import java.io.Serializable;
import java.util.EventListener;

public class SingleVectorSelection
implements WritableVectorSelection,
Serializable {
    private int index = -1;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private boolean events = true;

    public SingleVectorSelection() {
    }

    public SingleVectorSelection(int location) {
        this.index = location;
    }

    public boolean contains(int location) {
        return location == this.index;
    }

    public int getCount() {
        return this.index != -1 ? 1 : 0;
    }

    public int[] getAll() {
        int[] contents = new int[this.index != -1 ? 1 : 0];
        if (this.index != -1) {
            contents[0] = this.index;
        }
        return contents;
    }

    public void addSelectionListener(VectorSelectionListener listener) {
        this.selectionListeners.add((EventListener)listener);
    }

    public void removeSelectionListener(VectorSelectionListener listener) {
        this.selectionListeners.remove((EventListener)listener);
    }

    public void set(int[] locations) {
        this.add(locations);
    }

    public void add(int location) {
        if (this.index != location) {
            this.index = location;
            this.processSelectionEvent(new VectorSelectionEvent(this, 12290));
        }
    }

    public void add(int[] locations) {
        if (locations.length > 0 && this.index != locations[0]) {
            this.index = locations[0];
            this.processSelectionEvent(new VectorSelectionEvent(this, 12290));
        }
    }

    public void addRange(int begin, int end) {
        if (this.index != end) {
            this.index = end;
            this.processSelectionEvent(new VectorSelectionEvent(this, 12290));
        }
    }

    public void remove(int location) {
        if (this.index == location) {
            this.index = -1;
            this.processSelectionEvent(new VectorSelectionEvent(this, 12289));
        }
    }

    public void remove(int[] locations) {
        for (int i2 = 0; i2 < locations.length; ++i2) {
            if (this.index != locations[i2]) continue;
            this.index = -1;
            this.processSelectionEvent(new VectorSelectionEvent(this, 12289));
            return;
        }
    }

    public void removeRange(int begin, int end) {
        if (this.index >= begin || this.index <= end) {
            this.index = -1;
            this.processSelectionEvent(new VectorSelectionEvent(this, 12289));
        }
    }

    public void removeAll() {
        if (this.index != -1) {
            this.index = -1;
            this.processSelectionEvent(new VectorSelectionEvent(this, 12289));
        }
    }

    public void enableSelectionEvents(boolean enable) {
        this.events = enable;
        if (this.events) {
            this.processSelectionEvent(new VectorSelectionEvent(this, 12290));
        }
    }

    protected void processSelectionEvent(VectorSelectionEvent e2) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch((DispatchableEvent)e2);
        }
    }

    public final String toString() {
        String cn = this.getClass().getName();
        return cn.substring(cn.lastIndexOf(46) + 1) + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "index=" + this.index;
    }
}

