/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jb.util.ExceptionHandler;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixModelEvent;
import com.borland.jbcl.model.MatrixModelListener;
import com.borland.jbcl.model.MatrixViewManager;
import com.borland.jbcl.model.WritableMatrixModel;
import java.awt.Component;
import java.util.EventListener;

public class MatrixDataSetManager
implements WritableMatrixModel,
MatrixViewManager,
DataChangeListener,
ExceptionHandler {
    private DataSet dataSet;
    private DataSetModel[] dataSetModels;
    private boolean events = true;
    private transient EventMulticaster modelListeners = new EventMulticaster();

    public MatrixDataSetManager(DataSet dataSet, Column[] columns) {
        this(dataSet, columns, null);
    }

    public MatrixDataSetManager(DataSet dataSet, Column[] columns, Component component) {
        this.dataSet = dataSet;
        this.dataSetModels = new DataSetModel[columns.length];
        for (int i2 = 0; i2 < columns.length; ++i2) {
            this.dataSetModels[i2] = new DataSetModel(dataSet, columns[i2], component);
        }
    }

    public Object get(int row, int column) {
        return this.dataSetModels.length > column ? this.dataSetModels[column].get(row) : null;
    }

    public MatrixLocation find(Object data) {
        return null;
    }

    public int getColumnCount() {
        return this.dataSetModels.length;
    }

    public void addModelListener(MatrixModelListener listener) {
        this.modelListeners.add((EventListener)listener);
        if (this.modelListeners.getListenerCount() == 1) {
            this.dataSet.addDataChangeListener((DataChangeListener)this);
        }
    }

    public void removeModelListener(MatrixModelListener listener) {
        this.modelListeners.remove((EventListener)listener);
        if (this.modelListeners.getListenerCount() == 0) {
            this.dataSet.removeDataChangeListener((DataChangeListener)this);
        }
    }

    public boolean canSet(int row, int column, boolean startEdit) {
        return this.dataSetModels.length > column ? this.dataSetModels[column].canSet(row, startEdit) : false;
    }

    public void set(int row, int column, Object data) {
        if (this.dataSetModels.length > column) {
            this.dataSetModels[column].set(row, data);
            this.processModelEvent(new MatrixModelEvent(this, 17, new MatrixLocation(row, column)));
        }
    }

    public void touched(int row, int column) {
        if (this.dataSetModels.length > column) {
            this.processModelEvent(new MatrixModelEvent(this, 33, new MatrixLocation(row, column)));
        }
    }

    public boolean isVariableRows() {
        return true;
    }

    public int getRowCount() {
        return this.dataSetModels.length > 0 ? this.dataSetModels[0].getRowCount() : 0;
    }

    public final void addRow() {
        if (this.dataSetModels.length > 0) {
            this.dataSetModels[0].addRow();
        }
    }

    public void addRow(int aheadOf) {
        if (this.dataSetModels.length > 0) {
            this.dataSetModels[0].addRow(aheadOf);
        }
    }

    public final void removeRow(int row) {
        if (this.dataSetModels.length > 0) {
            this.dataSetModels[0].removeRow(row);
        }
    }

    public void removeAllRows() {
    }

    public boolean isVariableColumns() {
        return false;
    }

    public void addColumn() {
    }

    public void addColumn(int aheadOf) {
    }

    public void removeColumn(int column) {
    }

    public void removeAllColumns() {
    }

    public void enableModelEvents(boolean enable) {
        if (this.events != enable) {
            this.events = enable;
            if (enable) {
                this.processModelEvent(new MatrixModelEvent(this, 2));
            }
        }
    }

    public ItemPainter getPainter(int row, int column, Object value, int state) {
        return this.dataSetModels.length > column ? this.dataSetModels[column].getPainter(row, value) : null;
    }

    public ItemEditor getEditor(int row, int column, Object value, int state) {
        return this.dataSetModels.length > column ? this.dataSetModels[column].getEditor() : null;
    }

    private void processModelEvent(MatrixModelEvent e2) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)e2);
        }
    }

    public void dataChanged(DataChangeEvent e2) {
        switch (e2.getID()) {
            case 1: {
                this.processModelEvent(new MatrixModelEvent(this, 18, new MatrixLocation(e2.getRowAffected(), 0)));
                break;
            }
            case 2: {
                this.processModelEvent(new MatrixModelEvent(this, 34, new MatrixLocation(e2.getRowAffected(), 0)));
                break;
            }
            case 3: 
            case 4: {
                this.processModelEvent(new MatrixModelEvent(this, 49, new MatrixLocation(e2.getRowAffected(), 0)));
                break;
            }
            case 5: {
                this.processModelEvent(new MatrixModelEvent(this, 2));
                break;
            }
        }
    }

    public void postRow(DataChangeEvent e2) throws Exception {
    }

    public void handleException(Exception x) {
        if (this.dataSetModels.length > 0 && this.dataSetModels[0] != null) {
            this.dataSetModels[0].handleThisException(x);
        }
    }
}

