/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.MessageDialog;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.util.ActionMulticaster;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;

public class Message
implements WindowListener,
Serializable {
    public static final int OK = 1;
    public static final int YES = 2;
    public static final int NO = 4;
    public static final int CANCEL = 8;
    public static final int OK_CANCEL = 9;
    public static final int YES_NO = 6;
    public static final int YES_NO_CANCEL = 14;
    protected MessageDialog dialog;
    protected Frame frame;
    protected String title;
    protected String message;
    protected int buttonSet = 1;
    protected String[] labels;
    protected int result;
    protected transient ActionMulticaster actionMulticaster = new ActionMulticaster();

    public Message(Frame frame, String title, String msg) {
        this.frame = frame;
        this.title = title;
        this.message = msg;
        if (frame != null) {
            this.dialog = new MessageDialog(frame, title, msg);
            this.dialog.addWindowListener(this);
        }
    }

    public Message(Frame frame, String title) {
        this(frame, title, "");
    }

    public Message(Frame frame) {
        this(frame, "", "");
    }

    public Message() {
        this(null, "", "");
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.dialog != null) {
            this.dialog.setTitle(title);
        }
    }

    public String getTitle() {
        if (this.dialog != null) {
            this.title = this.dialog.getTitle();
        }
        return this.title;
    }

    public void setMessage(String message) {
        this.message = message;
        if (this.dialog != null) {
            this.dialog.setMessage(message);
        }
    }

    public String getMessage() {
        if (this.dialog != null) {
            this.message = this.dialog.getMessage();
        }
        return this.message;
    }

    public void setButtonSet(int bs) {
        if (bs != this.buttonSet) {
            this.buttonSet = bs;
            if (this.dialog != null) {
                this.dialog.setButtonSet(bs);
            }
        }
    }

    public int getButtonSet() {
        return this.buttonSet;
    }

    public void setLabels(String[] l) {
        this.labels = new String[l.length];
        System.arraycopy(l, 0, this.labels, 0, l.length);
        if (this.dialog != null) {
            this.dialog.setLabels(l);
        }
    }

    public String[] getLabels() {
        if (this.dialog != null) {
            this.labels = this.dialog.getLabels();
        }
        return this.labels;
    }

    public void setResult(int i2) {
        this.result = i2;
        if (this.dialog != null) {
            this.dialog.setResult(this.result);
        }
    }

    public int getResult() {
        if (this.dialog != null) {
            this.result = this.dialog.getResult();
        }
        return this.result;
    }

    public void show() {
        this.setVisible(true);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.dialog == null) {
                if (this.frame == null) {
                    throw new IllegalStateException(Res._NoFrame);
                }
                this.dialog = new MessageDialog(this.frame, this.title, this.message);
                if (this.buttonSet >= 0) {
                    this.dialog.setButtonSet(this.buttonSet);
                }
                if (this.labels != null) {
                    this.dialog.setLabels(this.labels);
                }
                this.dialog.setResult(this.result);
                this.dialog.addWindowListener(this);
                this.dialog.addActionListener(this.actionMulticaster);
            }
            this.dialog.pack();
            this.dialog.show();
        } else if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    public boolean isVisible() {
        return this.dialog != null ? this.dialog.isVisible() : false;
    }

    public void addActionListener(ActionListener l) {
        this.actionMulticaster.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionMulticaster.remove(l);
    }

    public void windowOpened(WindowEvent e2) {
    }

    public void windowClosing(WindowEvent e2) {
        this.result = this.dialog.getResult();
    }

    public void windowClosed(WindowEvent e2) {
        if (this.dialog != null) {
            this.result = this.dialog.getResult();
        }
        this.dialog = null;
        if (this.frame.isShowing()) {
            if (this.frame.getFocusOwner() != null) {
                this.frame.getFocusOwner().requestFocus();
            } else {
                this.frame.requestFocus();
            }
        }
    }

    public void windowIconified(WindowEvent e2) {
    }

    public void windowDeiconified(WindowEvent e2) {
    }

    public void windowActivated(WindowEvent e2) {
    }

    public void windowDeactivated(WindowEvent e2) {
    }
}

