/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.jbcl.control.ColorChooser;
import com.borland.jbcl.control.FontChooser;
import com.borland.jbcl.control.GridControl;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.control.StringInput;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.view.ColumnView;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.MessageFormat;

class GridControl_PopupSupport
extends MouseAdapter
implements ActionListener,
KeyListener,
Serializable {
    public static final String CAPTION = Res._Caption;
    public static final String ALIGNMENT = Res._Alignment;
    public static final String LEFT = Res._AlignLeft;
    public static final String RIGHT = Res._AlignRight;
    public static final String CENTER = Res._AlignCenter;
    public static final String HSTRETCH = Res._AlignHStretch;
    public static final String TOP = Res._AlignTop;
    public static final String MIDDLE = Res._AlignMiddle;
    public static final String BOTTOM = Res._AlignBottom;
    public static final String VSTRETCH = Res._AlignVStretch;
    public static final String SORT = Res._ToggleSort;
    public static final String POST = Res._PostChanges;
    public static final String CANCELROW = Res._CancelRow;
    public static final String INSERTROW = Res._InsertRow;
    public static final String DELETEROW = Res._DeleteRow;
    public static final String INSERTCOLUMN = Res._InsertColumn;
    public static final String DELETECOLUMN = Res._DeleteColumn;
    public static final String BACKGROUND = Res._PickBackground;
    public static final String FOREGROUND = Res._PickForeground;
    public static final String FONT = Res._PickFont;
    private PopupMenu pop = new PopupMenu();
    private GridControl grid;
    private MatrixLocation hit;
    private boolean alive = true;
    private Font popupFont = new Font("dialog", 0, 12);

    public GridControl_PopupSupport(GridControl grid) {
        this.grid = grid;
        this.pop.addActionListener(this);
        grid.getCoreComponent().add(this.pop);
    }

    public void setAlive(boolean show) {
        this.alive = show;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void mouseReleased(MouseEvent e2) {
        if (e2.isPopupTrigger() && this.alive) {
            this.itemInspected(e2.getX(), e2.getY());
        }
    }

    public void keyPressed(KeyEvent e2) {
        if (e2.isConsumed() || e2.isControlDown()) {
            return;
        }
        int key = e2.getKeyCode();
        boolean shift = e2.isShiftDown();
        boolean alt = e2.isAltDown();
        if ((key == 121 && shift && !alt || key == 10 && alt && !shift) && this.alive) {
            Rectangle r = this.grid.getCellRect(this.grid.getSubfocus());
            this.itemInspected(r.x + r.width, r.y);
        }
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void keyTyped(KeyEvent e2) {
    }

    private void addPopupItem(Menu menu, String label) {
        MenuItem menuItem = new MenuItem(label);
        menuItem.setFont(menu.getFont());
        menu.add(menuItem);
    }

    void itemInspected(int x, int y) {
        if (this.grid.getColumnCount() == 0) {
            return;
        }
        this.hit = this.grid.getSubfocus();
        this.popupFont = this.grid.getFont();
        this.pop.setFont(this.popupFont);
        this.pop.removeAll();
        boolean sep = false;
        DataSet ds = this.grid.getDataSet();
        if (this.hit != null) {
            String caption;
            ColumnView cv = this.grid.getColumnView(this.hit.column);
            String string = caption = cv != null ? cv.getCaption() : null;
            if (caption == null) {
                caption = MessageFormat.format(Res._Column, String.valueOf(this.hit.column));
            }
            int r = ds != null ? ds.getRow() + 1 : this.hit.row;
            this.addPopupItem(this.pop, MessageFormat.format(Res._GridPopupTitle, caption, String.valueOf(r)));
            this.pop.addSeparator();
            this.addPopupItem(this.pop, CAPTION);
            this.addPopupItem(this.pop, BACKGROUND);
            this.addPopupItem(this.pop, FOREGROUND);
            this.addPopupItem(this.pop, FONT);
            Menu align = new Menu(ALIGNMENT);
            align.setFont(this.popupFont);
            this.addPopupItem(align, LEFT);
            this.addPopupItem(align, CENTER);
            this.addPopupItem(align, RIGHT);
            this.addPopupItem(align, HSTRETCH);
            align.addSeparator();
            this.addPopupItem(align, TOP);
            this.addPopupItem(align, MIDDLE);
            this.addPopupItem(align, BOTTOM);
            this.addPopupItem(align, VSTRETCH);
            this.pop.add(align);
            align.addActionListener(this);
        } else {
            sep = true;
        }
        if (ds != null) {
            if (this.hit != null && this.grid.isSortOnHeaderClick() && this.grid.getRowCount() > 0) {
                if (!sep) {
                    this.pop.addSeparator();
                    sep = true;
                }
                this.addPopupItem(this.pop, SORT);
            }
            if (ds.isEditing() && !this.grid.isReadOnly()) {
                if (!sep) {
                    this.pop.addSeparator();
                    sep = true;
                }
                this.addPopupItem(this.pop, POST);
                this.addPopupItem(this.pop, CANCELROW);
            }
            if (!ds.isEditingNewRow() && !this.grid.isReadOnly() && (ds.isEnableInsert() || ds.isEnableDelete())) {
                if (!sep) {
                    this.pop.addSeparator();
                    sep = true;
                }
                if (ds.isEnableInsert()) {
                    this.addPopupItem(this.pop, INSERTROW);
                }
                if (ds.isEnableDelete()) {
                    this.addPopupItem(this.pop, DELETEROW);
                }
            }
        } else {
            if (this.grid.isVariableRows()) {
                if (!sep) {
                    this.pop.addSeparator();
                    sep = true;
                }
                this.addPopupItem(this.pop, INSERTROW);
                if (this.hit != null) {
                    this.addPopupItem(this.pop, DELETEROW);
                }
            }
            if (this.grid.isVariableColumns()) {
                if (!sep) {
                    this.pop.addSeparator();
                    sep = true;
                }
                this.addPopupItem(this.pop, INSERTCOLUMN);
                if (this.hit != null) {
                    this.addPopupItem(this.pop, DELETECOLUMN);
                }
            }
        }
        this.pop.show(this.grid.getCoreComponent(), x, y);
    }

    public void actionPerformed(ActionEvent e2) {
        DataSet ds = this.grid.getDataSet();
        ColumnView cv = this.hit != null ? this.grid.getColumnView(this.hit.column) : null;
        String a2 = e2.getActionCommand();
        int align = cv.getAlignment();
        if (a2 == LEFT) {
            align &= 0xFFFFFFF0;
            cv.setAlignment(align |= 1);
        } else if (a2 == CENTER) {
            align &= 0xFFFFFFF0;
            cv.setAlignment(align |= 2);
        } else if (a2 == RIGHT) {
            align &= 0xFFFFFFF0;
            cv.setAlignment(align |= 3);
        } else if (a2 == HSTRETCH) {
            align &= 0xFFFFFFF0;
            cv.setAlignment(align |= 4);
        } else if (a2 == TOP) {
            align &= 0xFFFFFF0F;
            cv.setAlignment(align |= 0x10);
        } else if (a2 == MIDDLE) {
            align &= 0xFFFFFF0F;
            cv.setAlignment(align |= 0x20);
        } else if (a2 == BOTTOM) {
            align &= 0xFFFFFF0F;
            cv.setAlignment(align |= 0x30);
        } else if (a2 == VSTRETCH) {
            align &= 0xFFFFFF0F;
            cv.setAlignment(align |= 0x40);
        } else if (a2 == SORT) {
            this.grid.toggleColumnSort(this.hit.column);
        } else if (a2 == CAPTION) {
            cv.setCaption(this.chooseString(Res._CaptionCaption, cv.getCaption()));
        } else if (a2 == BACKGROUND) {
            cv.setBackground(this.chooseColor(Res._BGColorCaption, cv.getBackground()));
        } else if (a2 == FOREGROUND) {
            cv.setForeground(this.chooseColor(Res._FGColorCaption, cv.getForeground()));
        } else if (a2 == FONT) {
            cv.setFont(this.chooseFont(Res._FontCaption, cv.getFont()));
        } else if (a2 == CANCELROW) {
            if (ds != null) {
                try {
                    ds.cancel();
                }
                catch (DataSetException x) {}
            }
        } else if (a2 == POST) {
            if (ds != null) {
                try {
                    ds.post();
                }
                catch (DataSetException x) {}
            }
        } else if (a2 == INSERTROW) {
            if (ds != null) {
                try {
                    ds.insertRow(true);
                }
                catch (DataSetException x) {}
            } else if (this.grid.isVariableRows()) {
                if (this.hit != null) {
                    this.grid.addRow(this.hit.row);
                } else {
                    this.grid.addRow();
                }
            }
        } else if (a2 == DELETEROW) {
            if (ds != null) {
                try {
                    ds.deleteRow();
                }
                catch (DataSetException x) {}
            } else if (this.grid.isVariableRows()) {
                this.grid.removeRow(this.hit.row);
            }
        } else if (a2 == INSERTCOLUMN) {
            if (this.grid.isVariableColumns()) {
                if (this.hit != null) {
                    this.grid.addColumn(this.hit.column);
                } else {
                    this.grid.addColumn();
                }
            }
        } else if (a2 == DELETECOLUMN && this.grid.isVariableColumns()) {
            this.grid.removeColumn(this.hit.column);
        }
    }

    Frame findFrame() {
        Container component;
        for (component = this.grid; component != null && !(component instanceof Frame); component = component.getParent()) {
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return null;
    }

    Color chooseColor(String title, Color color) {
        Frame f2 = this.findFrame();
        if (f2 == null) {
            return null;
        }
        Color old = color;
        ColorChooser cc = new ColorChooser(f2, title, color);
        cc.setValue(color);
        cc.show();
        this.grid.requestFocus();
        if (cc.getResult() == 1) {
            return cc.getValue();
        }
        return old;
    }

    Font chooseFont(String title, Font font) {
        Frame f2 = this.findFrame();
        if (f2 == null) {
            return null;
        }
        Font old = font;
        FontChooser fc = new FontChooser(f2, title, font);
        fc.setValue(font);
        fc.show();
        this.grid.requestFocus();
        if (fc.getResult() == 1) {
            return fc.getValue();
        }
        return old;
    }

    String chooseString(String title, String string) {
        Frame f2 = this.findFrame();
        if (f2 == null) {
            return null;
        }
        String old = string;
        StringInput si = new StringInput(f2, title, string);
        si.setValue(string);
        si.show();
        this.grid.requestFocus();
        if (si.getResult() == 1) {
            return si.getValue();
        }
        return old;
    }
}

