/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.Res;
import com.borland.jbcl.util.ImageLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.SystemColor;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;

public class DecoratedFrame
extends Frame
implements Serializable {
    protected Component client;
    protected boolean exitOnClose = true;
    protected boolean disposeOnClose = true;
    protected String imageName;
    protected URL url;

    public DecoratedFrame() {
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.control);
        this.enableEvents(64L);
    }

    public Component getClient() {
        return this.client;
    }

    public void setClient(Component client) {
        if (this.client != null) {
            this.remove(this.client);
        }
        this.client = client;
        super.add(this.client, "Center");
        Dimension cs = client.getSize();
        if (cs.width > 0 && cs.height > 0) {
            int w = cs.width + this.getInsets().left + this.getInsets().right;
            int h2 = cs.height + this.getInsets().top + this.getInsets().bottom;
            this.setSize(w, h2);
        }
    }

    public void setDisposeOnClose(boolean dispose) {
        this.disposeOnClose = dispose;
    }

    public boolean isDisposeOnClose() {
        return this.disposeOnClose;
    }

    public void setExitOnClose(boolean eoc) {
        this.exitOnClose = eoc;
    }

    public boolean isExitOnClose() {
        return this.exitOnClose;
    }

    public void setIconImageName(String path) throws IOException {
        if (path != null && !path.equals("")) {
            this.setupImage(ImageLoader.load(path, (Component)this), path);
        } else {
            this.imageName = null;
            super.setIconImage(null);
        }
    }

    public String getIconImageName() {
        return this.imageName;
    }

    public void setIconImage(Image image) {
        try {
            this.setupImage(image, "");
        }
        catch (IOException x) {
            throw new IllegalArgumentException(x.getMessage());
        }
    }

    public void setIconImageURL(URL url) throws IOException {
        this.url = url;
        this.setupImage(ImageLoader.load(url, (Component)this), url.toString());
    }

    public URL getIconImageURL() {
        return this.url;
    }

    protected void setupImage(Image im, String path) throws IOException {
        this.prepareImage(im, this);
        if ((this.checkImage(im, this) & 0x40) != 0) {
            throw new IOException(MessageFormat.format(Res._FileNotFound, path));
        }
        this.imageName = path;
        super.setIconImage(im);
    }

    protected void processWindowEvent(WindowEvent e2) {
        super.processWindowEvent(e2);
        if (e2.getID() == 201 && this.disposeOnClose) {
            this.dispose();
        } else if (e2.getID() == 202 && this.exitOnClose && !Beans.isDesignTime()) {
            System.exit(0);
        }
    }

    public Dimension getPreferredSize() {
        Dimension d2 = super.getPreferredSize();
        MenuBar m = this.getMenuBar();
        if (m != null) {
            Font f2 = m.getFont();
            FontMetrics fm = f2 != null ? this.getFontMetrics(f2) : null;
            int h2 = fm != null ? fm.getHeight() : 0;
            d2.height += h2;
        }
        return d2;
    }
}

