/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.BevelPanel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.FocusMulticaster;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.ItemMulticaster;
import com.borland.jbcl.util.KeyMulticaster;
import com.borland.jbcl.util.MouseMulticaster;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;

public class CheckboxPanel
extends BevelPanel
implements BlackBox,
Serializable {
    private int orientation = 0;
    private CheckboxGroup group;
    private int groupSelectedIndex = -1;
    private String groupSelectedLabel;
    private GridLayout gridLayout = new GridLayout();
    private transient ItemMulticaster itemMulticaster = new ItemMulticaster();
    private transient FocusMulticaster focusMulticaster = new FocusMulticaster();
    private transient KeyMulticaster keyMulticaster = new KeyMulticaster();
    private transient MouseMulticaster mouseMulticaster = new MouseMulticaster();
    protected String textureName;

    public CheckboxPanel() {
        super.setLayout(this.gridLayout);
        this.setMargins(new Insets(6, 6, 6, 6));
        this.setBevelInner(1);
        this.setBevelOuter(2);
        this.setOrientation(1);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            this.getComponent(i2).setEnabled(enabled);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            this.getComponent(i2).setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            this.getComponent(i2).setForeground(color);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            this.getComponent(i2).invalidate();
        }
    }

    public void setOrientation(int o) {
        if (this.orientation != o) {
            this.orientation = o;
            this.gridLayout.setColumns(1);
            this.gridLayout.setRows(this.orientation == 0 ? 1 : 0);
            this.gridLayout.setColumns(this.orientation == 0 ? 0 : 1);
            this.invalidate();
            this.repaint(100L);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setGrouped(boolean grouped) {
        if (grouped != (this.group != null)) {
            this.group = grouped ? new CheckboxGroup() : null;
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                ((Checkbox)this.getComponent(i2)).setCheckboxGroup(this.group);
            }
        }
        if (grouped && (this.groupSelectedIndex > 0 || this.groupSelectedLabel != null)) {
            if (this.groupSelectedIndex > 0) {
                this.setSelectedIndex(this.groupSelectedIndex);
            } else {
                this.setSelectedLabel(this.groupSelectedLabel);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String path) {
        if (path != null && !path.equals("")) {
            Image i2 = ImageLoader.load(path, (Component)this);
            if (i2 == null) throw new IllegalArgumentException(path);
            ImageLoader.waitForImage(this, i2);
            this.textureName = path;
            this.setTexture(i2);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public void setLayout(LayoutManager layout) {
    }

    public boolean isGrouped() {
        return this.group != null;
    }

    public void setLabels(String[] labels) {
        int count = this.getComponentCount();
        for (int c2 = 0; c2 < count; ++c2) {
            Checkbox cbox = (Checkbox)this.getComponent(c2);
            cbox.removeItemListener(this.itemMulticaster);
            cbox.removeFocusListener(this.focusMulticaster);
            cbox.removeKeyListener(this.keyMulticaster);
            cbox.removeMouseListener(this.mouseMulticaster);
        }
        this.removeAll();
        if (labels != null) {
            for (int i2 = 0; i2 < labels.length; ++i2) {
                Checkbox cb = new Checkbox(labels[i2], false, this.group);
                cb.addItemListener(this.itemMulticaster);
                cb.addFocusListener(this.focusMulticaster);
                cb.addKeyListener(this.keyMulticaster);
                cb.addMouseListener(this.mouseMulticaster);
                cb.setEnabled(this.isEnabled());
                this.add(cb);
            }
        }
        this.repaint(100L);
    }

    public String[] getLabels() {
        String[] labels = new String[this.getComponentCount()];
        for (int i2 = 0; i2 < labels.length; ++i2) {
            labels[i2] = ((Checkbox)this.getComponent(i2)).getLabel();
        }
        return labels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedLabels(String[] selectedLabels) {
        Vector<String> sLabs = new Vector<String>();
        String[] stringArray = selectedLabels;
        synchronized (selectedLabels) {
            int i2;
            int count = selectedLabels.length;
            for (i2 = 0; i2 < count; ++i2) {
                sLabs.addElement(selectedLabels[i2]);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            int count2 = this.getComponentCount();
            for (i2 = 0; i2 < count2; ++i2) {
                Checkbox cb = (Checkbox)this.getComponent(i2);
                cb.setState(sLabs.contains(cb.getLabel()));
            }
            return;
        }
    }

    public String[] getSelectedLabels() {
        String[] labels = new String[this.getComponentCount()];
        int selCount = 0;
        for (int i2 = 0; i2 < labels.length; ++i2) {
            Checkbox cb = (Checkbox)this.getComponent(i2);
            if (!cb.getState()) continue;
            ++selCount;
            labels[i2] = cb.getLabel();
        }
        String[] selectedLabels = new String[selCount];
        if (selCount > 0) {
            int count = 0;
            for (int i3 = 0; i3 < labels.length; ++i3) {
                if (labels[i3] == null) continue;
                selectedLabels[count++] = labels[i3];
            }
        }
        return selectedLabels;
    }

    public void setLabel(int index, String label) {
        ((Checkbox)this.getComponent(index)).setLabel(label);
    }

    public void addLabel(String label) {
        Checkbox cb = new Checkbox(label, false, this.group);
        cb.addItemListener(this.itemMulticaster);
        cb.addFocusListener(this.focusMulticaster);
        cb.addKeyListener(this.keyMulticaster);
        cb.addMouseListener(this.mouseMulticaster);
        cb.setEnabled(this.isEnabled());
        this.add(cb);
        this.repaint(100L);
    }

    public String getLabel(int index) {
        return ((Checkbox)this.getComponent(index)).getLabel();
    }

    public void setSelectedIndex(int index) {
        if (this.group != null) {
            this.group.setSelectedCheckbox((Checkbox)this.getComponent(index));
        } else {
            this.groupSelectedIndex = index;
        }
    }

    public int getSelectedIndex() {
        if (this.group != null) {
            Checkbox cb = this.group.getSelectedCheckbox();
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                if (this.getComponent(i2) != cb) continue;
                return i2;
            }
        }
        return -1;
    }

    public void setSelectedLabel(String label) {
        if (this.group != null) {
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                Checkbox cb = (Checkbox)this.getComponent(i2);
                if (!cb.getLabel().equals(label)) continue;
                this.group.setSelectedCheckbox(cb);
                return;
            }
        } else {
            this.groupSelectedLabel = label;
        }
    }

    public String getSelectedLabel() {
        Checkbox scb;
        if (this.group != null && (scb = this.group.getSelectedCheckbox()) != null) {
            return scb.getLabel();
        }
        return null;
    }

    public void addFocusListener(FocusListener l) {
        if (this.focusMulticaster == null) {
            super.addFocusListener(l);
        } else {
            this.focusMulticaster.add(l);
        }
    }

    public void removeFocusListener(FocusListener l) {
        this.focusMulticaster.remove(l);
    }

    public void addKeyListener(KeyListener l) {
        this.keyMulticaster.add(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.keyMulticaster.remove(l);
    }

    public void addItemListener(ItemListener l) {
        this.itemMulticaster.add(l);
    }

    public void removeItemListener(ItemListener l) {
        this.itemMulticaster.remove(l);
    }

    public void addMouseListener(MouseListener l) {
        this.mouseMulticaster.add(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.mouseMulticaster.remove(l);
    }
}

