/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.ant.wsdl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.apache.axis.tools.ant.wsdl.Mapper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;

public class NamespaceMapping
implements Mapper {
    private String namespace = null;
    private String packageName = null;
    private File mappingFile;

    public void setNamespace(String value) {
        this.namespace = value;
    }

    public void setPackage(String value) {
        this.packageName = value;
    }

    public void setFile(File file) {
        this.mappingFile = file;
    }

    protected void map(ProjectComponent owner, HashMap map, String packName, String nspace, boolean packageIsKey) {
        owner.log("mapping " + nspace + " to " + packName, 3);
        if (packageIsKey) {
            map.put(packName, nspace);
        } else {
            map.put(nspace, packName);
        }
    }

    private void validate() {
        if (this.mappingFile != null) {
            if (this.namespace != null || this.packageName != null) {
                throw new BuildException("Namespace or Package cannot be used with a File attribute");
            }
        } else {
            if (this.namespace == null) {
                throw new BuildException("namespace must be defined");
            }
            if (this.packageName == null) {
                throw new BuildException("package must be defined");
            }
        }
    }

    protected void mapFile(ProjectComponent owner, HashMap map, boolean packageIsKey) throws BuildException {
        Properties props = this.loadMappingPropertiesFile();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String packageName = (String)keys.nextElement();
            String namespace = props.getProperty(packageName);
            this.map(owner, map, packageName, namespace, packageIsKey);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadMappingPropertiesFile() throws BuildException {
        Properties props = new Properties();
        FileInputStream instr = null;
        try {
            try {
                instr = new FileInputStream(this.mappingFile);
                props.load(new BufferedInputStream(instr));
            }
            catch (IOException e3) {
                throw new BuildException("Failed to load " + this.mappingFile, (Throwable)e3);
            }
            Object var5_3 = null;
            if (instr == null) return props;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (instr == null) throw throwable;
            try {
                instr.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e2) {}
        instr.close();
        return props;
    }

    public void execute(ProjectComponent owner, HashMap map, boolean packageIsKey) throws BuildException {
        this.validate();
        if (this.mappingFile != null) {
            this.mapFile(owner, map, packageIsKey);
        } else {
            this.map(owner, map, this.packageName, this.namespace, packageIsKey);
        }
    }
}

