/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class WSDDElement
extends WSDDConstants
implements Serializable {
    private String name;

    public WSDDElement() {
    }

    public WSDDElement(Element e2) throws WSDDException {
        this.validateCandidateElement(e2);
    }

    protected abstract QName getElementName();

    private void validateCandidateElement(Element e2) throws WSDDException {
        QName name = this.getElementName();
        if (null == e2 || null == e2.getNamespaceURI() || null == e2.getLocalName() || !e2.getNamespaceURI().equals(name.getNamespaceURI()) || !e2.getLocalName().equals(name.getLocalPart())) {
            throw new WSDDException(Messages.getMessage("invalidWSDD00", e2.getLocalName(), name.getLocalPart()));
        }
    }

    public Element getChildElement(Element e2, String name) {
        Element[] elements = this.getChildElements(e2, name);
        if (elements.length == 0) {
            return null;
        }
        return elements[0];
    }

    public Element[] getChildElements(Element e2, String name) {
        NodeList nl = e2.getChildNodes();
        Vector<Element> els = new Vector<Element>();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            Element el;
            Node thisNode = nl.item(i2);
            if (!(thisNode instanceof Element) || !(el = (Element)thisNode).getLocalName().equals(name)) continue;
            els.add(el);
        }
        Element[] elements = new Element[els.size()];
        els.toArray(elements);
        return elements;
    }

    public abstract void writeToContext(SerializationContext var1) throws IOException;
}

