/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.LockableHashtable;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public abstract class WSDDDeployableItem
extends WSDDElement {
    public static final int SCOPE_PER_ACCESS = 0;
    public static final int SCOPE_PER_REQUEST = 1;
    public static final int SCOPE_SINGLETON = 2;
    public static String[] scopeStrings = new String[]{"per-access", "per-request", "singleton"};
    protected static Log log = LogFactory.getLog((class$org$apache$axis$deployment$wsdd$WSDDDeployableItem == null ? (class$org$apache$axis$deployment$wsdd$WSDDDeployableItem = WSDDDeployableItem.class$("org.apache.axis.deployment.wsdd.WSDDDeployableItem")) : class$org$apache$axis$deployment$wsdd$WSDDDeployableItem).getName());
    protected LockableHashtable parameters;
    protected QName qname;
    protected QName type;
    protected int scope = 2;
    protected Handler singletonInstance = null;
    static /* synthetic */ Class class$org$apache$axis$deployment$wsdd$WSDDDeployableItem;

    public WSDDDeployableItem() {
    }

    public WSDDDeployableItem(Element e2) throws WSDDException {
        super(e2);
        String scopeStr;
        String typeStr;
        String name = e2.getAttribute("name");
        if (name != null && !name.equals("")) {
            this.qname = new QName("", name);
        }
        if ((typeStr = e2.getAttribute("type")) != null && !typeStr.equals("")) {
            this.type = XMLUtils.getQNameFromString(typeStr, e2);
        }
        if ((scopeStr = e2.getAttribute("scope")) != null) {
            for (int i2 = 0; i2 < scopeStrings.length; ++i2) {
                if (!scopeStr.equals(scopeStrings[i2])) continue;
                this.scope = i2;
                break;
            }
        }
        this.parameters = new LockableHashtable();
        Element[] paramElements = this.getChildElements(e2, "parameter");
        for (int i3 = 0; i3 < paramElements.length; ++i3) {
            Element param = paramElements[i3];
            String pname = param.getAttribute("name");
            String value = param.getAttribute("value");
            String locked = param.getAttribute("locked");
            this.parameters.put(pname, value, JavaUtils.isTrueExplicitly(locked));
        }
    }

    public void setName(String name) {
        this.qname = new QName(null, name);
    }

    public void setQName(QName qname) {
        this.qname = qname;
    }

    public QName getQName() {
        return this.qname;
    }

    public QName getType() {
        return this.type;
    }

    public void setType(QName type) {
        this.type = type;
    }

    public void setParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new LockableHashtable();
        }
        this.parameters.put(name, value);
    }

    public String getParameter(String name) {
        if (name == null || this.parameters == null) {
            return null;
        }
        return (String)this.parameters.get(name);
    }

    public LockableHashtable getParametersTable() {
        return this.parameters;
    }

    public void setOptionsHashtable(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        this.parameters = new LockableHashtable((Map)hashtable);
    }

    public void writeParamsToContext(SerializationContext context) throws IOException {
        if (this.parameters == null) {
            return;
        }
        Set entries = this.parameters.entrySet();
        Iterator i2 = entries.iterator();
        while (i2.hasNext()) {
            Map.Entry entry = i2.next();
            String name = (String)entry.getKey();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "name", "name", "CDATA", name);
            attrs.addAttribute("", "value", "value", "CDATA", entry.getValue().toString());
            if (this.parameters.isKeyLocked(name)) {
                attrs.addAttribute("", "locked", "locked", "CDATA", "true");
            }
            context.startElement(QNAME_PARAM, attrs);
            context.endElement();
        }
    }

    public void removeParameter(String name) {
        if (this.parameters != null) {
            this.parameters.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Handler getInstance(EngineConfiguration registry) throws ConfigurationException {
        if (this.scope == 2) {
            WSDDDeployableItem wSDDDeployableItem = this;
            synchronized (wSDDDeployableItem) {
                if (this.singletonInstance == null) {
                    this.singletonInstance = this.getNewInstance(registry);
                }
            }
            return this.singletonInstance;
        }
        return this.getNewInstance(registry);
    }

    private Handler getNewInstance(EngineConfiguration registry) throws ConfigurationException {
        QName type = this.getType();
        if (type == null || "http://xml.apache.org/axis/wsdd/providers/java".equals(type.getNamespaceURI())) {
            return this.makeNewInstance(registry);
        }
        return registry.getHandler(type);
    }

    protected Handler makeNewInstance(EngineConfiguration registry) throws ConfigurationException {
        Class c2 = null;
        Handler h2 = null;
        try {
            c2 = this.getJavaClass();
        }
        catch (ClassNotFoundException e2) {
            throw new ConfigurationException(e2);
        }
        if (c2 != null) {
            try {
                h2 = (Handler)this.createInstance(c2);
            }
            catch (Exception e3) {
                throw new ConfigurationException(e3);
            }
            if (h2 != null) {
                if (this.qname != null) {
                    h2.setName(this.qname.getLocalPart());
                }
                h2.setOptions(this.getParametersTable());
                try {
                    h2.init();
                }
                catch (Exception e4) {
                    String msg = e4 + JavaUtils.LS + JavaUtils.stackToString(e4);
                    log.debug(msg);
                    throw new ConfigurationException(e4);
                }
                catch (Error e5) {
                    String msg = e5 + JavaUtils.LS + JavaUtils.stackToString(e5);
                    log.debug(msg);
                    throw new ConfigurationException(msg);
                }
            }
        } else {
            h2 = registry.getHandler(this.getType());
        }
        return h2;
    }

    Object createInstance(Class _class) throws InstantiationException, IllegalAccessException {
        return _class.newInstance();
    }

    public Class getJavaClass() throws ClassNotFoundException {
        QName type = this.getType();
        if (type != null && "http://xml.apache.org/axis/wsdd/providers/java".equals(type.getNamespaceURI())) {
            return ClassUtils.forName(type.getLocalPart());
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

