/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.encoding;

import org.apache.axis.components.encoding.XMLEncoder;
import org.apache.axis.utils.Messages;

public abstract class AbstractXMLEncoder
implements XMLEncoder {
    protected static final String AMP = "&amp;";
    protected static final String QUOTE = "&quot;";
    protected static final String LESS = "&lt;";
    protected static final String GREATER = "&gt;";
    protected static final String LF = "\n";
    protected static final String CR = "\r";
    protected static final String TAB = "\t";

    public abstract String getEncoding();

    public String encode(String xmlString) {
        if (xmlString == null) {
            return "";
        }
        char[] characters = xmlString.toCharArray();
        StringBuffer out = null;
        block9: for (int i2 = 0; i2 < characters.length; ++i2) {
            char character = characters[i2];
            switch (character) {
                case '&': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i2);
                    }
                    out.append(AMP);
                    continue block9;
                }
                case '\"': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i2);
                    }
                    out.append(QUOTE);
                    continue block9;
                }
                case '<': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i2);
                    }
                    out.append(LESS);
                    continue block9;
                }
                case '>': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i2);
                    }
                    out.append(GREATER);
                    continue block9;
                }
                case '\n': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i2);
                    }
                    out.append(LF);
                    continue block9;
                }
                case '\r': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i2);
                    }
                    out.append(CR);
                    continue block9;
                }
                case '\t': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i2);
                    }
                    out.append(TAB);
                    continue block9;
                }
                default: {
                    if (character < ' ') {
                        throw new IllegalArgumentException(Messages.getMessage("invalidXmlCharacter00", Integer.toHexString(character), xmlString));
                    }
                    if (out == null) continue block9;
                    out.append(character);
                }
            }
        }
        if (out == null) {
            return xmlString;
        }
        return out.toString();
    }

    protected StringBuffer getInitialByteArray(String aXmlString, int pos) {
        return new StringBuffer(aXmlString.substring(0, pos));
    }
}

