/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.dataset.Variant;
import com.borland.dx.text.InvalidFormatException;
import com.borland.dx.text.ItemFormatter;
import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.view.Res;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;
import java.text.MessageFormat;

public class TextItemPainter
implements ItemPainter,
Serializable {
    private static final long serialVersionUID = 200L;
    protected int alignment = 33;
    protected Insets margins = new Insets(1, 1, 1, 1);
    protected Color foreground = SystemColor.controlText;
    protected Color background;
    protected boolean paintBackground = true;
    protected ItemFormatter formatter;

    public TextItemPainter() {
    }

    public TextItemPainter(int alignment) {
        this();
        this.setAlignment(alignment);
    }

    public TextItemPainter(Insets margins) {
        this();
        this.setMargins(margins);
    }

    public TextItemPainter(ItemFormatter formatter) {
        this();
        this.setFormatter(formatter);
    }

    public TextItemPainter(int alignment, Insets margins) {
        this();
        this.setAlignment(alignment);
        this.setMargins(margins);
    }

    public TextItemPainter(int alignment, Insets margins, ItemFormatter formatter) {
        this();
        this.setAlignment(alignment);
        this.setMargins(margins);
        this.setFormatter(formatter);
    }

    public void setAlignment(int a2) {
        if ((this.alignment & 0xF0) < 0 || (this.alignment & 0xF0) > 48) {
            throw new IllegalArgumentException(MessageFormat.format(Res._BadVAlignment, new Integer(this.alignment & 0xF0)));
        }
        if ((this.alignment & 0xF) < 0 || (this.alignment & 0xF) > 3) {
            throw new IllegalArgumentException(MessageFormat.format(Res._BadHAlignment, new Integer(this.alignment & 0xF)));
        }
        this.alignment = a2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setMargins(Insets margins) {
        this.margins = margins;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setPaintBackground(boolean paintBackground) {
        this.paintBackground = paintBackground;
    }

    public boolean isPaintBackground() {
        return this.paintBackground;
    }

    public void setForeground(Color c2) {
        this.foreground = c2;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setFormatter(ItemFormatter formatter) {
        this.formatter = formatter;
    }

    public ItemFormatter getFormatter() {
        return this.formatter;
    }

    public Dimension getPreferredSize(Object data, Graphics g2, int state, ItemPaintSite site) {
        Font f2;
        if (g2 == null) {
            return new Dimension();
        }
        Font of = g2.getFont();
        Font font = f2 = site != null ? site.getFont() : of;
        if (f2 == null) {
            f2 = of;
        }
        if (f2 != null) {
            g2.setFont(f2);
        }
        FontMetrics fm = g2.getFontMetrics(f2);
        String text = this.getText(data);
        Insets m = site != null ? site.getItemMargins() : this.margins;
        g2.setFont(of);
        return new Dimension(m.left + m.right + fm.stringWidth(text), m.top + m.bottom + fm.getHeight());
    }

    public void paint(Object data, Graphics g2, Rectangle r, int state, ItemPaintSite site) {
        int yOffset;
        int xOffset;
        Color fg;
        Color bg;
        int a2;
        Insets m;
        Font f2;
        Font of = g2.getFont();
        Color oc = g2.getColor();
        Font font = f2 = site != null ? site.getFont() : g2.getFont();
        if (f2 == null) {
            f2 = g2.getFont();
        }
        g2.setFont(f2);
        Insets insets = m = site != null ? site.getItemMargins() : this.getMargins();
        if (m == null) {
            m = this.getMargins();
        }
        int n = a2 = site != null ? site.getAlignment() : this.getAlignment();
        if (a2 == 0) {
            a2 = this.getAlignment();
        }
        Color color = bg = site != null ? site.getBackground() : this.getBackground();
        if (bg == null) {
            bg = this.getBackground();
        }
        if (bg == null) {
            bg = g2.getColor();
        }
        Color color2 = fg = site != null ? site.getForeground() : this.getForeground();
        if (fg == null) {
            fg = this.getForeground();
        }
        if (fg == null) {
            fg = SystemColor.windowText;
        }
        boolean trans = site != null ? site.isTransparent() : !this.paintBackground;
        String text = this.getText(data);
        FontMetrics fm = g2.getFontMetrics(f2);
        switch (a2 & 0xF) {
            default: {
                xOffset = m.left;
                break;
            }
            case 2: {
                xOffset = (r.width - fm.stringWidth(text)) / 2;
                break;
            }
            case 3: {
                xOffset = r.width - fm.stringWidth(text) - m.right;
            }
        }
        switch (a2 & 0xF0) {
            default: {
                yOffset = m.top;
                break;
            }
            case 32: {
                yOffset = (r.height - fm.getHeight()) / 2;
                break;
            }
            case 48: {
                yOffset = r.height - m.bottom - fm.getHeight();
            }
        }
        yOffset += fm.getLeading() + fm.getAscent();
        if (!trans) {
            g2.setColor(bg);
            g2.fillRect(r.x, r.y, r.width, r.height);
        }
        if (text != null) {
            if ((state & 1) != 0) {
                g2.setColor(SystemColor.controlLtHighlight);
                g2.drawString(text, r.x + xOffset + 1, r.y + yOffset + 1);
                g2.setColor(SystemColor.controlShadow);
            } else {
                g2.setColor(fg);
            }
            g2.drawString(text, r.x + xOffset, r.y + yOffset);
        }
        g2.setFont(of);
        g2.setColor(oc);
    }

    protected String getText(Object data) {
        if (data != null) {
            if (this.formatter != null && data instanceof Variant) {
                try {
                    return this.formatter.format(data);
                }
                catch (InvalidFormatException ex) {
                    return "";
                }
            }
            return data.toString();
        }
        return "";
    }
}

