/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.view.SingletonModelView;
import java.awt.Checkbox;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CheckboxView
extends Checkbox
implements SingletonModelListener,
SingletonModelView,
Serializable {
    private static final long serialVersionUID = 200L;
    private transient SingletonModel model;
    private transient WritableSingletonModel writeModel;
    private transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    private boolean readOnly;

    public SingletonModel getModel() {
        return this.model;
    }

    public void setModel(SingletonModel p) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = p;
        WritableSingletonModel writableSingletonModel = this.writeModel = p instanceof WritableSingletonModel ? (WritableSingletonModel)p : null;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
            this.modelContentChanged(null);
        }
        this.enableEvents(512L);
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void addModelListener(SingletonModelListener l) {
        this.modelMulticaster.add(l);
    }

    public void removeModelListener(SingletonModelListener l) {
        this.modelMulticaster.remove(l);
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean ro) {
        this.setEnabled(!ro);
        this.readOnly = ro;
    }

    public void modelContentChanged(SingletonModelEvent e2) {
        boolean b2 = this.isChecked();
        if (b2 != this.getState()) {
            super.setState(b2);
        }
    }

    protected void processItemEvent(ItemEvent e2) {
        super.processItemEvent(e2);
        this.setChecked(this.getState());
    }

    public boolean isChecked() {
        Object o = this.model.get();
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        return false;
    }

    public void setState(boolean state) {
        if (!this.isReadOnly()) {
            super.setState(state);
            this.setChecked(state);
        }
    }

    public void setChecked(boolean value) {
        boolean b2;
        if (!this.isReadOnly() && (b2 = this.isChecked()) != value) {
            Object o = this.model.get();
            if (o instanceof Boolean) {
                this.writeModel.set(new Boolean(value));
            } else if (o instanceof Number) {
                this.writeModel.set(new Integer(value ? 1 : 0));
            } else if (o instanceof String) {
                this.writeModel.set(new Boolean(value).toString());
            } else {
                this.writeModel.set(new Boolean(value));
            }
        }
    }

    public Object get() {
        return this.model.get();
    }

    public boolean canSet() {
        return this.isReadOnly() ? false : this.writeModel.canSet(true);
    }

    public void set(Object data) {
        if (!this.isReadOnly()) {
            this.writeModel.set(data);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof SingletonModel) {
            this.model = (SingletonModel)data;
        }
        if (this.model instanceof WritableSingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
    }
}

