/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.SingletonViewManager;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.SingletonView;
import com.borland.jbcl.view.TextItemPainter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ButtonView
extends BeanPanel
implements SingletonView,
SingletonModelListener,
ItemPaintSite,
Serializable {
    private static final long serialVersionUID = 200L;
    boolean dragOut = false;
    boolean dragging = false;
    private transient SingletonModel model;
    private transient WritableSingletonModel writeModel;
    private transient SingletonViewManager viewManager;
    private boolean readOnly;
    private transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    private boolean showRollover = false;
    protected Insets margins = new Insets(2, 5, 2, 5);
    protected String actionCommand;
    protected int state;
    protected int alignment = 34;
    protected boolean mouseDown;
    protected boolean mouseOver;
    protected Border upBorder = BorderFactory.createRaisedBevelBorder();
    protected Border dnBorder = BorderFactory.createLoweredBevelBorder();

    public ButtonView() {
        super(null);
        super.setBackground(UIManager.getColor("Button.background"));
        super.setForeground(UIManager.getColor("Button.foreground"));
        this.upBorder = BorderFactory.createRaisedBevelBorder();
        this.dnBorder = BorderFactory.createLoweredBevelBorder();
        this.setModel(this.createDefaultModel());
        this.setViewManager(this.createDefaultViewManager());
    }

    public void updateUI() {
        super.updateUI();
        super.setBackground(UIManager.getColor("Button.background"));
        super.setForeground(UIManager.getColor("Button.foreground"));
        this.upBorder = BorderFactory.createRaisedBevelBorder();
        this.dnBorder = BorderFactory.createLoweredBevelBorder();
    }

    protected SingletonModel createDefaultModel() {
        return new BasicSingletonContainer();
    }

    protected SingletonViewManager createDefaultViewManager() {
        return new BasicViewManager(new FocusableItemPainter(new TextItemPainter()));
    }

    public void setItemMargins(Insets margins) {
        this.margins = margins;
    }

    public Insets getItemMargins() {
        return this.margins;
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public Component getSiteComponent() {
        return this;
    }

    public String getLabel() {
        Object contents = this.model != null ? this.model.get() : null;
        return contents != null ? contents.toString() : "";
    }

    public void setLabel(String label) {
        if (!this.isReadOnly()) {
            this.writeModel.set(label);
            this.repaint(100L);
        }
    }

    public void setFocusAware(boolean aware) {
        super.setFocusAware(aware);
        this.repaint(100L);
    }

    public boolean isFocusAware() {
        return super.isFocusAware();
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setShowRollover(boolean showRollover) {
        this.showRollover = showRollover;
        this.repaint(100L);
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public boolean isSelected() {
        return (this.state & 4) != 0;
    }

    public void setSelected(boolean selected) {
        this.state = selected ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
        this.repaint(100L);
    }

    public void setEnabled(boolean enable) {
        if (this.isEnabled() != enable) {
            if (enable) {
                this.state &= 0xFFFFFFFE;
            } else {
                this.state |= 1;
                this.state &= 0xFFFFFFBF;
                this.state &= 0xFFFFFFFB;
            }
            super.setEnabled(enable);
            this.repaint(100L);
        }
    }

    public void setModel(SingletonModel sm) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = sm;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)this.model : null;
        this.repaint(100L);
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void addModelListener(SingletonModelListener l) {
        this.modelMulticaster.add(l);
    }

    public void removeModelListener(SingletonModelListener l) {
        this.modelMulticaster.remove(l);
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public SingletonViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(SingletonViewManager vm) {
        this.viewManager = vm;
    }

    public void modelContentChanged(SingletonModelEvent e2) {
        this.repaint(100L);
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public Dimension getPreferredSize() {
        Object contents;
        Graphics g2 = this.getGraphics();
        Border b2 = (this.state & 4) != 0 ? this.dnBorder : this.upBorder;
        Insets bin = b2.getBorderInsets(this);
        if (this.model != null && this.viewManager != null && (contents = this.model.get()) != null) {
            Dimension innerSize = this.viewManager.getPainter(contents, this.state | this.focusState).getPreferredSize(contents, g2, this.state | this.focusState, this);
            return new Dimension(innerSize.width + bin.left + bin.right, innerSize.height + bin.top + bin.bottom);
        }
        return new Dimension(bin.left + bin.right + 20, bin.top + bin.bottom + 10);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.repaint(300L);
    }

    public void update(Graphics g2) {
        this.paint(g2);
    }

    public void paintBorder(Graphics g2) {
        if ((this.state & 4) != 0) {
            this.dnBorder.paintBorder(this, g2, 0, 0, this.getSize().width, this.getSize().height);
        } else if (!this.showRollover || (this.state & 0x40) != 0) {
            this.upBorder.paintBorder(this, g2, 0, 0, this.getSize().width, this.getSize().height);
        }
    }

    public void paintComponent(Graphics g2) {
        ItemPainter painter;
        super.paintComponent(g2);
        Dimension outerSize = this.getSize();
        Insets bin = new Insets(0, 0, 0, 0);
        if ((this.state & 4) != 0) {
            bin = this.dnBorder.getBorderInsets(this);
        } else if (!this.showRollover || (this.state & 0x40) != 0) {
            bin = this.upBorder.getBorderInsets(this);
        }
        Dimension innerSize = new Dimension(outerSize.width - bin.left - bin.right, outerSize.height - bin.top - bin.bottom);
        Object contents = this.model != null ? this.model.get() : null;
        ItemPainter itemPainter = painter = this.viewManager != null ? this.viewManager.getPainter(contents, this.state | this.focusState) : null;
        if (painter != null) {
            Rectangle r = new Rectangle(bin.left, bin.top, innerSize.width, innerSize.height);
            Rectangle clip = g2.getClipBounds();
            g2.clipRect(r.x, r.y, r.width, r.height);
            g2.setColor((this.state & 4) != 0 ? UIManager.getColor("Button.pressed") : this.getBackground());
            g2.setFont(this.getFont());
            painter.paint(contents, g2, r, this.state | this.focusState, this);
            g2.setClip(clip);
        }
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            this.mouseDown = false;
            this.setSelected(false);
        }
        super.setVisible(visible);
    }

    protected void processFocusEvent(FocusEvent e2) {
        super.processFocusEvent(e2);
        if (e2.getID() == 1005) {
            this.state &= 0xFFFFFFFB;
        }
        if (this.focusAware) {
            this.repaint(100L);
        }
    }

    protected void processKeyPressed(KeyEvent e2) {
        switch (e2.getKeyCode()) {
            case 32: {
                this.state |= 4;
                this.repaint();
            }
        }
    }

    protected void processKeyReleased(KeyEvent e2) {
        if (e2.getKeyCode() == 32) {
            this.state &= 0xFFFFFFFB;
            this.repaint();
            this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }

    protected void processMousePressed(MouseEvent e2) {
        super.processMousePressed(e2);
        if (!e2.isConsumed()) {
            this.state |= 4;
            this.state &= 0xFFFFFFBF;
            this.mouseDown = true;
            this.mouseOver = true;
            this.repaint();
        }
    }

    protected void processMouseReleased(MouseEvent e2) {
        super.processMouseReleased(e2);
        if (!e2.isConsumed()) {
            this.dragging = false;
            boolean action = (this.state & 4) != 0;
            this.state &= 0xFFFFFFFB;
            this.mouseDown = false;
            if (this.mouseOver && this.showRollover) {
                this.state |= 0x40;
            }
            this.repaint();
            if (action) {
                this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
            }
        }
    }

    protected void processMouseDragged(MouseEvent e2) {
        super.processMouseDragged(e2);
        if (!e2.isConsumed()) {
            this.state &= 0xFFFFFFBF;
            this.dragging = true;
            if (!this.contains(e2.getX(), e2.getY())) {
                if (!this.dragOut) {
                    this.dragOut = true;
                    this.mouseOver = false;
                    if (this.mouseDown) {
                        this.state &= 0xFFFFFFFB;
                        this.repaint();
                    }
                }
            } else if (this.dragOut) {
                this.dragOut = false;
                this.mouseOver = true;
                if (this.mouseDown) {
                    this.state |= 4;
                    this.repaint();
                }
            }
        }
    }

    protected void processMouseEntered(MouseEvent e2) {
        super.processMouseEntered(e2);
        if (!e2.isConsumed()) {
            if (this.dragging) {
                return;
            }
            this.mouseOver = true;
            boolean paint = false;
            if (this.mouseDown) {
                this.state |= 4;
                paint = true;
            }
            if (this.showRollover) {
                this.state |= 0x40;
                paint = true;
            }
            if (paint) {
                this.repaint();
            }
        }
    }

    protected void processMouseExited(MouseEvent e2) {
        super.processMouseExited(e2);
        if (!e2.isConsumed()) {
            if (this.dragging) {
                return;
            }
            this.mouseOver = false;
            boolean paint = false;
            if (this.mouseDown) {
                this.state &= 0xFFFFFFFB;
                paint = true;
            }
            if (this.showRollover && !this.mouseDown) {
                this.state &= 0xFFFFFFBF;
                paint = true;
            }
            if (paint) {
                this.repaint();
            }
        }
    }

    protected String paramString() {
        return super.paramString() + ",label=" + this.getLabel() + ",state=" + this.state;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Hashtable<String, Object> hash = new Hashtable<String, Object>(2);
        if (this.model instanceof Serializable) {
            hash.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hash.put("v", this.viewManager);
        }
        s.writeObject(hash);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Hashtable hash = (Hashtable)s.readObject();
        Object data = hash.get("m");
        if (data instanceof SingletonModel) {
            this.model = (SingletonModel)data;
        }
        if (this.model instanceof WritableSingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
        if ((data = hash.get("v")) instanceof SingletonViewManager) {
            this.viewManager = (SingletonViewManager)data;
        }
    }
}

