/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jbcl.model.BasicSelection;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;
import java.util.EventListener;

public class BasicMatrixSelection
extends BasicSelection
implements WritableMatrixSelection,
Serializable {
    public BasicMatrixSelection() {
    }

    public BasicMatrixSelection(MatrixLocation[] newSet) {
        this.set(newSet);
    }

    public boolean contains(MatrixLocation location) {
        return this.array.contains(location);
    }

    public boolean contains(int row, int column) {
        return this.contains(new MatrixLocation(row, column));
    }

    public MatrixLocation[] getAll() {
        Object[] contents = new MatrixLocation[this.getCount()];
        this.array.copyInto(contents);
        return contents;
    }

    public void addSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.add((EventListener)listener);
    }

    public void removeSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.remove((EventListener)listener);
    }

    public void set(MatrixLocation[] locations) {
        this.doRemoveAll();
        for (int i2 = 0; i2 < locations.length; ++i2) {
            this.array.addElement(locations[i2]);
        }
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public void add(MatrixLocation location) {
        if (this.doAdd(location)) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 4097, location));
        }
    }

    public void add(int row, int column) {
        if (this.doAdd(new MatrixLocation(row, column))) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 4097, new MatrixLocation(row, column)));
        }
    }

    public void add(MatrixLocation[] locations) {
        boolean changed = false;
        for (int i2 = 0; i2 < locations.length; ++i2) {
            changed |= this.doAdd(locations[i2]);
        }
        if (changed) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation begin, MatrixLocation end) {
        this.addRange(begin.row, begin.column, end.row, end.column);
    }

    public void addRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        int loRow = beginRow < endRow ? beginRow : endRow;
        int hiRow = beginRow > endRow ? beginRow : endRow;
        int loCol = beginColumn < endColumn ? beginColumn : endColumn;
        int hiCol = beginColumn > endColumn ? beginColumn : endColumn;
        boolean changed = false;
        for (int row = loRow; row <= hiRow; ++row) {
            for (int column = loCol; column <= hiCol; ++column) {
                changed |= this.doAdd(new MatrixLocation(row, column));
            }
        }
        if (changed) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 8193, new MatrixLocation(loRow, loCol), new MatrixLocation(hiRow, hiCol)));
        }
    }

    public void remove(MatrixLocation location) {
        if (this.doRemove(location)) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 4098, location));
        }
    }

    public void remove(int row, int column) {
        if (this.doRemove(new MatrixLocation(row, column))) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 4098, new MatrixLocation(row, column)));
        }
    }

    public void remove(MatrixLocation[] locations) {
        boolean changed = false;
        for (int i2 = 0; i2 < locations.length; ++i2) {
            changed |= this.doRemove(locations[i2]);
        }
        if (changed) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeRange(MatrixLocation begin, MatrixLocation end) {
        this.removeRange(begin.row, begin.column, end.row, end.column);
    }

    public void removeRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        int loRow = beginRow < endRow ? beginRow : endRow;
        int hiRow = beginRow > endRow ? beginRow : endRow;
        int loCol = beginColumn < endColumn ? beginColumn : endColumn;
        int hiCol = beginColumn > endColumn ? beginColumn : endColumn;
        boolean changed = false;
        for (int row = loRow; row <= hiRow; ++row) {
            for (int col = loCol; col <= hiCol; ++col) {
                changed |= this.doRemove(new MatrixLocation(row, col));
            }
        }
        if (changed) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 8194, new MatrixLocation(loRow, loCol), new MatrixLocation(hiRow, hiCol)));
        }
    }

    public void removeAll() {
        if (this.doRemoveAll()) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void enableSelectionEvents(boolean enable) {
        if (this.events != enable) {
            this.events = enable;
            if (this.events) {
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
            }
        }
    }

    protected void processSelectionEvent(MatrixSelectionEvent e2) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch((DispatchableEvent)e2);
        }
    }
}

