/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.editors;

import com.borland.jb.util.FastStringBuffer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;

public class StringEditor
implements PropertyEditor {
    private static String[] logicalChars = new String[]{"<TAB>", "<CR>", "<NL>", "<FF>", "<<>", "<LF>"};
    private static char[] physicalChars = new char[]{'\t', '\r', '\n', '\f', '<', '\n'};
    private PropertyChangeListener listener;
    protected Object value;

    public void setValue(Object o) {
        this.value = o;
        this.fire();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getAsText() {
        String s = this.value == null ? null : StringEditor.rawTextToDisplay(this.value);
        return s;
    }

    public String getJavaInitializationString() {
        String s = StringEditor.textToSource(this.value);
        return s;
    }

    public static String textToSource(Object text) {
        if (text instanceof String) {
            return FastStringBuffer.textToSource((String)((String)text), (boolean)false).toString();
        }
        if (text == null) {
            return "null";
        }
        return text.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.value = text == null ? null : StringEditor.displayTextToRaw(text);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public static boolean inCurrentCodePage(char ch) {
        String src = String.valueOf(ch);
        byte[] bts = src.getBytes();
        String dst = new String(bts);
        return src.charAt(0) == dst.charAt(0);
    }

    public static String rawTextToDisplay(Object s) {
        if (!(s instanceof String)) {
            return s.toString();
        }
        FastStringBuffer src = new FastStringBuffer((String)s);
        FastStringBuffer dst = new FastStringBuffer();
        char ch = src.firstChar();
        while (ch != '\u0000') {
            int i2;
            for (i2 = 0; i2 < physicalChars.length; ++i2) {
                if (ch != physicalChars[i2]) continue;
                dst.append(logicalChars[i2]);
                break;
            }
            if (i2 >= physicalChars.length) {
                if (ch > '\u001f' && StringEditor.inCurrentCodePage(ch)) {
                    dst.append(ch);
                } else {
                    dst.append("<" + Integer.toString(ch, 16) + ">");
                }
            }
            ch = src.nextChar();
        }
        return dst.toString();
    }

    public static String displayTextToRaw(String s) {
        FastStringBuffer src = new FastStringBuffer(s);
        FastStringBuffer dst = new FastStringBuffer();
        char ch = src.firstChar();
        while (ch != '\u0000') {
            if (ch != '<') {
                dst.append(ch);
            } else {
                int offset = src.getOffset();
                FastStringBuffer log = new FastStringBuffer();
                ch = src.nextChar();
                while (ch != '\u0000') {
                    if (ch == '>') {
                        int i2;
                        String logStr = "<" + log.toString() + ">";
                        for (i2 = 0; i2 < logicalChars.length; ++i2) {
                            if (!logStr.equalsIgnoreCase(logicalChars[i2])) continue;
                            dst.append(physicalChars[i2]);
                            break;
                        }
                        if (i2 < logicalChars.length) break;
                        String logStrNumber = log.toString();
                        try {
                            dst.append((char)Integer.valueOf(logStrNumber, 16).intValue());
                        }
                        catch (Exception ex) {
                            dst.append(logStr);
                        }
                        break;
                    }
                    log.append(ch);
                    ch = src.nextChar();
                }
                if (ch == '\u0000') {
                    dst.append('<');
                    src.setOffset(offset);
                }
            }
            ch = src.nextChar();
        }
        return dst.toString();
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "StringEditor???", null, this.value));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }
}

