/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.util.BlackBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JComponent;

public class ShapeControl
extends JComponent
implements Serializable,
BlackBox {
    public static final int RECTANGLE = 0;
    public static final int ROUND_RECT = 1;
    public static final int SQUARE = 2;
    public static final int ROUND_SQUARE = 3;
    public static final int ELLIPSE = 4;
    public static final int CIRCLE = 5;
    public static final int HORZ_LINE = 6;
    public static final int VERT_LINE = 7;
    public static final int POS_SLOPE_LINE = 8;
    public static final int NEG_SLOPE_LINE = 9;
    private int type = 0;
    private Color edgeColor = Color.black;
    private boolean drawEdge = true;
    private boolean fill = true;

    public ShapeControl() {
        this.setSize(100, 100);
        super.setForeground(Color.white);
    }

    public ShapeControl(int type) {
        this();
        this.setType(type);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint(100L);
    }

    public void setType(int type) {
        if (this.type != type) {
            this.type = type;
            this.repaint(100L);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
        this.repaint(100L);
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
        this.repaint(100L);
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setDrawEdge(boolean drawEdge) {
        this.drawEdge = drawEdge;
        this.repaint(100L);
    }

    public boolean isDrawEdge() {
        return this.drawEdge;
    }

    public void paintComponent(Graphics g2) {
        int s;
        super.paintComponent(g2);
        int x = 0;
        int y = 0;
        int w = this.getSize().width;
        int h2 = this.getSize().height;
        int n = s = w < h2 ? w : h2;
        if (this.type == 2 || this.type == 3 || this.type == 5) {
            x += (w - s) / 2;
            y += (h2 - s) / 2;
            w = s;
            h2 = s;
        }
        switch (this.type) {
            case 0: 
            case 2: {
                if (this.fill) {
                    g2.setColor(this.getForeground());
                    g2.fillRect(x, y, w, h2);
                }
                if (!this.drawEdge) break;
                g2.setColor(this.edgeColor);
                g2.drawRect(x, y, w - 1, h2 - 1);
                break;
            }
            case 1: 
            case 3: {
                if (this.fill) {
                    g2.setColor(this.getForeground());
                    g2.fillRoundRect(x, y, w, h2, s / 4, s / 4);
                }
                if (!this.drawEdge) break;
                g2.setColor(this.edgeColor);
                g2.drawRoundRect(x, y, w - 1, h2 - 1, s / 4, s / 4);
                break;
            }
            case 4: 
            case 5: {
                if (this.fill) {
                    g2.setColor(this.getForeground());
                    g2.fillOval(x, y, w, h2);
                }
                if (!this.drawEdge) break;
                g2.setColor(this.edgeColor);
                g2.drawOval(x, y, w - 1, h2 - 1);
                break;
            }
            case 6: {
                g2.setColor(this.getForeground());
                g2.drawLine(x, y, x + w, y);
                if (!this.drawEdge) break;
                g2.setColor(this.edgeColor);
                g2.drawLine(x, y + 1, x + w, y + 1);
                break;
            }
            case 7: {
                g2.setColor(this.getForeground());
                g2.drawLine(x, y, x, y + h2);
                if (!this.drawEdge) break;
                g2.setColor(this.edgeColor);
                g2.drawLine(x + 1, y, x + 1, y + h2);
                break;
            }
            case 8: {
                if (this.drawEdge) {
                    g2.setColor(this.edgeColor);
                    g2.drawLine(x, y + 1 + h2, x + w, y + 1);
                }
                g2.setColor(this.getForeground());
                g2.drawLine(x, y + h2, x + w, y);
                break;
            }
            case 9: {
                if (this.drawEdge) {
                    g2.setColor(this.edgeColor);
                    g2.drawLine(x, y + 1, x + w, y + h2 + 1);
                }
                g2.setColor(this.getForeground());
                g2.drawLine(x, y, x + w, y + h2);
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

