/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Variant;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.SingletonDataSetManager;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.view.CheckboxView;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;

public class CheckboxControl
extends CheckboxView
implements AccessListener,
WritableSingletonModel,
BlackBox,
ColumnAware,
Serializable {
    private DataSet dataSet;
    private String columnName;
    private boolean addNotifyCalled = false;

    public CheckboxControl() {
        this.setModel(new BasicSingletonContainer());
    }

    public void setModel(SingletonModel sm) {
        if (sm == this) {
            throw new IllegalArgumentException(Res._RecursiveModel);
        }
        super.setModel(sm);
    }

    public void setChecked(boolean value) {
        boolean b2;
        if (!this.isReadOnly() && (b2 = this.isChecked()) != value) {
            Object o = this.get();
            if (o instanceof Variant) {
                switch (((Variant)o).getType()) {
                    case 11: {
                        ((Variant)o).setBoolean(value);
                        this.set(o);
                        break;
                    }
                    case 16: {
                        ((Variant)o).setString(String.valueOf(value));
                        this.set(o);
                        break;
                    }
                    case 2: {
                        ((Variant)o).setByte((byte)(value ? 1 : 0));
                        this.set(o);
                        break;
                    }
                    case 3: {
                        ((Variant)o).setShort((short)(value ? 1 : 0));
                        this.set(o);
                        break;
                    }
                    case 4: {
                        ((Variant)o).setInt(value ? 1 : 0);
                        this.set(o);
                        break;
                    }
                    case 5: {
                        ((Variant)o).setLong(value ? 1L : 0L);
                        this.set(o);
                        break;
                    }
                    case 6: {
                        ((Variant)o).setFloat(value ? 1.0f : 0.0f);
                        this.set(o);
                        break;
                    }
                    case 7: {
                        ((Variant)o).setDouble(value ? 1.0 : 0.0);
                        this.set(o);
                        break;
                    }
                }
            } else {
                super.setChecked(value);
            }
        }
    }

    public boolean isChecked() {
        Object o = this.get();
        if (o instanceof Variant) {
            return ((Variant)o).getAsBoolean();
        }
        return super.isChecked();
    }

    public void accessChange(AccessEvent e2) {
        switch (e2.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception ex) {
                    e2.appendException(ex);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet newDataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener((AccessListener)this);
        }
        this.openDataSet(newDataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener((AccessListener)this);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String newColumnName) {
        this.columnName = newColumnName;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void openDataSet(DataSet newDataSet) {
        this.dataSet = newDataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)ex));
                this.setModel(new BasicSingletonContainer());
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column, this));
            this.bindProperties(column);
        }
    }

    private void bindProperties(Column column) {
        Color bg = column.getBackground();
        Color fg = column.getForeground();
        Font f2 = column.getFont();
        if (bg != null) {
            this.setBackground(bg);
        }
        if (fg != null) {
            this.setForeground(fg);
        }
        if (f2 != null) {
            this.setFont(f2);
        }
    }

    public Object get() {
        return this.getModel().get();
    }

    public boolean canSet(boolean startEdit) {
        return this.isReadOnly() ? false : this.getWriteModel().canSet(startEdit);
    }

    public void set(Object data) {
        if (!this.isReadOnly()) {
            this.getWriteModel().set(data);
        }
    }

    public void touched() {
        this.getWriteModel().touched();
    }

    public void enableModelEvents(boolean enable) {
        this.getWriteModel().enableModelEvents(enable);
    }
}

