/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.ime.internal.util;

import java.util.Iterator;
import java.util.Vector;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.threadpool.ThreadPool;
import org.apache.axis.i18n.Messages;
import org.apache.axis.ime.internal.util.KeyedBuffer;
import org.apache.commons.logging.Log;

public class NonPersistentKeyedBuffer
implements KeyedBuffer {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$ime$internal$util$NonPersistentKeyedBuffer == null ? (class$org$apache$axis$ime$internal$util$NonPersistentKeyedBuffer = NonPersistentKeyedBuffer.class$("org.apache.axis.ime.internal.util.NonPersistentKeyedBuffer")) : class$org$apache$axis$ime$internal$util$NonPersistentKeyedBuffer).getName());
    private final KeyedQueue messages = new KeyedQueue();
    private ThreadPool WORKERS;
    static /* synthetic */ Class class$org$apache$axis$ime$internal$util$NonPersistentKeyedBuffer;

    public NonPersistentKeyedBuffer(ThreadPool workers) {
        this.WORKERS = workers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        KeyedNode node = null;
        KeyedQueue keyedQueue = this.messages;
        synchronized (keyedQueue) {
            node = this.messages.peek();
        }
        if (node != null) {
            return node.value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] peekAll() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: KeyedBuffer::selectAll");
        }
        Vector v = new Vector();
        Object node = null;
        KeyedQueue keyedQueue = this.messages;
        synchronized (keyedQueue) {
            Iterator i = this.messages.iterator();
            while (i.hasNext()) {
                v.add(i.next());
            }
        }
        Object[] objects = new Object[v.size()];
        v.copyInto(objects);
        if (log.isDebugEnabled()) {
            log.debug("Exit: KeyedBuffer::selectAll");
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object object) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: KeyedBuffer::put");
        }
        if (key == null || object == null) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        KeyedQueue keyedQueue = this.messages;
        synchronized (keyedQueue) {
            this.messages.put(new KeyedNode(key, object));
            this.messages.notify();
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: KeyedBuffer::put");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object cancel(Object key) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: KeyedBuffer::cancel");
        }
        if (key == null) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        Object object = null;
        KeyedQueue keyedQueue = this.messages;
        synchronized (keyedQueue) {
            KeyedNode node = this.messages.select(key);
            if (node != null) {
                object = node.value;
            }
            node.key = null;
            node.value = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: KeyedBuffer::cancel");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] selectAll() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: KeyedBuffer::selectAll");
        }
        Vector<Object> v = new Vector<Object>();
        KeyedNode node = null;
        KeyedQueue keyedQueue = this.messages;
        synchronized (keyedQueue) {
            while ((node = this.messages.select()) != null) {
                v.add(node.value);
                node.key = null;
                node.value = null;
            }
        }
        Object[] objects = new Object[v.size()];
        v.copyInto(objects);
        if (log.isDebugEnabled()) {
            log.debug("Exit: KeyedBuffer::selectAll");
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object select() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: KeyedBuffer::select");
        }
        while (true) {
            if (this.WORKERS.isShuttingDown()) {
                throw new IllegalStateException(Messages.getMessage("illegalStateException00"));
            }
            KeyedNode node = null;
            KeyedQueue keyedQueue = this.messages;
            synchronized (keyedQueue) {
                node = this.messages.select();
            }
            if (node != null) {
                Object object = node.value;
                node.key = null;
                node.value = null;
                if (log.isDebugEnabled()) {
                    log.debug("Exit: KeyedBuffer::select");
                }
                return object;
            }
            this.messages.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object select(long timeout) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: KeyedBuffer::select");
        }
        while (true) {
            if (this.WORKERS.isShuttingDown()) {
                throw new IllegalStateException(Messages.getMessage("illegalStateException00"));
            }
            KeyedNode node = null;
            KeyedQueue keyedQueue = this.messages;
            synchronized (keyedQueue) {
                node = this.messages.select();
            }
            if (node != null) {
                Object object = node.value;
                node.key = null;
                node.value = null;
                if (log.isDebugEnabled()) {
                    log.debug("Exit: KeyedBuffer::select");
                }
                return object;
            }
            this.messages.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object select(Object key) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: KeyedBuffer::select");
        }
        while (true) {
            if (this.WORKERS.isShuttingDown()) {
                throw new IllegalStateException(Messages.getMessage("illegalStateException00"));
            }
            KeyedNode node = null;
            KeyedQueue keyedQueue = this.messages;
            synchronized (keyedQueue) {
                node = this.messages.select(key);
            }
            if (node != null) {
                Object object = node.value;
                node.key = null;
                node.value = null;
                if (log.isDebugEnabled()) {
                    log.debug("Exit: KeyedBuffer::select");
                }
                return object;
            }
            this.messages.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object select(Object key, long timeout) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: KeyedBuffer::select");
        }
        while (true) {
            if (this.WORKERS.isShuttingDown()) {
                throw new IllegalStateException(Messages.getMessage("illegalStateException00"));
            }
            KeyedNode node = null;
            KeyedQueue keyedQueue = this.messages;
            synchronized (keyedQueue) {
                node = this.messages.select(key);
            }
            if (node != null) {
                Object object = node.value;
                node.key = null;
                node.value = null;
                if (log.isDebugEnabled()) {
                    log.debug("Exit: KeyedBuffer::select");
                }
                return object;
            }
            this.messages.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: KeyedBuffer::get");
        }
        KeyedNode node = null;
        Object object = null;
        KeyedQueue keyedQueue = this.messages;
        synchronized (keyedQueue) {
            node = this.messages.select();
        }
        if (node != null) {
            object = node.value;
            node.key = null;
            node.value = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: KeyedBuffer::get");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: KeyedBuffer::get");
        }
        KeyedNode node = null;
        Object object = null;
        KeyedQueue keyedQueue = this.messages;
        synchronized (keyedQueue) {
            node = this.messages.select(key);
        }
        if (node != null) {
            object = node.value;
            node.key = null;
            node.value = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: KeyedBuffer::get");
        }
        return object;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class KeyedQueueIterator
    implements Iterator {
        protected KeyedNode current;
        protected KeyedNode next;

        public KeyedQueueIterator(KeyedNode node) {
            this.next = node;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            KeyedNode node = null;
            if (this.next != null) {
                node = this.next.next;
            }
            this.current = this.next;
            this.next = node;
            return this.current;
        }

        public void remove() {
        }
    }

    protected static class KeyedQueue {
        protected KeyedNode head;
        protected KeyedNode last;

        protected KeyedQueue() {
        }

        protected void put(KeyedNode node) {
            this.last = this.last == null ? (this.head = node) : (this.last.next = node);
        }

        protected KeyedNode select() {
            KeyedNode node = this.head;
            if (node != null && (this.head = node.next) == null) {
                this.last = null;
            }
            if (node != null) {
                node.next = null;
            }
            return node;
        }

        protected KeyedNode select(Object key) {
            KeyedNode previous = null;
            KeyedNode node = this.head;
            while (node != null) {
                if (node.key.equals(key)) {
                    if (previous != null) {
                        previous.next = node.next;
                    }
                    node.next = null;
                    return node;
                }
                previous = node;
                node = node.next;
            }
            return null;
        }

        protected KeyedNode peek() {
            KeyedNode node = this.head;
            return node;
        }

        protected Iterator iterator() {
            return new KeyedQueueIterator(this.head);
        }
    }

    protected static class KeyedNode {
        public Object key;
        public Object value;
        public KeyedNode next;

        public KeyedNode() {
        }

        public KeyedNode(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public KeyedNode(Object key, Object value, KeyedNode next) {
            this(key, value);
            this.next = next;
        }
    }
}

