/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.ime.internal;

import java.util.Hashtable;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.threadpool.ThreadPool;
import org.apache.axis.i18n.Messages;
import org.apache.axis.ime.MessageExchange;
import org.apache.axis.ime.MessageExchangeEventListener;
import org.apache.axis.ime.MessageExchangeFactory;
import org.apache.axis.ime.event.MessageSendEvent;
import org.apache.axis.ime.internal.MessageExchangeImpl;
import org.apache.axis.ime.internal.MessageExchangeReceiveContext;
import org.apache.axis.ime.internal.MessageExchangeSendContext;
import org.apache.axis.ime.internal.ReceivedMessageDispatchPolicy;
import org.apache.axis.ime.internal.SimpleMessageExchangeCorrelator;
import org.apache.axis.ime.internal.util.KeyedBuffer;
import org.apache.axis.ime.internal.util.NonPersistentKeyedBuffer;
import org.apache.commons.logging.Log;

public abstract class MessageExchangeProvider
implements MessageExchangeFactory {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$ime$internal$MessageExchangeProvider == null ? (class$org$apache$axis$ime$internal$MessageExchangeProvider = MessageExchangeProvider.class$("org.apache.axis.ime.internal.MessageExchangeProvider")) : class$org$apache$axis$ime$internal$MessageExchangeProvider).getName());
    public static final long SELECT_TIMEOUT = 30000L;
    public static final long DEFAULT_THREAD_COUNT = 5L;
    protected final ThreadPool WORKERS = new ThreadPool();
    protected final KeyedBuffer SEND = new NonPersistentKeyedBuffer(this.WORKERS);
    protected final KeyedBuffer RECEIVE = new NonPersistentKeyedBuffer(this.WORKERS);
    protected final KeyedBuffer RECEIVE_REQUESTS = new NonPersistentKeyedBuffer(this.WORKERS);
    protected Handler sendHandler = null;
    protected Handler receiveHandler = null;
    protected boolean initialized = false;
    static /* synthetic */ Class class$org$apache$axis$ime$internal$MessageExchangeProvider;
    static /* synthetic */ Class class$org$apache$axis$ime$internal$MessageExchangeProvider$MessageReceiver;

    public Handler getSendHandler() {
        return this.sendHandler;
    }

    public Handler getReceiveHandler() {
        return this.receiveHandler;
    }

    public void setSendHandler(Handler handler) {
        this.sendHandler = handler;
    }

    public void setReceiveHandler(Handler handler) {
        this.receiveHandler = handler;
    }

    protected abstract MessageExchangeEventListener getMessageExchangeEventListener();

    protected abstract ReceivedMessageDispatchPolicy getReceivedMessageDispatchPolicy();

    public MessageExchange createMessageExchange() throws AxisFault {
        return new MessageExchangeImpl(this);
    }

    public MessageExchange createMessageExchange(Hashtable options) throws AxisFault {
        MessageExchangeImpl msgex = new MessageExchangeImpl(this);
        msgex.setOptions(options);
        return msgex;
    }

    public void cleanup() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeProvider::cleanup");
        }
        this.WORKERS.cleanup();
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeProvider::cleanup");
        }
    }

    public void init() {
        this.init(5L);
    }

    public void init(long THREAD_COUNT) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeProvider::init");
        }
        if (this.initialized) {
            throw new IllegalStateException(Messages.getMessage("illegalStateException00"));
        }
        int n = 0;
        while ((long)n < THREAD_COUNT) {
            this.WORKERS.addWorker(new MessageSender(this.WORKERS, this.SEND, this.getMessageExchangeEventListener(), this.getSendHandler()));
            this.WORKERS.addWorker(new MessageReceiver(this.WORKERS, this.RECEIVE, this.getReceivedMessageDispatchPolicy(), this.getReceiveHandler()));
            ++n;
        }
        this.initialized = true;
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeProvider::init");
        }
    }

    public void processReceive(MessageExchangeReceiveContext context) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeProvider::processReceive");
        }
        if (context.getMessageExchangeCorrelator() != null) {
            this.RECEIVE_REQUESTS.put(context.getMessageExchangeCorrelator(), context);
        } else {
            this.RECEIVE_REQUESTS.put(SimpleMessageExchangeCorrelator.NULL_CORRELATOR, context);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeProvider::processReceive");
        }
    }

    public void processSend(MessageExchangeSendContext context) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeProvider::processSend");
        }
        this.SEND.put(context.getMessageExchangeCorrelator(), context);
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeProvider::processSend");
        }
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean force) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeProvider::shutdown");
        }
        if (!force) {
            this.WORKERS.safeShutdown();
        } else {
            this.WORKERS.shutdown();
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeProvider::shutdown");
        }
    }

    public void awaitShutdown() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeProvider::awaitShutdown");
        }
        this.WORKERS.awaitShutdown();
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeProvider::awaitShutdown");
        }
    }

    public void awaitShutdown(long shutdown) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeProvider::awaitShutdown");
        }
        this.WORKERS.awaitShutdown(shutdown);
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeProvider::awaitShutdown");
        }
    }

    public void setOption(String propertyId, Object propertyValue) {
        throw new UnsupportedOperationException(Messages.getMessage("unsupportedOperationException00"));
    }

    public Object getOption(String propertyId) {
        throw new UnsupportedOperationException(Messages.getMessage("unsupportedOperationException00"));
    }

    public Object getOption(String propertyId, Object defaultValue) {
        throw new UnsupportedOperationException(Messages.getMessage("unsupportedOperationException00"));
    }

    public Hashtable getOptions() {
        throw new UnsupportedOperationException(Messages.getMessage("unsupportedOperationException00"));
    }

    public void setOptions(Hashtable properties) {
        throw new UnsupportedOperationException(Messages.getMessage("unsupportedOperationException00"));
    }

    public void clearOptions() {
        throw new UnsupportedOperationException(Messages.getMessage("unsupportedOperationException00"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MessageSender
    implements Runnable {
        protected static Log log = LogFactory.getLog((class$org$apache$axis$ime$internal$MessageExchangeProvider$MessageReceiver == null ? (class$org$apache$axis$ime$internal$MessageExchangeProvider$MessageReceiver = MessageExchangeProvider.class$("org.apache.axis.ime.internal.MessageExchangeProvider$MessageReceiver")) : class$org$apache$axis$ime$internal$MessageExchangeProvider$MessageReceiver).getName());
        protected ThreadPool pool;
        protected KeyedBuffer channel;
        protected MessageExchangeEventListener listener;
        protected Handler handler;

        protected MessageSender(ThreadPool pool, KeyedBuffer channel, MessageExchangeEventListener listener, Handler handler) {
            this.pool = pool;
            this.channel = channel;
            this.listener = listener;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug("Enter: MessageExchangeProvider.MessageSender::run");
            }
            try {
                while (!this.pool.isShuttingDown()) {
                    MessageExchangeSendContext context = (MessageExchangeSendContext)this.channel.select(30000L);
                    if (context == null) continue;
                    if (this.handler != null) {
                        this.handler.invoke(context.getMessageContext());
                    }
                    MessageSendEvent sendEvent = new MessageSendEvent(context.getMessageExchangeCorrelator(), context, context.getMessageContext());
                    this.listener.onEvent(sendEvent);
                }
            }
            catch (Throwable t) {
                log.error(Messages.getMessage("fault00"), t);
            }
            finally {
                this.pool.workerDone(this, true);
                if (log.isDebugEnabled()) {
                    log.debug("Exit: MessageExchangeProvider.MessageSender::run");
                }
            }
        }
    }

    public static class MessageReceiver
    implements Runnable {
        protected static Log log = LogFactory.getLog((class$org$apache$axis$ime$internal$MessageExchangeProvider$MessageReceiver == null ? (class$org$apache$axis$ime$internal$MessageExchangeProvider$MessageReceiver = MessageExchangeProvider.class$("org.apache.axis.ime.internal.MessageExchangeProvider$MessageReceiver")) : class$org$apache$axis$ime$internal$MessageExchangeProvider$MessageReceiver).getName());
        protected ThreadPool pool;
        protected KeyedBuffer channel;
        protected ReceivedMessageDispatchPolicy policy;
        protected Handler handler;

        protected MessageReceiver(ThreadPool pool, KeyedBuffer channel, ReceivedMessageDispatchPolicy policy, Handler handler) {
            this.pool = pool;
            this.channel = channel;
            this.policy = policy;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug("Enter: MessageExchangeProvider.MessageReceiver::run");
            }
            try {
                while (!this.pool.isShuttingDown()) {
                    MessageExchangeSendContext context = (MessageExchangeSendContext)this.channel.select(30000L);
                    if (context == null) continue;
                    if (this.handler != null) {
                        this.handler.invoke(context.getMessageContext());
                    }
                    this.policy.dispatch(context);
                }
            }
            catch (Throwable t) {
                log.error(Messages.getMessage("fault00"), t);
            }
            finally {
                this.pool.workerDone(this, true);
                if (log.isDebugEnabled()) {
                    log.debug("Exit: MessageExchangeProvider.MesageReceiver::run");
                }
            }
        }
    }
}

