/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.ime.internal;

import java.util.Hashtable;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.ime.MessageExchange;
import org.apache.axis.ime.MessageExchangeConstants;
import org.apache.axis.ime.MessageExchangeCorrelator;
import org.apache.axis.ime.MessageExchangeEvent;
import org.apache.axis.ime.MessageExchangeEventListener;
import org.apache.axis.ime.MessageExchangeLifecycle;
import org.apache.axis.ime.event.MessageFaultEvent;
import org.apache.axis.ime.event.MessageReceiveEvent;
import org.apache.axis.ime.internal.MessageExchangeProvider;
import org.apache.axis.ime.internal.MessageExchangeReceiveContext;
import org.apache.axis.ime.internal.MessageExchangeSendContext;
import org.apache.axis.ime.internal.SimpleMessageExchangeCorrelator;
import org.apache.commons.logging.Log;

public class MessageExchangeImpl
implements MessageExchange,
MessageExchangeLifecycle {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$ime$internal$MessageExchangeImpl == null ? (class$org$apache$axis$ime$internal$MessageExchangeImpl = MessageExchangeImpl.class$("org.apache.axis.ime.internal.MessageExchangeImpl")) : class$org$apache$axis$ime$internal$MessageExchangeImpl).getName());
    public static final long NO_TIMEOUT = -1L;
    public static final long DEFAULT_TIMEOUT = 30000L;
    private MessageExchangeEventListener eventListener;
    private MessageExchangeProvider provider;
    protected Holder holder;
    static /* synthetic */ Class class$org$apache$axis$ime$internal$MessageExchangeImpl;

    public MessageExchangeImpl(MessageExchangeProvider provider) {
    }

    public MessageExchangeCorrelator send(MessageContext context) throws AxisFault {
        return this.send(context, null);
    }

    public MessageExchangeCorrelator send(MessageContext context, MessageExchangeEventListener listener) throws AxisFault {
        MessageExchangeCorrelator correlator;
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeImpl::send");
        }
        if ((correlator = (MessageExchangeCorrelator)context.getProperty(MessageExchangeConstants.MESSAGE_CORRELATOR_PROPERTY)) == null) {
            correlator = new SimpleMessageExchangeCorrelator(UUIDGenFactory.getUUIDGen(null).nextUUID());
            context.setProperty(MessageExchangeConstants.MESSAGE_CORRELATOR_PROPERTY, correlator);
        }
        MessageExchangeSendContext sendContext = MessageExchangeSendContext.newInstance(correlator, context, listener);
        if (listener != null) {
            this.provider.processReceive(sendContext);
        }
        this.provider.processSend(sendContext);
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeImpl::send");
        }
        return correlator;
    }

    public MessageContext receive() throws AxisFault {
        return this.receive(null, -1L);
    }

    public MessageContext receive(long timeout) throws AxisFault {
        return this.receive(null, timeout);
    }

    public MessageContext receive(MessageExchangeCorrelator correlator) throws AxisFault {
        return this.receive(correlator, -1L);
    }

    public MessageContext receive(MessageExchangeCorrelator correlator, long timeout) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeImpl::receive");
        }
        this.holder = new Holder();
        MessageExchangeEventListener oldListener = this.getMessageExchangeEventListener();
        Listener listener = new Listener(this.holder);
        this.setMessageExchangeEventListener(listener);
        try {
            block9: {
                try {
                    this.receive(correlator, listener);
                    if (timeout != -1L) {
                        this.holder.waitForNotify(timeout);
                        break block9;
                    }
                    this.holder.waitForNotify();
                }
                catch (InterruptedException ie) {
                    throw AxisFault.makeFault(ie);
                }
            }
            Object var8_5 = null;
            this.setMessageExchangeEventListener(oldListener);
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.setMessageExchangeEventListener(oldListener);
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeImpl::receive");
        }
        if (this.holder.context != null) {
            return this.holder.context;
        }
        if (this.holder.exception != null) {
            throw AxisFault.makeFault((Exception)this.holder.exception);
        }
        return null;
    }

    public void receive(MessageExchangeEventListener listener) throws AxisFault {
        this.receive(null, listener);
    }

    public void receive(MessageExchangeCorrelator correlator, MessageExchangeEventListener listener) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeImpl::receive");
        }
        this.provider.processReceive(MessageExchangeReceiveContext.newInstance(correlator, listener));
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeImpl::receive");
        }
    }

    public MessageContext sendAndReceive(MessageContext context) throws AxisFault {
        return this.sendAndReceive(context, -1L);
    }

    public MessageContext sendAndReceive(MessageContext context, long timeout) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeImpl::sendAndReceive");
        }
        this.holder = new Holder();
        MessageExchangeEventListener oldListener = this.getMessageExchangeEventListener();
        Listener listener = new Listener(this.holder);
        this.setMessageExchangeEventListener(listener);
        try {
            block9: {
                try {
                    this.send(context, listener);
                    if (timeout != -1L) {
                        this.holder.waitForNotify(timeout);
                        break block9;
                    }
                    this.holder.waitForNotify();
                }
                catch (InterruptedException ie) {
                    throw AxisFault.makeFault(ie);
                }
            }
            Object var8_5 = null;
            this.setMessageExchangeEventListener(oldListener);
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.setMessageExchangeEventListener(oldListener);
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeImpl::sendAndReceive");
        }
        if (this.holder.context != null) {
            return this.holder.context;
        }
        if (this.holder.exception != null) {
            throw AxisFault.makeFault((Exception)this.holder.exception);
        }
        return null;
    }

    public synchronized void setMessageExchangeEventListener(MessageExchangeEventListener listener) {
        this.eventListener = listener;
    }

    public synchronized MessageExchangeEventListener getMessageExchangeEventListener() {
        return this.eventListener;
    }

    public void setOption(String OptionId, Object OptionValue) {
        this.provider.setOption(OptionId, OptionValue);
    }

    public Object getOption(String OptionId) {
        return this.provider.getOption(OptionId);
    }

    public Object getOption(String OptionId, Object defaultValue) {
        return this.provider.getOption(OptionId, defaultValue);
    }

    public Hashtable getOptions() {
        return this.provider.getOptions();
    }

    public void setOptions(Hashtable options) {
        this.provider.setOptions(options);
    }

    public void clearOptions() {
        this.provider.clearOptions();
    }

    public void awaitShutdown() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeImpl::awaitShutdown");
        }
        this.provider.awaitShutdown();
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeImpl::awaitShutdown");
        }
    }

    public void cleanup() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeImpl::cleanup");
        }
        this.provider.cleanup();
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeImpl::cleanup");
        }
    }

    public void awaitShutdown(long timeout) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeImpl::awaitShutdown");
        }
        this.provider.awaitShutdown(timeout);
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeImpl::awaitShutdown");
        }
    }

    public void init() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeImpl::init");
        }
        this.provider.init();
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeImpl::init");
        }
    }

    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeImpl::shutdown");
        }
        this.provider.shutdown();
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeImpl::shutdown");
        }
    }

    public void shutdown(boolean force) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MessageExchangeImpl::shutdown");
        }
        this.provider.shutdown(force);
        if (log.isDebugEnabled()) {
            log.debug("Exit: MessageExchangeImpl::shutdown");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Listener
    implements MessageExchangeEventListener {
        protected Holder holder;

        public Listener(Holder holder) {
            this.holder = holder;
        }

        public void onEvent(MessageExchangeEvent event) {
            if (event instanceof MessageReceiveEvent) {
                MessageReceiveEvent receiveEvent = (MessageReceiveEvent)event;
                this.holder.set(receiveEvent.getMessageExchangeCorrelator(), receiveEvent.getMessageContext());
            } else if (event instanceof MessageFaultEvent) {
                MessageFaultEvent faultEvent = (MessageFaultEvent)event;
                this.holder.set(faultEvent.getMessageExchangeCorrelator(), faultEvent.getException());
            }
        }
    }

    private class Holder {
        private MessageExchangeCorrelator correlator;
        private MessageContext context;
        private Throwable exception;
        private boolean done = false;

        private Holder() {
        }

        public synchronized void set(MessageExchangeCorrelator correlator, MessageContext context) {
            this.correlator = correlator;
            this.context = context;
            this.done = true;
            this.notifyAll();
        }

        public synchronized void set(MessageExchangeCorrelator correlator, Throwable throwable) {
            this.correlator = correlator;
            this.exception = throwable;
            this.done = true;
            this.notifyAll();
        }

        public synchronized void waitForNotify() throws InterruptedException {
            if (!this.done) {
                this.wait();
            }
        }

        public synchronized void waitForNotify(long timeout) throws InterruptedException {
            if (!this.done) {
                this.wait(timeout);
            }
        }
    }
}

