/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PropertyChangeMulticaster
implements PropertyChangeListener {
    private transient PropertyChangeListener[] listeners;

    public void propertyChange(PropertyChangeEvent e) {
        if (this.listeners != null) {
            this.dispatch(e);
        }
    }

    public final boolean hasListeners() {
        return this.listeners != null;
    }

    public final void dispatch(PropertyChangeEvent event) {
        PropertyChangeListener[] listenersCopy = this.listeners;
        if (listenersCopy != null) {
            int count = listenersCopy.length;
            for (int i = 0; i < count; ++i) {
                listenersCopy[i].propertyChange(event);
            }
        }
    }

    public int find(PropertyChangeListener listener) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != listener) continue;
                return i;
            }
        }
        return -1;
    }

    public final synchronized void add(PropertyChangeListener listener) {
        if (this.find(listener) < 0) {
            PropertyChangeListener[] newListeners;
            if (this.listeners == null) {
                newListeners = new PropertyChangeListener[1];
            } else {
                newListeners = new PropertyChangeListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
            }
            newListeners[newListeners.length - 1] = listener;
            this.listeners = newListeners;
        }
    }

    public final synchronized void remove(PropertyChangeListener listener) {
        int index = this.find(listener);
        if (index > -1) {
            if (this.listeners.length == 1) {
                this.listeners = null;
            } else {
                PropertyChangeListener[] newListeners = new PropertyChangeListener[this.listeners.length - 1];
                System.arraycopy(this.listeners, 0, newListeners, 0, index);
                if (index < newListeners.length) {
                    System.arraycopy(this.listeners, index + 1, newListeners, index, newListeners.length - index);
                }
                this.listeners = newListeners;
            }
        }
    }
}

