/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.layout.PaneLayout;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.BeanPanel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

public class SplitPanel
extends BeanPanel
implements MouseListener,
MouseMotionListener,
Serializable {
    PaneLayout layout = new PaneLayout();
    Canvas paneLayoutDivider = new Canvas();
    Cursor cursor;
    boolean yChanges;
    int xDelta;
    int yDelta;
    Rectangle dividerRect;
    Rectangle dividerBounds;
    boolean isSizing = false;
    boolean mouseOverPanel = false;
    transient Rectangle bounds;
    transient Component[] enabledComponents;
    String textureName;

    public SplitPanel() {
        super(null);
        this.setFocusAware(false);
        this.paneLayoutDivider.setName("SplitPanel.splitter");
        this.add(this.paneLayoutDivider);
        this.paneLayoutDivider.setVisible(false);
        this.paneLayoutDivider.setEnabled(false);
        this.setDividerColor(Color.black);
        this.layout.setGap(2);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        super.setLayout(this.layout);
    }

    public void setGap(int gap) {
        this.layout.setGap(gap);
    }

    public int getGap() {
        return this.layout.getGap();
    }

    public void setDividerColor(Color color) {
        this.paneLayoutDivider.setBackground(color);
    }

    public Color getDividerColor() {
        return this.paneLayoutDivider.getBackground();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String path) {
        if (path != null && !path.equals("")) {
            Image i = ImageLoader.load(path, (Component)this);
            if (i == null) throw new IllegalArgumentException(path);
            ImageLoader.waitForImage(this, i);
            this.textureName = path;
            this.setTexture(i);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public void setLayout(LayoutManager mgr) {
        if (mgr instanceof PaneLayout) {
            this.layout = (PaneLayout)mgr;
            super.setLayout(mgr);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getComponent() != this || !this.mouseOverPanel) {
            return;
        }
        int mouseX = e.getX();
        int mouseY = e.getY();
        if (this.mouseOverPanel) {
            this.dividerRect = this.layout.getDividerRect(mouseX, mouseY);
        }
        if (this.dividerRect != null) {
            this.dividerBounds = this.layout.getDividerBounds();
            if (this.dividerRect.width > this.dividerRect.height) {
                this.yChanges = true;
                this.yDelta = mouseY - this.dividerRect.y;
            } else {
                this.yChanges = false;
                this.xDelta = mouseX - this.dividerRect.x;
            }
            this.isSizing = true;
            this.bounds = this.getBounds();
            Component[] all = this.getComponents();
            this.enabledComponents = new Component[all.length];
            for (int i = 0; i < all.length; ++i) {
                if (!all[i].isEnabled()) continue;
                this.enabledComponents[i] = all[i];
                all[i].setEnabled(false);
            }
            this.add((Component)this.paneLayoutDivider, 0);
            this.paneLayoutDivider.setBounds(this.dividerRect.x, this.dividerRect.y, this.dividerRect.width, this.dividerRect.height);
            this.paneLayoutDivider.setVisible(true);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.paneLayoutDivider.setVisible(false);
        if (this.isSizing) {
            this.isSizing = false;
            for (int i = 0; i < this.enabledComponents.length; ++i) {
                if (this.enabledComponents[i] == null) continue;
                this.enabledComponents[i].setEnabled(true);
            }
            this.setCursor(this.cursor);
        }
        this.validate();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.mouseOverPanel = false;
        if (this.cursor != null && !this.isSizing) {
            this.setCursor(this.cursor);
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseOverPanel = true;
        if (!this.isSizing) {
            this.cursor = this.getCursor();
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.isSizing = false;
        if (e.getComponent() != this) {
            return;
        }
        Rectangle rect = this.layout.getDividerRect(e.getX(), e.getY());
        if (rect != null) {
            if (rect.width > rect.height) {
                this.setCursor(Cursor.getPredefinedCursor(8));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isSizing) {
            int xD = this.dividerRect.x;
            int yD = this.dividerRect.y;
            int y = e.getY();
            int x = e.getX();
            if (y <= this.bounds.y || y >= this.bounds.y + this.bounds.height) {
                return;
            }
            if (x <= this.bounds.x || x >= this.bounds.x + this.bounds.width) {
                return;
            }
            if (this.yChanges) {
                yD = y - this.yDelta;
                if (yD < this.dividerBounds.y) {
                    yD = this.dividerBounds.y;
                } else if (yD > this.dividerBounds.height + this.dividerBounds.y - 1) {
                    yD = this.dividerBounds.height + this.dividerBounds.y - 1;
                }
            } else {
                xD = x - this.xDelta;
                if (xD > this.dividerBounds.width + this.dividerBounds.x - 1) {
                    xD = this.dividerBounds.width + this.dividerBounds.x - 1;
                } else if (xD < this.dividerBounds.x) {
                    xD = this.dividerBounds.x;
                }
            }
            this.layout.dragDivider(xD, yD);
            this.dividerRect.x = xD;
            this.dividerRect.y = yD;
            this.paneLayoutDivider.setLocation(xD, yD);
        }
    }

    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        if (ps.width == 10) {
            ps.width = 100;
        }
        if (ps.height == 10) {
            ps.height = 100;
        }
        return ps;
    }
}

