/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XStringForFSB
extends XString {
    int m_start;
    int m_length;
    protected String m_strCache = null;
    protected int m_hash = 0;

    public XStringForFSB(FastStringBuffer val, int start, int length) {
        super(val);
        this.m_start = start;
        this.m_length = length;
        if (null == val) {
            throw new IllegalArgumentException("The FastStringBuffer argument can not be null!!");
        }
    }

    private XStringForFSB(String val) {
        super(val);
        throw new IllegalArgumentException("XStringForFSB can not take a string for an argument!");
    }

    public FastStringBuffer fsb() {
        return (FastStringBuffer)this.m_obj;
    }

    public void appendToFsb(FastStringBuffer fsb) {
        fsb.append(this.str());
    }

    public boolean hasString() {
        return null != this.m_strCache;
    }

    public Object object() {
        return this.str();
    }

    public String str() {
        if (null == this.m_strCache) {
            this.m_strCache = this.fsb().getString(this.m_start, this.m_length);
        }
        return this.m_strCache;
    }

    public void dispatchCharactersEvents(ContentHandler ch) throws SAXException {
        this.fsb().sendSAXcharacters(ch, this.m_start, this.m_length);
    }

    public void dispatchAsComment(LexicalHandler lh) throws SAXException {
        this.fsb().sendSAXComment(lh, this.m_start, this.m_length);
    }

    public int length() {
        return this.m_length;
    }

    public char charAt(int index) {
        return this.fsb().charAt(this.m_start + index);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        int n2 = srcEnd - srcBegin;
        if (n2 > this.m_length) {
            n2 = this.m_length;
        }
        if (n2 > dst.length - dstBegin) {
            n2 = dst.length - dstBegin;
        }
        int end = srcBegin + this.m_start + n2;
        int d2 = dstBegin;
        FastStringBuffer fsb = this.fsb();
        int i2 = srcBegin + this.m_start;
        while (i2 < end) {
            dst[d2++] = fsb.charAt(i2);
            ++i2;
        }
    }

    public boolean equals(XMLString obj2) {
        if (this == obj2) {
            return true;
        }
        int n2 = this.m_length;
        if (n2 == obj2.length()) {
            FastStringBuffer fsb = this.fsb();
            int i2 = this.m_start;
            int j2 = 0;
            while (n2-- != 0) {
                if (fsb.charAt(i2) != obj2.charAt(j2)) {
                    return false;
                }
                ++i2;
                ++j2;
            }
            return true;
        }
        return false;
    }

    public boolean equals(XObject obj2) {
        if (this == obj2) {
            return true;
        }
        int n2 = this.m_length;
        String str = obj2.str();
        if (n2 == str.length()) {
            FastStringBuffer fsb = this.fsb();
            int i2 = this.m_start;
            int j2 = 0;
            while (n2-- != 0) {
                if (fsb.charAt(i2) != str.charAt(j2)) {
                    return false;
                }
                ++i2;
                ++j2;
            }
            return true;
        }
        return false;
    }

    public boolean equals(String anotherString) {
        int n2 = this.m_length;
        if (n2 == anotherString.length()) {
            FastStringBuffer fsb = this.fsb();
            int i2 = this.m_start;
            int j2 = 0;
            while (n2-- != 0) {
                if (fsb.charAt(i2) != anotherString.charAt(j2)) {
                    return false;
                }
                ++i2;
                ++j2;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object obj2) {
        if (null == obj2) {
            return false;
        }
        if (obj2 instanceof XNodeSet) {
            return obj2.equals(this);
        }
        if (obj2 instanceof XStringForFSB) {
            return this.equals(this);
        }
        return this.equals(obj2.toString());
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this.m_length == anotherString.length() ? this.str().equalsIgnoreCase(anotherString) : false;
    }

    public int compareTo(XMLString xstr) {
        int len1 = this.m_length;
        int len2 = xstr.length();
        int n2 = Math.min(len1, len2);
        FastStringBuffer fsb = this.fsb();
        int i2 = this.m_start;
        int j2 = 0;
        while (n2-- != 0) {
            char c2;
            char c1 = fsb.charAt(i2);
            if (c1 != (c2 = xstr.charAt(j2))) {
                return c1 - c2;
            }
            ++i2;
            ++j2;
        }
        return len1 - len2;
    }

    public int compareToIgnoreCase(XMLString xstr) {
        int len1 = this.m_length;
        int len2 = xstr.length();
        int n2 = Math.min(len1, len2);
        FastStringBuffer fsb = this.fsb();
        int i2 = this.m_start;
        int j2 = 0;
        while (n2-- != 0) {
            char c2;
            char c1 = Character.toLowerCase(fsb.charAt(i2));
            if (c1 != (c2 = Character.toLowerCase(xstr.charAt(j2)))) {
                return c1 - c2;
            }
            ++i2;
            ++j2;
        }
        return len1 - len2;
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * Unable to fully structure code
     */
    public boolean startsWith(XMLString prefix, int toffset) {
        fsb = this.fsb();
        to = this.m_start + toffset;
        tlim = this.m_start + this.m_length;
        po = 0;
        pc = prefix.length();
        if (toffset >= 0 && toffset <= this.m_length - pc) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            if (fsb.charAt(to) != prefix.charAt(po)) {
                return false;
            }
            ++to;
            ++po;
lbl12:
            // 2 sources

            ** while (--pc >= 0)
        }
lbl13:
        // 1 sources

        return true;
    }

    public boolean startsWith(XMLString prefix) {
        return this.startsWith(prefix, 0);
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int max = this.m_start + this.m_length;
        FastStringBuffer fsb = this.fsb();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.m_length) {
            return -1;
        }
        int i2 = this.m_start + fromIndex;
        while (i2 < max) {
            if (fsb.charAt(i2) == ch) {
                return i2 - this.m_start;
            }
            ++i2;
        }
        return -1;
    }

    public XMLString substring(int beginIndex) {
        int len = this.m_length - beginIndex;
        if (len <= 0) {
            return XString.EMPTYSTRING;
        }
        int start = this.m_start + beginIndex;
        return new XStringForFSB(this.fsb(), start, len);
    }

    public XMLString substring(int beginIndex, int endIndex) {
        int len = endIndex - beginIndex;
        if (len > this.m_length) {
            len = this.m_length;
        }
        if (len <= 0) {
            return XString.EMPTYSTRING;
        }
        int start = this.m_start + beginIndex;
        return new XStringForFSB(this.fsb(), start, len);
    }

    public XMLString concat(String str) {
        return new XString(this.str().concat(str));
    }

    public XMLString trim() {
        return this.fixWhiteSpace(true, true, false);
    }

    private static boolean isSpace(char ch) {
        return XMLCharacterRecognizer.isWhiteSpace(ch);
    }

    public XMLString fixWhiteSpace(boolean trimHead, boolean trimTail, boolean doublePunctuationSpaces) {
        int end = this.m_length + this.m_start;
        char[] buf = new char[this.m_length];
        FastStringBuffer fsb = this.fsb();
        boolean edit = false;
        int d2 = 0;
        boolean pres = false;
        int s2 = this.m_start;
        while (s2 < end) {
            char c2 = fsb.charAt(s2);
            if (XStringForFSB.isSpace(c2)) {
                if (!pres) {
                    if (' ' != c2) {
                        edit = true;
                    }
                    buf[d2++] = 32;
                    if (doublePunctuationSpaces && d2 != 0) {
                        char prevChar = buf[d2 - 1];
                        if (prevChar != '.' && prevChar != '!' && prevChar != '?') {
                            pres = true;
                        }
                    } else {
                        pres = true;
                    }
                } else {
                    edit = true;
                    pres = true;
                }
            } else {
                buf[d2++] = c2;
                pres = false;
            }
            ++s2;
        }
        if (trimTail && 1 <= d2 && ' ' == buf[d2 - 1]) {
            edit = true;
            --d2;
        }
        int start = 0;
        if (trimHead && 0 < d2 && ' ' == buf[0]) {
            edit = true;
            ++start;
        }
        XMLStringFactory xsf = XMLStringFactoryImpl.getFactory();
        return edit ? xsf.newstr(buf, start, d2 - start) : this;
    }

    public double toDouble() {
        int end = this.m_length + this.m_start;
        if (0 == end) {
            return Double.NaN;
        }
        int start = this.m_start;
        FastStringBuffer fsb = this.fsb();
        long longResult = 0L;
        boolean isNegative = false;
        boolean trailingSpace = false;
        int[] digitsFound = new int[]{0, 0};
        int digitType = 0;
        while (start < end && XMLCharacterRecognizer.isWhiteSpace(fsb.charAt(start))) {
            ++start;
        }
        if (start < end && fsb.charAt(start) == '-') {
            isNegative = true;
            ++start;
        }
        int i2 = start;
        while (i2 < end) {
            char c2 = fsb.charAt(i2);
            if (XMLCharacterRecognizer.isWhiteSpace(c2)) {
                trailingSpace = true;
                break;
            }
            if (trailingSpace) {
                return Double.NaN;
            }
            switch (c2) {
                case '.': {
                    if (digitType == 0) {
                        digitType = 1;
                        break;
                    }
                    return Double.NaN;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    longResult = longResult * 10L + (long)(c2 - 48);
                    int n2 = digitType;
                    digitsFound[n2] = digitsFound[n2] + 1;
                    break;
                }
                default: {
                    return Double.NaN;
                }
            }
            ++i2;
        }
        if (0 == digitsFound[0] && 0 == digitsFound[1]) {
            return Double.NaN;
        }
        long scale = 1L;
        int i3 = digitsFound[1];
        while (i3 > 0) {
            scale *= 10L;
            --i3;
        }
        double doubleResult = (double)longResult / (double)scale;
        if (isNegative) {
            doubleResult *= -1.0;
        }
        return doubleResult;
    }
}

