/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.Vector;
import org.apache.xpath.Expression;
import org.apache.xpath.functions.Function3Args;
import org.apache.xpath.functions.WrongNumberArgsException;

public class FunctionMultiArgs
extends Function3Args {
    Expression[] m_args;

    public void setArg(Expression arg, int argNum) throws WrongNumberArgsException {
        if (argNum < 3) {
            super.setArg(arg, argNum);
        } else if (null == this.m_args) {
            this.m_args = new Expression[1];
            this.m_args[0] = arg;
        } else {
            Expression[] args = new Expression[this.m_args.length + 1];
            System.arraycopy(this.m_args, 0, args, 0, this.m_args.length);
            args[this.m_args.length] = arg;
            this.m_args = args;
        }
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        if (null != this.m_args) {
            int i2 = 0;
            while (i2 < this.m_args.length) {
                this.m_args[i2].fixupVariables(vars, globalsSize);
                ++i2;
            }
        }
    }

    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
    }

    public boolean canTraverseOutsideSubtree() {
        if (super.canTraverseOutsideSubtree()) {
            return true;
        }
        int n2 = this.m_args.length;
        int i2 = 0;
        while (i2 < n2) {
            if (this.m_args[i2].canTraverseOutsideSubtree()) {
                return true;
            }
            ++i2;
        }
        return false;
    }
}

