/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.lang.reflect.Method;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.ExtensionsTable;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.IntStack;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.SourceTreeManager;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.OneStepIteratorForward;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.XMLReader;

public class XPathContext
extends DTMManager {
    private DTMManager m_dtmManager = DTMManager.newInstance(XMLStringFactoryImpl.getFactory());
    SourceLocator[] m_saxLocations = new SourceLocator[4096];
    int m_saxLocationsTop = 0;
    private Object m_owner;
    private Method m_ownerGetErrorListener;
    private ExtensionsTable m_extensionsTable = new ExtensionsTable();
    private VariableStack m_variableStacks = new VariableStack();
    private SourceTreeManager m_sourceTreeManager = new SourceTreeManager();
    private ErrorListener m_errorListener;
    private ErrorListener m_defaultErrorListener;
    private URIResolver m_uriResolver;
    public XMLReader m_primaryReader;
    private static XSLMessages m_XSLMessages = new XSLMessages();
    private Stack m_contextNodeLists = new Stack();
    public static final int RECURSIONLIMIT = 4096;
    private int[] m_currentNodes = new int[4096];
    protected int m_currentNodesFirstFree = 0;
    private NodeVector m_iteratorRoots = new NodeVector();
    private NodeVector m_predicateRoots = new NodeVector();
    private int[] m_currentExpressionNodes = new int[4096];
    protected int m_currentExpressionNodesFirstFree = 0;
    private IntStack m_predicatePos = new IntStack();
    private PrefixResolver[] m_prefixResolvers = new PrefixResolver[4096];
    private int m_prefixResolversTop = 0;
    private Stack m_axesIteratorStack = new Stack();
    XPathExpressionContext expressionContext = new XPathExpressionContext();

    public DTMManager getDTMManager() {
        return this.m_dtmManager;
    }

    public DTM getDTM(Source source, boolean unique, DTMWSFilter wsfilter, boolean incremental, boolean doIndexing) {
        return this.m_dtmManager.getDTM(source, unique, wsfilter, incremental, doIndexing);
    }

    public DTM getDTM(int nodeHandle) {
        return this.m_dtmManager.getDTM(nodeHandle);
    }

    public int getDTMHandleFromNode(Node node) {
        return this.m_dtmManager.getDTMHandleFromNode(node);
    }

    public int getDTMIdentity(DTM dtm) {
        return this.m_dtmManager.getDTMIdentity(dtm);
    }

    public DTM createDocumentFragment() {
        return this.m_dtmManager.createDocumentFragment();
    }

    public boolean release(DTM dtm, boolean shouldHardDelete) {
        return this.m_dtmManager.release(dtm, shouldHardDelete);
    }

    public DTMIterator createDTMIterator(Object xpathCompiler, int pos) {
        return this.m_dtmManager.createDTMIterator(xpathCompiler, pos);
    }

    public DTMIterator createDTMIterator(String xpathString, PrefixResolver presolver) {
        return this.m_dtmManager.createDTMIterator(xpathString, presolver);
    }

    public DTMIterator createDTMIterator(int whatToShow, DTMFilter filter, boolean entityReferenceExpansion) {
        return this.m_dtmManager.createDTMIterator(whatToShow, filter, entityReferenceExpansion);
    }

    public DTMIterator createDTMIterator(int node) {
        OneStepIteratorForward iter = new OneStepIteratorForward(13);
        iter.setRoot(node, this);
        return iter;
    }

    public XPathContext() {
        this.m_prefixResolvers[this.m_prefixResolversTop++] = null;
        this.m_currentNodes[this.m_currentNodesFirstFree++] = -1;
        this.m_currentNodes[this.m_currentExpressionNodesFirstFree++] = -1;
        this.m_saxLocations[this.m_saxLocationsTop++] = null;
    }

    public XPathContext(Object owner) {
        this.m_owner = owner;
        try {
            this.m_ownerGetErrorListener = this.m_owner.getClass().getMethod("getErrorListener", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.m_prefixResolvers[this.m_prefixResolversTop++] = null;
        this.m_currentNodes[this.m_currentNodesFirstFree++] = -1;
        this.m_currentNodes[this.m_currentExpressionNodesFirstFree++] = -1;
        this.m_saxLocations[this.m_saxLocationsTop++] = null;
    }

    public void reset() {
        this.m_dtmManager = DTMManager.newInstance(XMLStringFactoryImpl.getFactory());
    }

    public void setSAXLocator(SourceLocator location) {
        this.m_saxLocations[this.m_saxLocationsTop - 1] = location;
    }

    public void pushSAXLocator(SourceLocator location) {
        this.m_saxLocations[this.m_saxLocationsTop++] = location;
    }

    public void pushSAXLocatorNull() {
        ++this.m_saxLocationsTop;
    }

    public void popSAXLocator() {
        --this.m_saxLocationsTop;
    }

    public SourceLocator getSAXLocator() {
        return this.m_saxLocations[this.m_saxLocationsTop - 1];
    }

    public Object getOwnerObject() {
        return this.m_owner;
    }

    public ExtensionsTable getExtensionsTable() {
        return this.m_extensionsTable;
    }

    void setExtensionsTable(ExtensionsTable table) {
        this.m_extensionsTable = table;
    }

    public final VariableStack getVarStack() {
        return this.m_variableStacks;
    }

    public final void setVarStack(VariableStack varStack) {
        this.m_variableStacks = varStack;
    }

    public final SourceTreeManager getSourceTreeManager() {
        return this.m_sourceTreeManager;
    }

    public void setSourceTreeManager(SourceTreeManager mgr) {
        this.m_sourceTreeManager = mgr;
    }

    public final ErrorListener getErrorListener() {
        if (null != this.m_errorListener) {
            return this.m_errorListener;
        }
        ErrorListener retval = null;
        try {
            if (null != this.m_ownerGetErrorListener) {
                retval = (ErrorListener)this.m_ownerGetErrorListener.invoke(this.m_owner, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == retval) {
            if (null == this.m_defaultErrorListener) {
                this.m_defaultErrorListener = new DefaultErrorHandler();
            }
            retval = this.m_defaultErrorListener;
        }
        return retval;
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException(XSLMessages.createXPATHMessage(75, null));
        }
        this.m_errorListener = listener;
    }

    public final URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this.m_uriResolver = resolver;
    }

    public final XMLReader getPrimaryReader() {
        return this.m_primaryReader;
    }

    public void setPrimaryReader(XMLReader reader) {
        this.m_primaryReader = reader;
    }

    private void assertion(boolean b2, String msg) throws TransformerException {
        ErrorListener errorHandler = this.getErrorListener();
        if (errorHandler != null) {
            errorHandler.fatalError(new TransformerException(XSLMessages.createMessage(30, new Object[]{msg}), (SAXSourceLocator)this.getSAXLocator()));
        }
    }

    public Stack getContextNodeListsStack() {
        return this.m_contextNodeLists;
    }

    public void setContextNodeListsStack(Stack s2) {
        this.m_contextNodeLists = s2;
    }

    public final DTMIterator getContextNodeList() {
        if (this.m_contextNodeLists.size() > 0) {
            return (DTMIterator)this.m_contextNodeLists.peek();
        }
        return null;
    }

    public final void pushContextNodeList(DTMIterator nl) {
        this.m_contextNodeLists.push(nl);
    }

    public final void popContextNodeList() {
        this.m_contextNodeLists.pop();
    }

    public int[] getCurrentNodeStack() {
        return this.m_currentNodes;
    }

    public void setCurrentNodeStack(int[] nv) {
        this.m_currentNodes = nv;
    }

    public final int getCurrentNode() {
        return this.m_currentNodes[this.m_currentNodesFirstFree - 1];
    }

    public final void pushCurrentNodeAndExpression(int cn, int en) {
        this.m_currentNodes[this.m_currentNodesFirstFree++] = cn;
        this.m_currentExpressionNodes[this.m_currentExpressionNodesFirstFree++] = cn;
    }

    public final void popCurrentNodeAndExpression() {
        --this.m_currentNodesFirstFree;
        --this.m_currentExpressionNodesFirstFree;
    }

    public final void pushExpressionState(int cn, int en, PrefixResolver nc) {
        this.m_currentNodes[this.m_currentNodesFirstFree++] = cn;
        this.m_currentExpressionNodes[this.m_currentExpressionNodesFirstFree++] = cn;
        this.m_prefixResolvers[this.m_prefixResolversTop++] = nc;
    }

    public final void popExpressionState() {
        --this.m_currentNodesFirstFree;
        --this.m_currentExpressionNodesFirstFree;
        --this.m_prefixResolversTop;
    }

    public final void pushCurrentNode(int n2) {
        this.m_currentNodes[this.m_currentNodesFirstFree++] = n2;
    }

    public int getCurrentNodeFirstFree() {
        return this.m_currentNodesFirstFree;
    }

    public final void popCurrentNode() {
        --this.m_currentNodesFirstFree;
    }

    public final void pushPredicateRoot(int n2) {
        this.m_predicateRoots.push(n2);
    }

    public final void popPredicateRoot() {
        this.m_predicateRoots.popQuick();
    }

    public final int getPredicateRoot() {
        return this.m_predicateRoots.peepOrNull();
    }

    public final void pushIteratorRoot(int n2) {
        this.m_iteratorRoots.push(n2);
    }

    public final void popIteratorRoot() {
        this.m_iteratorRoots.popQuick();
    }

    public final int getIteratorRoot() {
        return this.m_iteratorRoots.peepOrNull();
    }

    public int[] getCurrentExpressionNodeStack() {
        return this.m_currentExpressionNodes;
    }

    public void setCurrentExpressionNodeStack(int[] nv) {
        this.m_currentExpressionNodes = nv;
    }

    public int getCurrentExpressionNodesFirstFree() {
        return this.m_currentExpressionNodesFirstFree;
    }

    public final int getPredicatePos() {
        return this.m_predicatePos.peek();
    }

    public final void pushPredicatePos(int n2) {
        this.m_predicatePos.push(n2);
    }

    public final void popPredicatePos() {
        this.m_predicatePos.pop();
    }

    public final int getCurrentExpressionNode() {
        return this.m_currentExpressionNodes[this.m_currentExpressionNodesFirstFree - 1];
    }

    public final void pushCurrentExpressionNode(int n2) {
        this.m_currentExpressionNodes[this.m_currentExpressionNodesFirstFree++] = n2;
    }

    public final void popCurrentExpressionNode() {
        --this.m_currentExpressionNodesFirstFree;
    }

    public final PrefixResolver getNamespaceContext() {
        return this.m_prefixResolvers[this.m_prefixResolversTop - 1];
    }

    public final void setNamespaceContext(PrefixResolver pr) {
        this.m_prefixResolvers[this.m_prefixResolversTop - 1] = pr;
    }

    public final void pushNamespaceContext(PrefixResolver pr) {
        this.m_prefixResolvers[this.m_prefixResolversTop++] = pr;
    }

    public final void pushNamespaceContextNull() {
        ++this.m_prefixResolversTop;
    }

    public final void popNamespaceContext() {
        --this.m_prefixResolversTop;
    }

    public Stack getAxesIteratorStackStacks() {
        return this.m_axesIteratorStack;
    }

    public void setAxesIteratorStackStacks(Stack s2) {
        this.m_axesIteratorStack = s2;
    }

    public final void pushSubContextList(SubContextList iter) {
        this.m_axesIteratorStack.push(iter);
    }

    public final void popSubContextList() {
        this.m_axesIteratorStack.pop();
    }

    public SubContextList getSubContextList() {
        return this.m_axesIteratorStack.isEmpty() ? null : (SubContextList)this.m_axesIteratorStack.peek();
    }

    public LocPathIterator getCurrentNodeList() {
        int i2 = this.m_axesIteratorStack.size() - 1;
        while (i2 >= 0) {
            PredicatedNodeTest iter = (PredicatedNodeTest)this.m_axesIteratorStack.elementAt(i2);
            LocPathIterator lpi = iter.getLocPathIterator();
            if (lpi.getIsTopLevel()) {
                return lpi;
            }
            --i2;
        }
        return null;
    }

    public final int getContextNode() {
        return this.getCurrentNode();
    }

    public final DTMIterator getContextNodes() {
        try {
            DTMIterator cnl = this.getContextNodeList();
            if (null != cnl) {
                return cnl.cloneWithReset();
            }
            return null;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public class XPathExpressionContext
    implements ExpressionContext {
        public XPathContext getXPathContext() {
            return XPathContext.this;
        }

        public DTMManager getDTMManager() {
            return XPathContext.this.m_dtmManager;
        }

        public Node getContextNode() {
            int context = XPathContext.this.getCurrentNode();
            return XPathContext.this.getDTM(context).getNode(context);
        }

        public NodeIterator getContextNodes() {
            return new DTMNodeIterator(XPathContext.this.getContextNodeList());
        }

        public double toNumber(Node n2) {
            int nodeHandle = XPathContext.this.getDTMHandleFromNode(n2);
            DTM dtm = XPathContext.this.getDTM(nodeHandle);
            XString xobj = (XString)dtm.getStringValue(nodeHandle);
            return xobj.num();
        }

        public String toString(Node n2) {
            int nodeHandle = XPathContext.this.getDTMHandleFromNode(n2);
            DTM dtm = XPathContext.this.getDTM(nodeHandle);
            XMLString strVal = dtm.getStringValue(nodeHandle);
            return strVal.toString();
        }

        public final XObject getVariableOrParam(QName qname) throws TransformerException {
            return XPathContext.this.m_variableStacks.getVariableOrParam(XPathContext.this, qname);
        }
    }
}

