/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.utils.NodeVector;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSetDTM
extends NodeVector
implements DTMIterator,
Cloneable {
    DTMManager m_manager;
    protected transient int m_next = 0;
    protected transient boolean m_mutable = true;
    protected transient boolean m_cacheNodes = true;
    protected int m_root = -1;
    private transient int m_last = 0;

    public NodeSetDTM(DTMManager dtmManager) {
        this.m_manager = dtmManager;
    }

    public NodeSetDTM(int blocksize, int dummy, DTMManager dtmManager) {
        super(blocksize);
        this.m_manager = dtmManager;
    }

    public NodeSetDTM(NodeSetDTM nodelist) {
        this.m_manager = nodelist.getDTMManager();
        this.m_root = nodelist.getRoot();
        this.addNodes(nodelist);
    }

    public NodeSetDTM(DTMIterator ni) {
        this.m_manager = ni.getDTMManager();
        this.m_root = ni.getRoot();
        this.addNodes(ni);
    }

    /*
     * WARNING - void declaration
     */
    public NodeSetDTM(NodeIterator iterator, XPathContext xctxt) {
        Node node;
        this.m_manager = xctxt.getDTMManager();
        while (null != (node = iterator.nextNode())) {
            void var3_3;
            int handle = xctxt.getDTMHandleFromNode((Node)var3_3);
            this.addNodeInDocOrder(handle, xctxt);
        }
    }

    public NodeSetDTM(NodeList nodeList, XPathContext xctxt) {
        this.m_manager = xctxt.getDTMManager();
        int n2 = nodeList.getLength();
        int i2 = 0;
        while (i2 < n2) {
            Node node = nodeList.item(i2);
            int handle = xctxt.getDTMHandleFromNode(node);
            this.addNode(handle);
            ++i2;
        }
    }

    public NodeSetDTM(int node, DTMManager dtmManager) {
        this.m_manager = dtmManager;
        this.addNode(node);
    }

    public void setEnvironment(Object environment) {
    }

    public int getRoot() {
        if (-1 == this.m_root) {
            if (this.size() > 0) {
                return this.item(0);
            }
            return -1;
        }
        return this.m_root;
    }

    public void setRoot(int context, Object environment) {
    }

    public Object clone() throws CloneNotSupportedException {
        NodeSetDTM clone = (NodeSetDTM)super.clone();
        return clone;
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSetDTM clone = (NodeSetDTM)this.clone();
        clone.reset();
        return clone;
    }

    public void reset() {
        this.m_next = 0;
    }

    public int getWhatToShow() {
        return -17;
    }

    public DTMFilter getFilter() {
        return null;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public DTM getDTM(int nodeHandle) {
        return this.m_manager.getDTM(nodeHandle);
    }

    public DTMManager getDTMManager() {
        return this.m_manager;
    }

    public int nextNode() {
        if (this.m_next < this.size()) {
            int next = this.elementAt(this.m_next);
            ++this.m_next;
            return next;
        }
        return -1;
    }

    public int previousNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSetDTM can not iterate to a previous node!");
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return -1;
    }

    public void detach() {
    }

    public void allowDetachToRelease(boolean allowRelease) {
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public void runTo(int index) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        this.m_next = index >= 0 && this.m_next < this.m_firstFree ? index : this.m_firstFree - 1;
    }

    public int item(int index) {
        this.runTo(index);
        return this.elementAt(index);
    }

    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public void addNode(int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        this.addElement(n2);
    }

    public void insertNode(int n2, int pos) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        this.insertElementAt(n2, pos);
    }

    public void removeNode(int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        this.removeElement(n2);
    }

    /*
     * WARNING - void declaration
     */
    public void addNodes(DTMIterator iterator) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        if (null != iterator) {
            int obj;
            while (-1 != (obj = iterator.nextNode())) {
                void var2_2;
                this.addElement((int)var2_2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addNodesInDocOrder(DTMIterator iterator, XPathContext support) {
        if (this.m_mutable) ** GOTO lbl5
        throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
lbl-1000:
        // 1 sources

        {
            this.addNodeInDocOrder((int)var3_3, support);
lbl5:
            // 2 sources

            ** while (-1 != (node = iterator.nextNode()))
        }
lbl6:
        // 1 sources

    }

    public int addNodeInDocOrder(int node, boolean test, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        int insertIndex = -1;
        if (test) {
            int size = this.size();
            int i2 = size - 1;
            while (i2 >= 0) {
                int child = this.elementAt(i2);
                if (child == node) {
                    i2 = -2;
                    break;
                }
                DTM dtm = support.getDTM(node);
                if (!dtm.isNodeAfter(node, child)) break;
                --i2;
            }
            if (i2 != -2) {
                insertIndex = i2 + 1;
                this.insertElementAt(node, insertIndex);
            }
        } else {
            insertIndex = this.size();
            boolean foundit = false;
            int i3 = 0;
            while (i3 < insertIndex) {
                if (i3 == node) {
                    foundit = true;
                    break;
                }
                ++i3;
            }
            if (!foundit) {
                this.addElement(node);
            }
        }
        return insertIndex;
    }

    public int addNodeInDocOrder(int node, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        return this.addNodeInDocOrder(node, true, support);
    }

    public int size() {
        return super.size();
    }

    public void addElement(int value) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.addElement(value);
    }

    public void insertElementAt(int value, int at) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.insertElementAt(value, at);
    }

    public void appendNodes(NodeVector nodes) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.appendNodes(nodes);
    }

    public void removeAllElements() {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.removeAllElements();
    }

    public boolean removeElement(int s2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        return super.removeElement(s2);
    }

    public void removeElementAt(int i2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.removeElementAt(i2);
    }

    public void setElementAt(int node, int index) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.setElementAt(node, index);
    }

    public void setItem(int node, int index) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(73, null));
        }
        super.setElementAt(node, index);
    }

    public int elementAt(int i2) {
        this.runTo(i2);
        return super.elementAt(i2);
    }

    public boolean contains(int s2) {
        this.runTo(-1);
        return super.contains(s2);
    }

    public int indexOf(int elem, int index) {
        this.runTo(-1);
        return super.indexOf(elem, index);
    }

    public int indexOf(int elem) {
        this.runTo(-1);
        return super.indexOf(elem);
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public void setCurrentPos(int i2) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        this.m_next = i2;
    }

    public int getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        int saved = this.m_next;
        int current = this.m_next > 0 ? this.m_next - 1 : this.m_next;
        int n2 = current < this.m_firstFree ? this.elementAt(current) : -1;
        this.m_next = saved;
        return n2;
    }

    public boolean getShouldCacheNodes() {
        return this.m_cacheNodes;
    }

    public void setShouldCacheNodes(boolean b2) {
        if (!this.isFresh()) {
            throw new RuntimeException("Can not call setShouldCacheNodes after nextNode has been called!");
        }
        this.m_cacheNodes = b2;
        this.m_mutable = true;
    }

    public boolean isMutable() {
        return this.m_mutable;
    }

    public int getLast() {
        return this.m_last;
    }

    public void setLast(int last) {
        this.m_last = last;
    }

    public boolean isDocOrdered() {
        return true;
    }

    public int getAxis() {
        return -1;
    }
}

