/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import java.util.Vector;
import org.apache.xml.utils.IntVector;

public class DTMStringPool {
    Vector m_intToString;
    static final int HASHPRIME = 101;
    int[] m_hashStart = new int[101];
    IntVector m_hashChain;
    public static final int NULL = -1;

    public DTMStringPool() {
        this.m_intToString = new Vector();
        this.m_hashChain = new IntVector(512);
        this.removeAllElements();
        this.stringToIndex("");
    }

    public void removeAllElements() {
        this.m_intToString.removeAllElements();
        int i2 = 0;
        while (i2 < 101) {
            this.m_hashStart[i2] = -1;
            ++i2;
        }
        this.m_hashChain.removeAllElements();
    }

    public String indexToString(int i2) throws ArrayIndexOutOfBoundsException {
        if (i2 == -1) {
            return null;
        }
        return (String)this.m_intToString.elementAt(i2);
    }

    public int stringToIndex(String s2) {
        int hashlast;
        if (s2 == null) {
            return -1;
        }
        int hashslot = s2.hashCode() % 101;
        if (hashslot < 0) {
            hashslot = -hashslot;
        }
        int hashcandidate = hashlast = this.m_hashStart[hashslot];
        while (hashcandidate != -1) {
            if (this.m_intToString.elementAt(hashcandidate).equals(s2)) {
                return hashcandidate;
            }
            hashlast = hashcandidate;
            hashcandidate = this.m_hashChain.elementAt(hashcandidate);
        }
        int newIndex = this.m_intToString.size();
        this.m_intToString.addElement(s2);
        this.m_hashChain.addElement(-1);
        if (hashlast == -1) {
            this.m_hashStart[hashslot] = newIndex;
        } else {
            this.m_hashChain.setElementAt(newIndex, hashlast);
        }
        return newIndex;
    }

    public static void main(String[] args) {
        String[] word = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen", "Twenty", "Twenty-One", "Twenty-Two", "Twenty-Three", "Twenty-Four", "Twenty-Five", "Twenty-Six", "Twenty-Seven", "Twenty-Eight", "Twenty-Nine", "Thirty", "Thirty-One", "Thirty-Two", "Thirty-Three", "Thirty-Four", "Thirty-Five", "Thirty-Six", "Thirty-Seven", "Thirty-Eight", "Thirty-Nine"};
        DTMStringPool pool = new DTMStringPool();
        System.out.println("If no complaints are printed below, we passed initial test.");
        int pass = 0;
        while (pass <= 1) {
            int j2;
            int i2 = 0;
            while (i2 < word.length) {
                j2 = pool.stringToIndex(word[i2]);
                if (j2 != i2) {
                    System.out.println("\tMismatch populating pool: assigned " + j2 + " for create " + i2);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < word.length) {
                j2 = pool.stringToIndex(word[i2]);
                if (j2 != i2) {
                    System.out.println("\tMismatch in stringToIndex: returned " + j2 + " for lookup " + i2);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < word.length) {
                String w2 = pool.indexToString(i2);
                if (!word[i2].equals(w2)) {
                    System.out.println("\tMismatch in indexToString: returned" + w2 + " for lookup " + i2);
                }
                ++i2;
            }
            pool.removeAllElements();
            System.out.println("\nPass " + pass + " complete\n");
            ++pass;
        }
    }
}

