/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.dtm.ref.IncrementalSAXSource_Filter;
import org.apache.xml.dtm.ref.IncrementalSAXSource_Xerces;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTMdefaultNamespaceDeclarationNode;
import org.apache.xml.dtm.ref.sax2dtm.SAX2DTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SuballocatedIntVector;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DTMManagerDefault
extends DTMManager {
    protected DTM[] m_dtms = new DTM[256];
    protected int[] m_dtm_offsets = new int[256];
    private ExpandedNameTable m_expandedNameTable = new ExpandedNameTable();
    private static final boolean DUMPTREE = false;
    private static final boolean DEBUG = false;

    public void addDTM(DTM dtm, int id) {
        this.addDTM(dtm, id, 0);
    }

    public void addDTM(DTM dtm, int id, int offset) {
        if (id >= 65536) {
            throw new DTMException(XSLMessages.createMessage(170, null));
        }
        int oldlen = this.m_dtms.length;
        if (oldlen <= id) {
            int newlen = Math.min(id + 256, 65536);
            DTM[] new_m_dtms = new DTM[newlen];
            System.arraycopy(this.m_dtms, 0, new_m_dtms, 0, oldlen);
            this.m_dtms = new_m_dtms;
            int[] new_m_dtm_offsets = new int[newlen];
            System.arraycopy(this.m_dtm_offsets, 0, new_m_dtm_offsets, 0, oldlen);
            this.m_dtm_offsets = new_m_dtm_offsets;
        }
        this.m_dtms[id] = dtm;
        this.m_dtm_offsets[id] = offset;
        dtm.documentRegistration();
    }

    public int getFirstFreeDTMID() {
        int n2 = this.m_dtms.length;
        int i2 = 1;
        while (i2 < n2) {
            if (null == this.m_dtms[i2]) {
                return i2;
            }
            ++i2;
        }
        return n2;
    }

    public DTM getDTM(Source source, boolean unique, DTMWSFilter whiteSpaceFilter, boolean incremental, boolean doIndexing) {
        boolean isStreamSource;
        XMLStringFactory xstringFactory = this.m_xsf;
        int dtmPos = this.getFirstFreeDTMID();
        int documentID = dtmPos << 16;
        if (null != source && source instanceof DOMSource) {
            DOM2DTM dtm = new DOM2DTM((DTMManager)this, (DOMSource)source, documentID, whiteSpaceFilter, xstringFactory, doIndexing);
            this.addDTM(dtm, dtmPos, 0);
            return dtm;
        }
        boolean isSAXSource = null != source ? source instanceof SAXSource : true;
        boolean bl = isStreamSource = null != source ? source instanceof StreamSource : false;
        if (isSAXSource || isStreamSource) {
            boolean haveXercesParser;
            XMLReader reader;
            InputSource xmlSource;
            if (null == source) {
                xmlSource = null;
                reader = null;
            } else {
                reader = this.getXMLReader(source);
                xmlSource = SAXSource.sourceToInputSource(source);
                String urlOfSource = xmlSource.getSystemId();
                if (null != urlOfSource) {
                    try {
                        urlOfSource = SystemIDResolver.getAbsoluteURI(urlOfSource);
                    }
                    catch (Exception e2) {
                        System.err.println("Can not absolutize URL: " + urlOfSource);
                    }
                    xmlSource.setSystemId(urlOfSource);
                }
            }
            SAX2DTM dtm = new SAX2DTM(this, source, documentID, whiteSpaceFilter, xstringFactory, doIndexing);
            this.addDTM(dtm, dtmPos, 0);
            boolean bl2 = haveXercesParser = null != reader && reader.getClass().getName().equals("org.apache.xerces.parsers.SAXParser");
            if (haveXercesParser) {
                incremental = true;
            }
            if (DTMManager.m_incremental && incremental) {
                IncrementalSAXSource coParser = null;
                if (haveXercesParser) {
                    try {
                        coParser = IncrementalSAXSource_Xerces.createIncrementalSAXSource();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        coParser = null;
                    }
                }
                if (coParser == null) {
                    if (null == reader) {
                        coParser = new IncrementalSAXSource_Filter();
                    } else {
                        IncrementalSAXSource_Filter filter = new IncrementalSAXSource_Filter();
                        filter.setXMLReader(reader);
                        coParser = filter;
                    }
                }
                dtm.setIncrementalSAXSource(coParser);
                if (null == xmlSource) {
                    return dtm;
                }
                if (null == reader.getErrorHandler()) {
                    reader.setDTDHandler(dtm);
                }
                reader.setErrorHandler(dtm);
                try {
                    coParser.startParse(xmlSource);
                }
                catch (RuntimeException re) {
                    dtm.clearCoRoutine();
                    throw re;
                }
                catch (Exception e3) {
                    dtm.clearCoRoutine();
                    throw new WrappedRuntimeException(e3);
                }
            }
            if (null == reader) {
                return dtm;
            }
            reader.setContentHandler(dtm);
            reader.setDTDHandler(dtm);
            if (null == reader.getErrorHandler()) {
                reader.setDTDHandler(dtm);
            }
            try {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", dtm);
            }
            catch (SAXNotRecognizedException e4) {
            }
            catch (SAXNotSupportedException e5) {
                // empty catch block
            }
            try {
                reader.parse(xmlSource);
            }
            catch (RuntimeException re) {
                dtm.clearCoRoutine();
                throw re;
            }
            catch (Exception e6) {
                dtm.clearCoRoutine();
                throw new WrappedRuntimeException(e6);
            }
            return dtm;
        }
        throw new DTMException(XSLMessages.createMessage(171, new Object[]{source}));
    }

    public int getDTMHandleFromNode(Node node) {
        int handle;
        if (null == node) {
            throw new IllegalArgumentException(XSLMessages.createMessage(172, null));
        }
        if (node instanceof DTMNodeProxy) {
            return ((DTMNodeProxy)node).getDTMNodeNumber();
        }
        int max = this.m_dtms.length;
        int i2 = 0;
        while (i2 < max) {
            int handle2;
            DTM thisDTM = this.m_dtms[i2];
            if (null != thisDTM && thisDTM instanceof DOM2DTM && (handle2 = ((DOM2DTM)thisDTM).getHandleOfNode(node)) != -1) {
                return handle2;
            }
            ++i2;
        }
        Node root = node;
        Node p2 = root.getNodeType() == 2 ? ((Attr)root).getOwnerElement() : root.getParentNode();
        while (p2 != null) {
            root = p2;
            p2 = p2.getParentNode();
        }
        DOM2DTM dtm = (DOM2DTM)this.getDTM(new DOMSource(root), false, null, true, true);
        if (node instanceof DOM2DTMdefaultNamespaceDeclarationNode) {
            handle = dtm.getHandleOfNode(((Attr)node).getOwnerElement());
            handle = dtm.getAttributeNode(handle, node.getNamespaceURI(), node.getLocalName());
        } else {
            handle = dtm.getHandleOfNode(node);
        }
        if (-1 == handle) {
            throw new RuntimeException(XSLMessages.createMessage(173, null));
        }
        return handle;
    }

    public XMLReader getXMLReader(Source inputSource) {
        try {
            boolean isUserReader;
            XMLReader reader = inputSource instanceof SAXSource ? ((SAXSource)inputSource).getXMLReader() : null;
            boolean bl = isUserReader = reader != null;
            if (null == reader) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser jaxpParser = factory.newSAXParser();
                    reader = jaxpParser.getXMLReader();
                }
                catch (ParserConfigurationException ex) {
                    throw new SAXException(ex);
                }
                catch (FactoryConfigurationError ex1) {
                    throw new SAXException(ex1.toString());
                }
                catch (NoSuchMethodError ex2) {
                }
                catch (AbstractMethodError ame) {
                    // empty catch block
                }
                if (null == reader) {
                    reader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException se) {
                // empty catch block
            }
            return reader;
        }
        catch (SAXException se) {
            throw new DTMException(se.getMessage(), se);
        }
    }

    public DTM getDTM(int nodeHandle) {
        try {
            return this.m_dtms[nodeHandle >>> 16];
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            if (nodeHandle == -1) {
                return null;
            }
            throw e2;
        }
    }

    public int getDTMIdentity(DTM dtm) {
        if (dtm instanceof DTMDefaultBase) {
            DTMDefaultBase dtmdb = (DTMDefaultBase)dtm;
            if (dtmdb.getManager() == this) {
                return dtmdb.getDTMIDs().elementAt(0);
            }
            return -1;
        }
        int n2 = this.m_dtms.length;
        int i2 = 0;
        while (i2 < n2) {
            DTM tdtm = this.m_dtms[i2];
            if (tdtm == dtm && this.m_dtm_offsets[i2] == 0) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public boolean release(DTM dtm, boolean shouldHardDelete) {
        if (dtm instanceof SAX2DTM) {
            ((SAX2DTM)dtm).clearCoRoutine();
        }
        if (dtm instanceof DTMDefaultBase) {
            SuballocatedIntVector ids = ((DTMDefaultBase)dtm).getDTMIDs();
            int i2 = ids.size() - 1;
            while (i2 >= 0) {
                this.m_dtms[ids.elementAt((int)i2) >> 16] = null;
                --i2;
            }
        } else {
            int i3 = this.getDTMIdentity(dtm);
            if (i3 >= 0) {
                this.m_dtms[i3] = null;
            }
        }
        dtm.documentRelease();
        return true;
    }

    public DTM createDocumentFragment() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db2 = dbf.newDocumentBuilder();
            Document doc = db2.newDocument();
            DocumentFragment df = doc.createDocumentFragment();
            return this.getDTM(new DOMSource(df), true, null, false, false);
        }
        catch (Exception e2) {
            throw new DTMException(e2);
        }
    }

    public DTMIterator createDTMIterator(int whatToShow, DTMFilter filter, boolean entityReferenceExpansion) {
        return null;
    }

    public DTMIterator createDTMIterator(String xpathString, PrefixResolver presolver) {
        return null;
    }

    public DTMIterator createDTMIterator(int node) {
        return null;
    }

    public DTMIterator createDTMIterator(Object xpathCompiler, int pos) {
        return null;
    }

    public ExpandedNameTable getExpandedNameTable(DTM dtm) {
        return this.m_expandedNameTable;
    }
}

