/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.transform.SourceLocator;
import org.apache.xalan.res.XSLMessages;

public class DTMException
extends RuntimeException {
    SourceLocator locator;
    Throwable containedException;

    public SourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(SourceLocator location) {
        this.locator = location;
    }

    public Throwable getException() {
        return this.containedException;
    }

    public Throwable getCause() {
        return this.containedException == this ? null : this.containedException;
    }

    public synchronized Throwable initCause(Throwable cause) {
        if (this.containedException == null && cause != null) {
            throw new IllegalStateException(XSLMessages.createMessage(115, null));
        }
        if (cause == this) {
            throw new IllegalArgumentException(XSLMessages.createMessage(194, null));
        }
        this.containedException = cause;
        return this;
    }

    public DTMException(String message) {
        super(message);
        this.containedException = null;
        this.locator = null;
    }

    public DTMException(Throwable e2) {
        super(e2.getMessage());
        this.containedException = e2;
        this.locator = null;
    }

    public DTMException(String message, Throwable e2) {
        super(message == null || message.length() == 0 ? e2.getMessage() : message);
        this.containedException = e2;
        this.locator = null;
    }

    public DTMException(String message, SourceLocator locator) {
        super(message);
        this.containedException = null;
        this.locator = locator;
    }

    public DTMException(String message, SourceLocator locator, Throwable e2) {
        super(message);
        this.containedException = e2;
        this.locator = locator;
    }

    public String getMessageAndLocation() {
        StringBuffer sbuffer = new StringBuffer();
        String message = super.getMessage();
        if (null != message) {
            sbuffer.append(message);
        }
        if (null != this.locator) {
            String systemID = this.locator.getSystemId();
            int line = this.locator.getLineNumber();
            int column = this.locator.getColumnNumber();
            if (null != systemID) {
                sbuffer.append("; SystemID: ");
                sbuffer.append(systemID);
            }
            if (0 != line) {
                sbuffer.append("; Line#: ");
                sbuffer.append(line);
            }
            if (0 != column) {
                sbuffer.append("; Column#: ");
                sbuffer.append(column);
            }
        }
        return sbuffer.toString();
    }

    public String getLocationAsString() {
        if (null != this.locator) {
            StringBuffer sbuffer = new StringBuffer();
            String systemID = this.locator.getSystemId();
            int line = this.locator.getLineNumber();
            int column = this.locator.getColumnNumber();
            if (null != systemID) {
                sbuffer.append("; SystemID: ");
                sbuffer.append(systemID);
            }
            if (0 != line) {
                sbuffer.append("; Line#: ");
                sbuffer.append(line);
            }
            if (0 != column) {
                sbuffer.append("; Column#: ");
                sbuffer.append(column);
            }
            return sbuffer.toString();
        }
        return null;
    }

    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err, true));
    }

    public void printStackTrace(PrintStream s2) {
        this.printStackTrace(new PrintWriter(s2));
    }

    public void printStackTrace(PrintWriter s2) {
        if (s2 == null) {
            s2 = new PrintWriter(System.err, true);
        }
        try {
            String locInfo = this.getLocationAsString();
            if (null != locInfo) {
                s2.println(locInfo);
            }
            super.printStackTrace(s2);
        }
        catch (Throwable e2) {
            // empty catch block
        }
        Throwable exception = this.getException();
        int i2 = 0;
        while (i2 < 10 && null != exception) {
            s2.println("---------");
            try {
                String locInfo;
                if (exception instanceof DTMException && null != (locInfo = ((DTMException)exception).getLocationAsString())) {
                    s2.println(locInfo);
                }
                exception.printStackTrace(s2);
            }
            catch (Throwable e3) {
                s2.println("Could not print stack trace...");
            }
            try {
                Method meth = exception.getClass().getMethod("getException", null);
                if (null != meth) {
                    Throwable prev = exception;
                    if (prev == (exception = (Throwable)meth.invoke((Object)exception, null))) {
                        break;
                    }
                } else {
                    exception = null;
                }
            }
            catch (InvocationTargetException ite) {
                exception = null;
            }
            catch (IllegalAccessException iae) {
                exception = null;
            }
            catch (NoSuchMethodException nsme) {
                exception = null;
            }
            ++i2;
        }
    }
}

