/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Vector;
import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.SchemaDVFactoryImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.psvi.XSObject;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDSimpleTypeTraverser
extends XSDAbstractTraverser {
    private final SchemaDVFactory schemaFactory = SchemaDVFactory.getInstance();
    private boolean fIsBuiltIn = false;

    XSDSimpleTypeTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        super(xSDHandler, xSAttributeChecker);
        if (this.schemaFactory instanceof SchemaDVFactoryImpl) {
            ((SchemaDVFactoryImpl)this.schemaFactory).setDeclPool(xSDHandler.fDeclPool);
        }
    }

    XSSimpleType traverseGlobal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, true, xSDocumentInfo);
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        XSSimpleType xSSimpleType = this.traverseSimpleTypeDecl(element, objectArray, xSDocumentInfo, schemaGrammar);
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        if (string == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, SchemaSymbols.ATT_NAME}, element);
            xSSimpleType = null;
        }
        if (xSSimpleType != null) {
            schemaGrammar.addGlobalTypeDecl(xSSimpleType);
        }
        return xSSimpleType;
    }

    XSSimpleType traverseLocal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        XSSimpleType xSSimpleType = this.traverseSimpleTypeDecl(element, objectArray, xSDocumentInfo, schemaGrammar);
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSSimpleType;
    }

    private XSSimpleType traverseSimpleTypeDecl(Element element, Object[] objectArray, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        XSObjectList xSObjectList;
        int n2;
        int n3;
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        XInt xInt = (XInt)objectArray[XSAttributeChecker.ATTIDX_FINAL];
        int n4 = xInt == null ? xSDocumentInfo.fFinalDefault : xInt.intValue();
        Element element2 = DOMUtil.getFirstChildElement(element);
        if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        if (element2 == null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, "(annotation?, (restriction | list | union))"}, element);
            return this.errorType(string, xSDocumentInfo.fTargetNamespace, (short)2);
        }
        String string2 = DOMUtil.getLocalName(element2);
        short s2 = 2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string2.equals(SchemaSymbols.ELT_RESTRICTION)) {
            s2 = 2;
            bl = true;
        } else if (string2.equals(SchemaSymbols.ELT_LIST)) {
            s2 = 16;
            bl2 = true;
        } else if (string2.equals(SchemaSymbols.ELT_UNION)) {
            s2 = 8;
            bl3 = true;
        } else {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, "(annotation?, (restriction | list | union))"}, element);
            return this.errorType(string, xSDocumentInfo.fTargetNamespace, (short)2);
        }
        Element element3 = DOMUtil.getNextSiblingElement(element2);
        if (element3 != null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, "(annotation?, (restriction | list | union))"}, element3);
        }
        Object[] objectArray2 = this.fAttrChecker.checkAttributes(element2, false, xSDocumentInfo);
        QName qName = (QName)objectArray2[bl ? XSAttributeChecker.ATTIDX_BASE : XSAttributeChecker.ATTIDX_ITEMTYPE];
        Vector vector = (Vector)objectArray2[XSAttributeChecker.ATTIDX_MEMBERTYPES];
        Element element4 = DOMUtil.getFirstChildElement(element2);
        if (element4 != null && DOMUtil.getLocalName(element4).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(element4, objectArray2, false, xSDocumentInfo);
            element4 = DOMUtil.getNextSiblingElement(element4);
        }
        XSSimpleType xSSimpleType = null;
        if ((bl || bl2) && qName != null && (xSSimpleType = this.findDTValidator(element2, string, qName, s2, xSDocumentInfo)) == null && this.fIsBuiltIn) {
            this.fIsBuiltIn = false;
            return null;
        }
        Vector<XSObject> vector2 = null;
        XSSimpleType xSSimpleType2 = null;
        if (bl3 && vector != null && vector.size() > 0) {
            n3 = vector.size();
            vector2 = new Vector<XSObject>(n3, 2);
            n2 = 0;
            while (n2 < n3) {
                xSSimpleType2 = this.findDTValidator(element2, string, (QName)vector.elementAt(n2), (short)8, xSDocumentInfo);
                if (xSSimpleType2 != null) {
                    if (xSSimpleType2.getVariety() == 3) {
                        xSObjectList = xSSimpleType2.getMemberTypes();
                        int n5 = 0;
                        while (n5 < xSObjectList.getLength()) {
                            vector2.addElement(xSObjectList.item(n5));
                            ++n5;
                        }
                    } else {
                        vector2.addElement(xSSimpleType2);
                    }
                }
                ++n2;
            }
        }
        n3 = 0;
        if (element4 != null && DOMUtil.getLocalName(element4).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
            if (bl || bl2) {
                if (qName != null) {
                    this.reportSchemaError(bl2 ? "src-simple-type.3" : "src-simple-type.2", null, element4);
                } else {
                    xSSimpleType = this.traverseLocal(element4, xSDocumentInfo, schemaGrammar);
                }
                element4 = DOMUtil.getNextSiblingElement(element4);
            } else if (bl3) {
                if (vector2 == null) {
                    vector2 = new Vector(2, 2);
                }
                do {
                    if ((xSSimpleType2 = this.traverseLocal(element4, xSDocumentInfo, schemaGrammar)) == null) continue;
                    if (xSSimpleType2.getVariety() == 3) {
                        xSObjectList = xSSimpleType2.getMemberTypes();
                        n2 = 0;
                        while (n2 < xSObjectList.getLength()) {
                            vector2.addElement(xSObjectList.item(n2));
                            ++n2;
                        }
                    } else {
                        vector2.addElement(xSSimpleType2);
                    }
                } while ((element4 = DOMUtil.getNextSiblingElement(element4)) != null && DOMUtil.getLocalName(element4).equals(SchemaSymbols.ELT_SIMPLETYPE));
            }
        } else if ((bl || bl2) && qName == null) {
            this.reportSchemaError("src-simple-type.2", null, element2);
            n3 = 1;
            xSSimpleType = SchemaGrammar.fAnySimpleType;
        } else if (bl3 && (vector == null || vector.size() == 0)) {
            this.reportSchemaError("src-union-memberTypes-or-simpleTypes", null, element2);
            vector2 = new Vector(1);
            vector2.addElement(SchemaGrammar.fAnySimpleType);
        }
        if ((bl || bl2) && xSSimpleType == null) {
            xSSimpleType = SchemaGrammar.fAnySimpleType;
        }
        if (bl3 && (vector2 == null || vector2.size() == 0)) {
            vector2 = new Vector(1);
            vector2.addElement(SchemaGrammar.fAnySimpleType);
        }
        if (bl2 && this.isListDatatype(xSSimpleType)) {
            this.reportSchemaError("cos-list-of-atomic", new Object[]{string}, element2);
        }
        XSSimpleType xSSimpleType3 = null;
        if (bl) {
            xSSimpleType3 = this.schemaFactory.createTypeRestriction(string, xSDocumentInfo.fTargetNamespace, (short)n4, xSSimpleType);
        } else if (bl2) {
            xSSimpleType3 = this.schemaFactory.createTypeList(string, xSDocumentInfo.fTargetNamespace, (short)n4, xSSimpleType);
        } else if (bl3) {
            XSSimpleType[] xSSimpleTypeArray = new XSSimpleType[vector2.size()];
            int n6 = 0;
            while (n6 < vector2.size()) {
                xSSimpleTypeArray[n6] = (XSSimpleType)vector2.elementAt(n6);
                ++n6;
            }
            xSSimpleType3 = this.schemaFactory.createTypeUnion(string, xSDocumentInfo.fTargetNamespace, (short)n4, xSSimpleTypeArray);
        }
        if (bl && element4 != null) {
            XSDAbstractTraverser.FacetInfo facetInfo = this.traverseFacets(element4, xSSimpleType, xSDocumentInfo);
            element4 = facetInfo.nodeAfterFacets;
            if (n3 == 0) {
                try {
                    this.fValidationState.setNamespaceSupport(xSDocumentInfo.fNamespaceSupport);
                    xSSimpleType3.applyFacets(facetInfo.facetdata, facetInfo.fPresentFacets, facetInfo.fFixedFacets, this.fValidationState);
                }
                catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
                    this.reportSchemaError(invalidDatatypeFacetException.getKey(), invalidDatatypeFacetException.getArgs(), element2);
                }
            }
        }
        if (element4 != null) {
            if (bl) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_RESTRICTION, "(annotation?, (simpleType?, (minExclusive | minInclusive | maxExclusive | maxInclusive | totalDigits | fractionDigits | length | minLength | maxLength | enumeration | whiteSpace | pattern)*))"}, element4);
            } else if (bl2) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_LIST, "(annotation?, (simpleType?))"}, element4);
            } else if (bl3) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_LIST, "(annotation?, (simpleType*))"}, element4);
            }
        }
        this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
        return xSSimpleType3;
    }

    private XSSimpleType findDTValidator(Element element, String string, QName qName, short s2, XSDocumentInfo xSDocumentInfo) {
        if (qName == null) {
            return null;
        }
        XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 7, qName, element);
        if (xSTypeDefinition != null) {
            if (xSTypeDefinition.getTypeCategory() != 14 || xSTypeDefinition == SchemaGrammar.fAnySimpleType && s2 == 2) {
                if (xSTypeDefinition == SchemaGrammar.fAnySimpleType && this.checkBuiltIn(string, xSDocumentInfo.fTargetNamespace)) {
                    return null;
                }
                this.reportSchemaError("cos-st-restricts.1.1", new Object[]{qName.rawname}, element);
                return SchemaGrammar.fAnySimpleType;
            }
            if ((xSTypeDefinition.getFinal() & s2) != 0) {
                if (s2 == 2) {
                    this.reportSchemaError("st-props-correct.3", new Object[]{qName.rawname}, element);
                } else if (s2 == 16) {
                    this.reportSchemaError("cos-st-restricts.2.3.1.1", new Object[]{qName.rawname}, element);
                } else if (s2 == 8) {
                    this.reportSchemaError("cos-st-restricts.3.3.1.1", new Object[]{qName.rawname}, element);
                }
            }
        }
        return (XSSimpleType)xSTypeDefinition;
    }

    private final boolean checkBuiltIn(String string, String string2) {
        if (string2 != SchemaSymbols.URI_SCHEMAFORSCHEMA) {
            return false;
        }
        if (SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl(string) != null) {
            this.fIsBuiltIn = true;
        }
        return this.fIsBuiltIn;
    }

    private boolean isListDatatype(XSSimpleType xSSimpleType) {
        if (xSSimpleType.getVariety() == 2) {
            return true;
        }
        if (xSSimpleType.getVariety() == 3) {
            XSObjectList xSObjectList = xSSimpleType.getMemberTypes();
            int n2 = 0;
            while (n2 < xSObjectList.getLength()) {
                if (((XSSimpleType)xSObjectList.item(n2)).getVariety() == 2) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private XSSimpleType errorType(String string, String string2, short s2) {
        switch (s2) {
            case 2: {
                return this.schemaFactory.createTypeRestriction(string, string2, (short)0, SchemaGrammar.fAnySimpleType);
            }
            case 16: {
                return this.schemaFactory.createTypeList(string, string2, (short)0, SchemaGrammar.fAnySimpleType);
            }
            case 8: {
                return this.schemaFactory.createTypeUnion(string, string2, (short)0, new XSSimpleType[]{SchemaGrammar.fAnySimpleType});
            }
        }
        return null;
    }
}

