/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.w3c.dom.Element;

abstract class XSDAbstractParticleTraverser
extends XSDAbstractTraverser {
    ParticleArray fPArray = new ParticleArray();

    XSDAbstractParticleTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        super(xSDHandler, xSAttributeChecker);
    }

    XSParticleDecl traverseAll(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar, int n2, XSComplexTypeDecl xSComplexTypeDecl) {
        Object[] objectArray;
        XSParticleDecl xSParticleDecl;
        Object[] objectArray2 = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        Element element2 = DOMUtil.getFirstChildElement(element);
        if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(element2, objectArray2, false, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        String string = null;
        this.fPArray.pushContext();
        while (element2 != null) {
            xSParticleDecl = null;
            string = DOMUtil.getLocalName(element2);
            if (string.equals(SchemaSymbols.ELT_ELEMENT)) {
                xSParticleDecl = this.fSchemaHandler.fElementTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar, 1, xSComplexTypeDecl);
            } else {
                objectArray = new Object[]{"all", "(annotation?, element*)"};
                this.reportSchemaError("s4s-elt-must-match", objectArray, element2);
            }
            if (xSParticleDecl != null) {
                this.fPArray.addParticle(xSParticleDecl);
            }
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        xSParticleDecl = null;
        if (this.fPArray.getParticleCount() != 0) {
            objectArray = (Object[])objectArray2[XSAttributeChecker.ATTIDX_MINOCCURS];
            XInt xInt = (XInt)objectArray2[XSAttributeChecker.ATTIDX_MAXOCCURS];
            Long l2 = (Long)objectArray2[XSAttributeChecker.ATTIDX_FROMDEFAULT];
            XSModelGroupImpl xSModelGroupImpl = new XSModelGroupImpl();
            xSModelGroupImpl.fCompositor = (short)103;
            xSModelGroupImpl.fParticleCount = this.fPArray.getParticleCount();
            xSModelGroupImpl.fParticles = this.fPArray.popContext();
            xSParticleDecl = new XSParticleDecl();
            xSParticleDecl.fType = (short)3;
            xSParticleDecl.fMinOccurs = objectArray.intValue();
            xSParticleDecl.fMaxOccurs = xInt.intValue();
            xSParticleDecl.fValue = xSModelGroupImpl;
            xSParticleDecl = this.checkOccurrences(xSParticleDecl, SchemaSymbols.ELT_ALL, (Element)element.getParentNode(), n2, l2);
        } else {
            this.fPArray.discardContext();
        }
        this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
        return xSParticleDecl;
    }

    XSParticleDecl traverseSequence(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar, int n2, XSComplexTypeDecl xSComplexTypeDecl) {
        return this.traverseSeqChoice(element, xSDocumentInfo, schemaGrammar, n2, false, xSComplexTypeDecl);
    }

    XSParticleDecl traverseChoice(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar, int n2, XSComplexTypeDecl xSComplexTypeDecl) {
        return this.traverseSeqChoice(element, xSDocumentInfo, schemaGrammar, n2, true, xSComplexTypeDecl);
    }

    private XSParticleDecl traverseSeqChoice(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar, int n2, boolean bl, XSComplexTypeDecl xSComplexTypeDecl) {
        Object[] objectArray;
        XSParticleDecl xSParticleDecl;
        Object[] objectArray2 = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        Element element2 = DOMUtil.getFirstChildElement(element);
        if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(element2, objectArray2, false, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        boolean bl2 = false;
        String string = null;
        this.fPArray.pushContext();
        while (element2 != null) {
            xSParticleDecl = null;
            string = DOMUtil.getLocalName(element2);
            if (string.equals(SchemaSymbols.ELT_ELEMENT)) {
                xSParticleDecl = this.fSchemaHandler.fElementTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar, 0, xSComplexTypeDecl);
            } else if (string.equals(SchemaSymbols.ELT_GROUP)) {
                xSParticleDecl = this.fSchemaHandler.fGroupTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar);
                if (this.hasAllContent(xSParticleDecl)) {
                    xSParticleDecl = null;
                    this.reportSchemaError("cos-all-limited.1.2", null, element2);
                }
            } else if (string.equals(SchemaSymbols.ELT_CHOICE)) {
                xSParticleDecl = this.traverseChoice(element2, xSDocumentInfo, schemaGrammar, 0, xSComplexTypeDecl);
            } else if (string.equals(SchemaSymbols.ELT_SEQUENCE)) {
                xSParticleDecl = this.traverseSequence(element2, xSDocumentInfo, schemaGrammar, 0, xSComplexTypeDecl);
            } else if (string.equals(SchemaSymbols.ELT_ANY)) {
                xSParticleDecl = this.fSchemaHandler.fWildCardTraverser.traverseAny(element2, xSDocumentInfo, schemaGrammar);
            } else {
                objectArray = bl ? new Object[]{"choice", "(annotation?, (element | group | choice | sequence | any)*)"} : new Object[]{"sequence", "(annotation?, (element | group | choice | sequence | any)*)"};
                this.reportSchemaError("s4s-elt-must-match", objectArray, element2);
            }
            if (xSParticleDecl != null) {
                this.fPArray.addParticle(xSParticleDecl);
            }
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        xSParticleDecl = null;
        objectArray = (Object[])objectArray2[XSAttributeChecker.ATTIDX_MINOCCURS];
        XInt xInt = (XInt)objectArray2[XSAttributeChecker.ATTIDX_MAXOCCURS];
        Long l2 = (Long)objectArray2[XSAttributeChecker.ATTIDX_FROMDEFAULT];
        XSModelGroupImpl xSModelGroupImpl = new XSModelGroupImpl();
        xSModelGroupImpl.fCompositor = (short)(bl ? 101 : 102);
        xSModelGroupImpl.fParticleCount = this.fPArray.getParticleCount();
        xSModelGroupImpl.fParticles = this.fPArray.popContext();
        xSParticleDecl = new XSParticleDecl();
        xSParticleDecl.fType = (short)3;
        xSParticleDecl.fMinOccurs = objectArray.intValue();
        xSParticleDecl.fMaxOccurs = xInt.intValue();
        xSParticleDecl.fValue = xSModelGroupImpl;
        xSParticleDecl = this.checkOccurrences(xSParticleDecl, bl ? SchemaSymbols.ELT_CHOICE : SchemaSymbols.ELT_SEQUENCE, (Element)element.getParentNode(), n2, l2);
        this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
        return xSParticleDecl;
    }

    protected boolean hasAllContent(XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl != null && xSParticleDecl.fType == 3) {
            return ((XSModelGroupImpl)xSParticleDecl.fValue).fCompositor == 103;
        }
        return false;
    }

    protected static class ParticleArray {
        XSParticleDecl[] fParticles = new XSParticleDecl[10];
        int[] fPos = new int[5];
        int fContextCount = 0;

        protected ParticleArray() {
        }

        void pushContext() {
            ++this.fContextCount;
            if (this.fContextCount == this.fPos.length) {
                int n2 = this.fContextCount * 2;
                int[] nArray = new int[n2];
                System.arraycopy(this.fPos, 0, nArray, 0, this.fContextCount);
                this.fPos = nArray;
            }
            this.fPos[this.fContextCount] = this.fPos[this.fContextCount - 1];
        }

        int getParticleCount() {
            return this.fPos[this.fContextCount] - this.fPos[this.fContextCount - 1];
        }

        void addParticle(XSParticleDecl xSParticleDecl) {
            if (this.fPos[this.fContextCount] == this.fParticles.length) {
                int n2 = this.fPos[this.fContextCount] * 2;
                XSParticleDecl[] xSParticleDeclArray = new XSParticleDecl[n2];
                System.arraycopy(this.fParticles, 0, xSParticleDeclArray, 0, this.fPos[this.fContextCount]);
                this.fParticles = xSParticleDeclArray;
            }
            int n3 = this.fContextCount;
            int n4 = this.fPos[n3];
            this.fPos[n3] = n4 + 1;
            this.fParticles[n4] = xSParticleDecl;
        }

        XSParticleDecl[] popContext() {
            int n2 = this.fPos[this.fContextCount] - this.fPos[this.fContextCount - 1];
            XSParticleDecl[] xSParticleDeclArray = null;
            if (n2 != 0) {
                xSParticleDeclArray = new XSParticleDecl[n2];
                System.arraycopy(this.fParticles, this.fPos[this.fContextCount - 1], xSParticleDeclArray, 0, n2);
                int n3 = this.fPos[this.fContextCount - 1];
                while (n3 < this.fPos[this.fContextCount]) {
                    this.fParticles[n3] = null;
                    ++n3;
                }
            }
            --this.fContextCount;
            return xSParticleDeclArray;
        }

        void discardContext() {
            int n2 = this.fPos[this.fContextCount - 1];
            while (n2 < this.fPos[this.fContextCount]) {
                this.fParticles[n2] = null;
                ++n2;
            }
            --this.fContextCount;
        }
    }
}

