/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.opti;

import org.apache.xerces.impl.xs.opti.AttrImpl;
import org.apache.xerces.impl.xs.opti.DefaultDocument;
import org.apache.xerces.impl.xs.opti.ElementImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaDOM
extends DefaultDocument {
    static final int relationsRowResizeFactor = 15;
    static final int relationsColResizeFactor = 10;
    ElementImpl[][] relations;
    ElementImpl parent;
    int currLoc;
    int nextFreeLoc;
    boolean hidden;

    public SchemaDOM() {
        this.reset();
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations, int n2, int n3) throws XNIException {
        ElementImpl elementImpl = new ElementImpl(n2, n3);
        this.processElement(qName, xMLAttributes, augmentations, elementImpl);
        this.parent = elementImpl;
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations, int n2, int n3) throws XNIException {
        ElementImpl elementImpl = new ElementImpl(n2, n3);
        this.processElement(qName, xMLAttributes, augmentations, elementImpl);
    }

    private void processElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations, ElementImpl elementImpl) throws XNIException {
        elementImpl.prefix = qName.prefix;
        elementImpl.localpart = qName.localpart;
        elementImpl.rawname = qName.rawname;
        elementImpl.uri = qName.uri;
        elementImpl.schemaDOM = this;
        Attr[] attrArray = new Attr[xMLAttributes.getLength()];
        int n2 = 0;
        while (n2 < xMLAttributes.getLength()) {
            attrArray[n2] = new AttrImpl(null, xMLAttributes.getPrefix(n2), xMLAttributes.getLocalName(n2), xMLAttributes.getQName(n2), xMLAttributes.getURI(n2), xMLAttributes.getValue(n2));
            ++n2;
        }
        elementImpl.attrs = attrArray;
        if (this.nextFreeLoc == this.relations.length) {
            this.resizeRelations();
        }
        if (this.relations[this.currLoc][0] != this.parent) {
            this.relations[this.nextFreeLoc][0] = this.parent;
            this.currLoc = this.nextFreeLoc++;
        }
        boolean bl = false;
        int n3 = 1;
        n3 = 1;
        while (n3 < this.relations[this.currLoc].length) {
            if (this.relations[this.currLoc][n3] == null) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (!bl) {
            this.resizeRelations(this.currLoc);
        }
        this.relations[this.currLoc][n3] = elementImpl;
        this.parent.parentRow = this.currLoc;
        elementImpl.row = this.currLoc;
        elementImpl.col = n3;
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        this.currLoc = this.parent.row;
        this.parent = this.relations[this.currLoc][0];
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    private void resizeRelations() {
        ElementImpl[][] elementImplArrayArray = new ElementImpl[this.relations.length + 15][];
        System.arraycopy(this.relations, 0, elementImplArrayArray, 0, this.relations.length);
        int n2 = this.relations.length;
        while (n2 < elementImplArrayArray.length) {
            elementImplArrayArray[n2] = new ElementImpl[10];
            ++n2;
        }
        this.relations = elementImplArrayArray;
    }

    private void resizeRelations(int n2) {
        ElementImpl[] elementImplArray = new ElementImpl[this.relations[n2].length + 10];
        System.arraycopy(this.relations[n2], 0, elementImplArray, 0, this.relations[n2].length);
        this.relations[n2] = elementImplArray;
    }

    public void reset() {
        this.relations = new ElementImpl[15][];
        this.parent = new ElementImpl(0, 0);
        this.parent.rawname = "DOCUMENT_NODE";
        this.currLoc = 0;
        this.nextFreeLoc = 1;
        int n2 = 0;
        while (n2 < 15) {
            this.relations[n2] = new ElementImpl[10];
            ++n2;
        }
        this.relations[this.currLoc][0] = this.parent;
    }

    public void printDOM() {
    }

    public static void traverse(Node node, int n2) {
        Object object;
        SchemaDOM.indent(n2);
        System.out.print("<" + node.getNodeName());
        if (node.hasAttributes()) {
            object = node.getAttributes();
            int n3 = 0;
            while (n3 < object.getLength()) {
                System.out.print("  " + ((Attr)object.item(n3)).getName() + "=\"" + ((Attr)object.item(n3)).getValue() + "\"");
                ++n3;
            }
        }
        if (node.hasChildNodes()) {
            System.out.println(">");
            n2 += 4;
            object = node.getFirstChild();
            while (object != null) {
                SchemaDOM.traverse((Node)object, n2);
                object = object.getNextSibling();
            }
            SchemaDOM.indent(n2 -= 4);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    public static void indent(int n2) {
        int n3 = 0;
        while (n3 < n2) {
            System.out.print(' ');
            ++n3;
        }
    }

    public Element getDocumentElement() {
        return this.relations[0][1];
    }
}

