/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.dom;

import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.impl.xs.dom.ElementNSImpl;

public final class DOMNodePool {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private ElementNSImpl[][] fElements = new ElementNSImpl[4][];
    private int fElementIndex = 0;
    private TextImpl[][] fTextNode = new TextImpl[4][];
    private int fTextNodeIndex = 0;
    private AttrNSImpl[][] fAttrNode = new AttrNSImpl[4][];
    private int fAttrNodeIndex = 0;

    public final ElementNSImpl getElementNode() {
        int n2 = this.fElementIndex >> 8;
        int n3 = this.fElementIndex & 0xFF;
        this.ensureElementsCapacity(n2);
        if (this.fElements[n2][n3] == null) {
            this.fElements[n2][n3] = new ElementNSImpl();
        }
        ++this.fElementIndex;
        return this.fElements[n2][n3];
    }

    private void ensureElementsCapacity(int n2) {
        if (this.fElements.length <= n2) {
            this.fElements = DOMNodePool.resize(this.fElements, this.fElements.length * 2);
        } else if (this.fElements[n2] != null) {
            return;
        }
        this.fElements[n2] = new ElementNSImpl[256];
    }

    private static ElementNSImpl[][] resize(ElementNSImpl[][] elementNSImplArray, int n2) {
        ElementNSImpl[][] elementNSImplArray2 = new ElementNSImpl[n2][];
        System.arraycopy(elementNSImplArray, 0, elementNSImplArray2, 0, elementNSImplArray.length);
        return elementNSImplArray2;
    }

    public final TextImpl getTextNode() {
        int n2 = this.fTextNodeIndex >> 8;
        int n3 = this.fTextNodeIndex & 0xFF;
        this.ensureTextCapacity(n2);
        if (this.fTextNode[n2][n3] == null) {
            this.fTextNode[n2][n3] = new TextImpl();
        }
        ++this.fTextNodeIndex;
        return this.fTextNode[n2][n3];
    }

    private void ensureTextCapacity(int n2) {
        if (this.fTextNode.length <= n2) {
            this.fTextNode = DOMNodePool.resize(this.fTextNode, this.fTextNode.length * 2);
        } else if (this.fTextNode[n2] != null) {
            return;
        }
        this.fTextNode[n2] = new TextImpl[256];
    }

    private static TextImpl[][] resize(TextImpl[][] textImplArray, int n2) {
        TextImpl[][] textImplArray2 = new TextImpl[n2][];
        System.arraycopy(textImplArray, 0, textImplArray2, 0, textImplArray.length);
        return textImplArray2;
    }

    public final AttrNSImpl getAttrNode() {
        int n2 = this.fAttrNodeIndex >> 8;
        int n3 = this.fAttrNodeIndex & 0xFF;
        this.ensureAttrsCapacity(n2);
        if (this.fAttrNode[n2][n3] == null) {
            this.fAttrNode[n2][n3] = new AttrNSImpl();
        }
        ++this.fAttrNodeIndex;
        return this.fAttrNode[n2][n3];
    }

    private void ensureAttrsCapacity(int n2) {
        if (this.fAttrNode.length <= n2) {
            this.fAttrNode = DOMNodePool.resize(this.fAttrNode, this.fAttrNode.length * 2);
        } else if (this.fAttrNode[n2] != null) {
            return;
        }
        this.fAttrNode[n2] = new AttrNSImpl[256];
    }

    private static AttrNSImpl[][] resize(AttrNSImpl[][] attrNSImplArray, int n2) {
        AttrNSImpl[][] attrNSImplArray2 = new AttrNSImpl[n2][];
        System.arraycopy(attrNSImplArray, 0, attrNSImplArray2, 0, attrNSImplArray.length);
        return attrNSImplArray2;
    }

    public void reset() {
        this.fElementIndex = 0;
        this.fTextNodeIndex = 0;
        this.fAttrNodeIndex = 0;
    }
}

