/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.xni.QName;

public class SubstitutionGroupHandler {
    XSGrammarBucket fGrammarBucket;
    Hashtable fSubGroupsB = new Hashtable();
    private static final OneSubGroup[] EMPTY_VECTOR = new OneSubGroup[0];
    Hashtable fSubGroups = new Hashtable();

    public SubstitutionGroupHandler(XSGrammarBucket xSGrammarBucket) {
        this.fGrammarBucket = xSGrammarBucket;
    }

    public XSElementDecl getMatchingElemDecl(QName qName, XSElementDecl xSElementDecl) {
        if (qName.localpart == xSElementDecl.fName && qName.uri == xSElementDecl.fTargetNamespace) {
            return xSElementDecl;
        }
        if (xSElementDecl.fScope != 1) {
            return null;
        }
        if ((xSElementDecl.fBlock & 4) != 0) {
            return null;
        }
        SchemaGrammar schemaGrammar = this.fGrammarBucket.getGrammar(qName.uri);
        if (schemaGrammar == null) {
            return null;
        }
        XSElementDecl xSElementDecl2 = schemaGrammar.getGlobalElementDecl(qName.localpart);
        if (xSElementDecl2 == null) {
            return null;
        }
        if (this.substitutionGroupOK(xSElementDecl2, xSElementDecl, xSElementDecl.fBlock)) {
            return xSElementDecl2;
        }
        return null;
    }

    protected boolean substitutionGroupOK(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2, short s2) {
        if (xSElementDecl == xSElementDecl2) {
            return true;
        }
        if ((s2 & 4) != 0) {
            return false;
        }
        XSElementDecl xSElementDecl3 = xSElementDecl.fSubGroup;
        while (xSElementDecl3 != null && xSElementDecl3 != xSElementDecl2) {
            xSElementDecl3 = xSElementDecl3.fSubGroup;
        }
        if (xSElementDecl3 == null) {
            return false;
        }
        short s3 = 0;
        short s4 = s2;
        XSTypeDefinition xSTypeDefinition = xSElementDecl.fType;
        while (xSTypeDefinition != xSElementDecl2.fType && xSTypeDefinition != SchemaGrammar.fAnyType) {
            s3 = xSTypeDefinition.getTypeCategory() == 13 ? (short)(s3 | ((XSComplexTypeDecl)xSTypeDefinition).fDerivedBy) : (short)(s3 | 2);
            if ((xSTypeDefinition = xSTypeDefinition.getBaseType()) == null) {
                xSTypeDefinition = SchemaGrammar.fAnyType;
            }
            if (xSTypeDefinition.getTypeCategory() != 13) continue;
            s4 = (short)(s4 | ((XSComplexTypeDecl)xSTypeDefinition).fBlock);
        }
        if (xSTypeDefinition != xSElementDecl2.fType) {
            return false;
        }
        return (s3 & s4) == 0;
    }

    public boolean inSubstitutionGroup(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2) {
        return this.substitutionGroupOK(xSElementDecl, xSElementDecl2, xSElementDecl2.fBlock);
    }

    public void reset() {
        this.fSubGroupsB.clear();
        this.fSubGroups.clear();
    }

    public void addSubstitutionGroup(XSElementDecl[] xSElementDeclArray) {
        int n2 = xSElementDeclArray.length - 1;
        while (n2 >= 0) {
            XSElementDecl xSElementDecl = xSElementDeclArray[n2];
            XSElementDecl xSElementDecl2 = xSElementDecl.fSubGroup;
            Vector<XSElementDecl> vector = (Vector<XSElementDecl>)this.fSubGroupsB.get(xSElementDecl2);
            if (vector == null) {
                vector = new Vector<XSElementDecl>();
                this.fSubGroupsB.put(xSElementDecl2, vector);
            }
            vector.addElement(xSElementDecl);
            --n2;
        }
    }

    public XSElementDecl[] getSubstitutionGroup(XSElementDecl xSElementDecl) {
        Object v2 = this.fSubGroups.get(xSElementDecl);
        if (v2 != null) {
            return (XSElementDecl[])v2;
        }
        OneSubGroup[] oneSubGroupArray = this.getSubGroupB(xSElementDecl, new OneSubGroup());
        int n2 = oneSubGroupArray.length;
        int n3 = 0;
        XSElementDecl[] xSElementDeclArray = new XSElementDecl[n2];
        int n4 = 0;
        while (n4 < n2) {
            if ((xSElementDecl.fBlock & oneSubGroupArray[n4].dMethod) == 0) {
                xSElementDeclArray[n3++] = oneSubGroupArray[n4].sub;
            }
            ++n4;
        }
        if (n3 < n2) {
            XSElementDecl[] xSElementDeclArray2 = new XSElementDecl[n3];
            System.arraycopy(xSElementDeclArray, 0, xSElementDeclArray2, 0, n3);
            xSElementDeclArray = xSElementDeclArray2;
        }
        this.fSubGroups.put(xSElementDecl, xSElementDeclArray);
        return xSElementDeclArray;
    }

    private OneSubGroup[] getSubGroupB(XSElementDecl xSElementDecl, OneSubGroup oneSubGroup) {
        OneSubGroup[] oneSubGroupArray;
        Object v2 = this.fSubGroupsB.get(xSElementDecl);
        if (v2 == null) {
            this.fSubGroupsB.put(xSElementDecl, EMPTY_VECTOR);
            return EMPTY_VECTOR;
        }
        if (v2 instanceof OneSubGroup[]) {
            return (OneSubGroup[])v2;
        }
        Vector vector = (Vector)v2;
        Vector<OneSubGroup> vector2 = new Vector<OneSubGroup>();
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            oneSubGroupArray = (XSElementDecl)vector.elementAt(n2);
            if (this.getDBMethods(oneSubGroupArray.fType, xSElementDecl.fType, oneSubGroup)) {
                short s2 = oneSubGroup.dMethod;
                short s3 = oneSubGroup.bMethod;
                vector2.addElement(new OneSubGroup((XSElementDecl)oneSubGroupArray, oneSubGroup.dMethod, oneSubGroup.bMethod));
                OneSubGroup[] oneSubGroupArray2 = this.getSubGroupB((XSElementDecl)oneSubGroupArray, oneSubGroup);
                int n3 = oneSubGroupArray2.length - 1;
                while (n3 >= 0) {
                    short s4 = (short)(s2 | oneSubGroupArray2[n3].dMethod);
                    short s5 = (short)(s3 | oneSubGroupArray2[n3].bMethod);
                    if ((s4 & s5) == 0) {
                        vector2.addElement(new OneSubGroup(oneSubGroupArray2[n3].sub, s4, s5));
                    }
                    --n3;
                }
            }
            --n2;
        }
        oneSubGroupArray = new OneSubGroup[vector2.size()];
        int n4 = vector2.size() - 1;
        while (n4 >= 0) {
            oneSubGroupArray[n4] = (OneSubGroup)vector2.elementAt(n4);
            --n4;
        }
        this.fSubGroupsB.put(xSElementDecl, oneSubGroupArray);
        return oneSubGroupArray;
    }

    private boolean getDBMethods(XSTypeDefinition xSTypeDefinition, XSTypeDefinition xSTypeDefinition2, OneSubGroup oneSubGroup) {
        int n2 = 0;
        short s2 = 0;
        while (xSTypeDefinition != xSTypeDefinition2 && xSTypeDefinition != SchemaGrammar.fAnyType) {
            n2 = xSTypeDefinition.getTypeCategory() == 13 ? (int)((short)(n2 | ((XSComplexTypeDecl)xSTypeDefinition).fDerivedBy)) : (int)((short)(n2 | 2));
            if ((xSTypeDefinition = xSTypeDefinition.getBaseType()) == null) {
                xSTypeDefinition = SchemaGrammar.fAnyType;
            }
            if (xSTypeDefinition.getTypeCategory() != 13) continue;
            s2 = (short)(s2 | ((XSComplexTypeDecl)xSTypeDefinition).fBlock);
        }
        if (xSTypeDefinition != xSTypeDefinition2 || n2 & s2) {
            return false;
        }
        oneSubGroup.dMethod = (short)n2;
        oneSubGroup.bMethod = s2;
        return true;
    }

    private static final class OneSubGroup {
        XSElementDecl sub;
        short dMethod;
        short bMethod;

        OneSubGroup() {
        }

        OneSubGroup(XSElementDecl xSElementDecl, short s2, short s3) {
            this.sub = xSElementDecl;
            this.dMethod = s2;
            this.bMethod = s3;
        }
    }
}

