/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.dv.DatatypeException;
import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.AnySimpleDV;
import org.apache.xerces.impl.dv.xs.AnyURIDV;
import org.apache.xerces.impl.dv.xs.Base64BinaryDV;
import org.apache.xerces.impl.dv.xs.BooleanDV;
import org.apache.xerces.impl.dv.xs.DateDV;
import org.apache.xerces.impl.dv.xs.DateTimeDV;
import org.apache.xerces.impl.dv.xs.DayDV;
import org.apache.xerces.impl.dv.xs.DecimalDV;
import org.apache.xerces.impl.dv.xs.DoubleDV;
import org.apache.xerces.impl.dv.xs.DurationDV;
import org.apache.xerces.impl.dv.xs.EntityDV;
import org.apache.xerces.impl.dv.xs.FloatDV;
import org.apache.xerces.impl.dv.xs.HexBinaryDV;
import org.apache.xerces.impl.dv.xs.IDDV;
import org.apache.xerces.impl.dv.xs.IDREFDV;
import org.apache.xerces.impl.dv.xs.IntegerDV;
import org.apache.xerces.impl.dv.xs.ListDV;
import org.apache.xerces.impl.dv.xs.MonthDV;
import org.apache.xerces.impl.dv.xs.MonthDayDV;
import org.apache.xerces.impl.dv.xs.QNameDV;
import org.apache.xerces.impl.dv.xs.StringDV;
import org.apache.xerces.impl.dv.xs.TimeDV;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.dv.xs.UnionDV;
import org.apache.xerces.impl.dv.xs.YearDV;
import org.apache.xerces.impl.dv.xs.YearMonthDV;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xs.psvi.StringList;
import org.apache.xerces.impl.xs.psvi.XSAnnotation;
import org.apache.xerces.impl.xs.psvi.XSNamespaceItem;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSSimpleTypeDefinition;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.util.StringListImpl;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.NamespaceContext;

public class XSSimpleTypeDecl
implements XSSimpleType {
    static final short DV_STRING = 1;
    static final short DV_BOOLEAN = 2;
    static final short DV_DECIMAL = 3;
    static final short DV_FLOAT = 4;
    static final short DV_DOUBLE = 5;
    static final short DV_DURATION = 6;
    static final short DV_DATETIME = 7;
    static final short DV_TIME = 8;
    static final short DV_DATE = 9;
    static final short DV_GYEARMONTH = 10;
    static final short DV_GYEAR = 11;
    static final short DV_GMONTHDAY = 12;
    static final short DV_GDAY = 13;
    static final short DV_GMONTH = 14;
    static final short DV_HEXBINARY = 15;
    static final short DV_BASE64BINARY = 16;
    static final short DV_ANYURI = 17;
    static final short DV_QNAME = 18;
    static final short DV_NOTATION = 19;
    static final short DV_ANYSIMPLETYPE = 0;
    static final short DV_ID = 20;
    static final short DV_IDREF = 21;
    static final short DV_ENTITY = 22;
    static final short DV_INTEGER = 23;
    static final short DV_LIST = 24;
    static final short DV_UNION = 25;
    static final TypeValidator[] fDVs = new TypeValidator[]{new AnySimpleDV(), new StringDV(), new BooleanDV(), new DecimalDV(), new FloatDV(), new DoubleDV(), new DurationDV(), new DateTimeDV(), new TimeDV(), new DateDV(), new YearMonthDV(), new YearDV(), new MonthDayDV(), new DayDV(), new MonthDV(), new HexBinaryDV(), new Base64BinaryDV(), new AnyURIDV(), new QNameDV(), new QNameDV(), new IDDV(), new IDREFDV(), new EntityDV(), new IntegerDV(), new ListDV(), new UnionDV()};
    static final short NORMALIZE_NONE = 0;
    static final short NORMALIZE_TRIM = 1;
    static final short NORMALIZE_FULL = 2;
    static final short[] fDVNormalizeType = new short[]{0, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 2, 0};
    static final short SPECIAL_PATTERN_NONE = 0;
    static final short SPECIAL_PATTERN_NMTOKEN = 1;
    static final short SPECIAL_PATTERN_NAME = 2;
    static final short SPECIAL_PATTERN_NCNAME = 3;
    static final String[] SPECIAL_PATTERN_STRING = new String[]{"NONE", "NMTOKEN", "Name", "NCName"};
    static final String[] WS_FACET_STRING = new String[]{"preserve", "replace", "collapse"};
    static final String URI_SCHEMAFORSCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String ANY_TYPE = "anyType";
    static final ValidationContext fEmptyContext = new ValidationContext(){

        public boolean needFacetChecking() {
            return true;
        }

        public boolean needExtraChecking() {
            return false;
        }

        public boolean needToNormalize() {
            return true;
        }

        public boolean isEntityDeclared(String string) {
            return false;
        }

        public boolean isEntityUnparsed(String string) {
            return false;
        }

        public boolean isIdDeclared(String string) {
            return false;
        }

        public void addId(String string) {
        }

        public void addIdRef(String string) {
        }

        public String getSymbol(String string) {
            return null;
        }

        public String getURI(String string) {
            return null;
        }
    };
    private boolean fIsImmutable = false;
    private XSSimpleTypeDecl fItemType;
    private XSSimpleTypeDecl[] fMemberTypes;
    private String fTypeName;
    private String fTargetNamespace;
    private short fFinalSet = 0;
    private XSSimpleTypeDecl fBase;
    private short fVariety = (short)-1;
    private short fValidationDV = (short)-1;
    private short fFacetsDefined = 0;
    private short fFixedFacet = 0;
    private short fWhiteSpace = 0;
    private int fLength = -1;
    private int fMinLength = -1;
    private int fMaxLength = -1;
    private int fTotalDigits = -1;
    private int fFractionDigits = -1;
    private Vector fPattern;
    private Vector fPatternStr;
    private Vector fEnumeration;
    private Object fMaxInclusive;
    private Object fMaxExclusive;
    private Object fMinExclusive;
    private Object fMinInclusive;
    private short fPatternType = 0;
    private short fOrdered;
    private boolean fFinite;
    private boolean fBounded;
    private boolean fNumeric;
    static final XSSimpleTypeDecl fAnySimpleType = new XSSimpleTypeDecl(null, "anySimpleType", 0, 0, false, true, false, true);
    static final ValidationContext fDummyContext = new ValidationContext(){

        public boolean needFacetChecking() {
            return true;
        }

        public boolean needExtraChecking() {
            return false;
        }

        public boolean needToNormalize() {
            return false;
        }

        public boolean isEntityDeclared(String string) {
            return false;
        }

        public boolean isEntityUnparsed(String string) {
            return false;
        }

        public boolean isIdDeclared(String string) {
            return false;
        }

        public void addId(String string) {
        }

        public void addIdRef(String string) {
        }

        public String getSymbol(String string) {
            return null;
        }

        public String getURI(String string) {
            return null;
        }
    };

    public XSSimpleTypeDecl() {
    }

    protected XSSimpleTypeDecl(XSSimpleTypeDecl xSSimpleTypeDecl, String string, short s2, short s3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.fIsImmutable = bl4;
        this.fBase = xSSimpleTypeDecl;
        this.fTypeName = string;
        this.fTargetNamespace = URI_SCHEMAFORSCHEMA;
        this.fVariety = 1;
        this.fValidationDV = s2;
        this.fFacetsDefined = (short)16;
        if (s2 == 1) {
            this.fWhiteSpace = 0;
        } else {
            this.fWhiteSpace = (short)2;
            this.fFixedFacet = (short)16;
        }
        this.fOrdered = s3;
        this.fBounded = bl;
        this.fFinite = bl2;
        this.fNumeric = bl3;
    }

    protected XSSimpleTypeDecl(XSSimpleTypeDecl xSSimpleTypeDecl, String string, String string2, short s2, boolean bl) {
        this.fBase = xSSimpleTypeDecl;
        this.fTypeName = string;
        this.fTargetNamespace = string2;
        this.fFinalSet = s2;
        this.fVariety = this.fBase.fVariety;
        this.fValidationDV = this.fBase.fValidationDV;
        switch (this.fVariety) {
            case 1: {
                break;
            }
            case 2: {
                this.fItemType = this.fBase.fItemType;
                break;
            }
            case 3: {
                this.fMemberTypes = this.fBase.fMemberTypes;
            }
        }
        this.fLength = this.fBase.fLength;
        this.fMinLength = this.fBase.fMinLength;
        this.fMaxLength = this.fBase.fMaxLength;
        this.fPattern = this.fBase.fPattern;
        this.fPatternStr = this.fBase.fPatternStr;
        this.fEnumeration = this.fBase.fEnumeration;
        this.fWhiteSpace = this.fBase.fWhiteSpace;
        this.fMaxExclusive = this.fBase.fMaxExclusive;
        this.fMaxInclusive = this.fBase.fMaxInclusive;
        this.fMinExclusive = this.fBase.fMinExclusive;
        this.fMinInclusive = this.fBase.fMinInclusive;
        this.fTotalDigits = this.fBase.fTotalDigits;
        this.fFractionDigits = this.fBase.fFractionDigits;
        this.fPatternType = this.fBase.fPatternType;
        this.fFixedFacet = this.fBase.fFixedFacet;
        this.fFacetsDefined = this.fBase.fFacetsDefined;
        this.caclFundamentalFacets();
        this.fIsImmutable = bl;
    }

    protected XSSimpleTypeDecl(String string, String string2, short s2, XSSimpleTypeDecl xSSimpleTypeDecl, boolean bl) {
        this.fBase = fAnySimpleType;
        this.fTypeName = string;
        this.fTargetNamespace = string2;
        this.fFinalSet = s2;
        this.fVariety = (short)2;
        this.fItemType = xSSimpleTypeDecl;
        this.fValidationDV = (short)24;
        this.fFacetsDefined = (short)16;
        this.fFixedFacet = (short)16;
        this.fWhiteSpace = (short)2;
        this.caclFundamentalFacets();
        this.fIsImmutable = bl;
    }

    protected XSSimpleTypeDecl(String string, String string2, short s2, XSSimpleTypeDecl[] xSSimpleTypeDeclArray) {
        this.fBase = fAnySimpleType;
        this.fTypeName = string;
        this.fTargetNamespace = string2;
        this.fFinalSet = s2;
        this.fVariety = (short)3;
        this.fMemberTypes = xSSimpleTypeDeclArray;
        this.fValidationDV = (short)25;
        this.fFacetsDefined = (short)16;
        this.fWhiteSpace = (short)2;
        this.caclFundamentalFacets();
        this.fIsImmutable = false;
    }

    protected XSSimpleTypeDecl setRestrictionValues(XSSimpleTypeDecl xSSimpleTypeDecl, String string, String string2, short s2) {
        if (this.fIsImmutable) {
            return null;
        }
        this.fBase = xSSimpleTypeDecl;
        this.fTypeName = string;
        this.fTargetNamespace = string2;
        this.fFinalSet = s2;
        this.fVariety = this.fBase.fVariety;
        this.fValidationDV = this.fBase.fValidationDV;
        switch (this.fVariety) {
            case 1: {
                break;
            }
            case 2: {
                this.fItemType = this.fBase.fItemType;
                break;
            }
            case 3: {
                this.fMemberTypes = this.fBase.fMemberTypes;
            }
        }
        this.fLength = this.fBase.fLength;
        this.fMinLength = this.fBase.fMinLength;
        this.fMaxLength = this.fBase.fMaxLength;
        this.fPattern = this.fBase.fPattern;
        this.fPatternStr = this.fBase.fPatternStr;
        this.fEnumeration = this.fBase.fEnumeration;
        this.fWhiteSpace = this.fBase.fWhiteSpace;
        this.fMaxExclusive = this.fBase.fMaxExclusive;
        this.fMaxInclusive = this.fBase.fMaxInclusive;
        this.fMinExclusive = this.fBase.fMinExclusive;
        this.fMinInclusive = this.fBase.fMinInclusive;
        this.fTotalDigits = this.fBase.fTotalDigits;
        this.fFractionDigits = this.fBase.fFractionDigits;
        this.fPatternType = this.fBase.fPatternType;
        this.fFixedFacet = this.fBase.fFixedFacet;
        this.fFacetsDefined = this.fBase.fFacetsDefined;
        this.caclFundamentalFacets();
        return this;
    }

    protected XSSimpleTypeDecl setListValues(String string, String string2, short s2, XSSimpleTypeDecl xSSimpleTypeDecl) {
        if (this.fIsImmutable) {
            return null;
        }
        this.fBase = fAnySimpleType;
        this.fTypeName = string;
        this.fTargetNamespace = string2;
        this.fFinalSet = s2;
        this.fVariety = (short)2;
        this.fItemType = xSSimpleTypeDecl;
        this.fValidationDV = (short)24;
        this.fFacetsDefined = (short)16;
        this.fFixedFacet = (short)16;
        this.fWhiteSpace = (short)2;
        this.caclFundamentalFacets();
        return this;
    }

    protected XSSimpleTypeDecl setUnionValues(String string, String string2, short s2, XSSimpleTypeDecl[] xSSimpleTypeDeclArray) {
        if (this.fIsImmutable) {
            return null;
        }
        this.fBase = fAnySimpleType;
        this.fTypeName = string;
        this.fTargetNamespace = string2;
        this.fFinalSet = s2;
        this.fVariety = (short)3;
        this.fMemberTypes = xSSimpleTypeDeclArray;
        this.fValidationDV = (short)25;
        this.fFacetsDefined = (short)16;
        this.fWhiteSpace = (short)2;
        this.caclFundamentalFacets();
        return this;
    }

    public short getType() {
        return 3;
    }

    public short getTypeCategory() {
        return 14;
    }

    public String getName() {
        return this.fTypeName;
    }

    public String getNamespace() {
        return this.fTargetNamespace;
    }

    public short getFinal() {
        return this.fFinalSet;
    }

    public boolean isFinal(short s2) {
        return (this.fFinalSet & s2) != 0;
    }

    public XSTypeDefinition getBaseType() {
        return this.fBase;
    }

    public boolean getAnonymous() {
        return this.fTypeName == null;
    }

    public short getVariety() {
        return this.fValidationDV == 0 ? (short)0 : this.fVariety;
    }

    public boolean isIDType() {
        switch (this.fVariety) {
            case 1: {
                return this.fValidationDV == 20;
            }
            case 2: {
                return this.fItemType.isIDType();
            }
            case 3: {
                int n2 = 0;
                while (n2 < this.fMemberTypes.length) {
                    if (this.fMemberTypes[n2].isIDType()) {
                        return true;
                    }
                    ++n2;
                }
                break;
            }
        }
        return false;
    }

    public short getWhitespace() throws DatatypeException {
        if (this.fVariety == 3) {
            throw new DatatypeException("dt-whitespace", new Object[]{this.fTypeName});
        }
        return this.fWhiteSpace;
    }

    public short getPrimitiveKind() {
        if (this.fVariety == 1 && this.fValidationDV != 0) {
            if (this.fValidationDV == 20 || this.fValidationDV == 21 || this.fValidationDV == 22) {
                return 1;
            }
            if (this.fValidationDV == 23) {
                return 3;
            }
            return this.fValidationDV;
        }
        return 0;
    }

    public XSSimpleTypeDefinition getPrimitiveType() {
        if (this.fVariety == 1 && this.fValidationDV != 0) {
            XSSimpleTypeDecl xSSimpleTypeDecl = this;
            while (xSSimpleTypeDecl.fBase != fAnySimpleType) {
                xSSimpleTypeDecl = xSSimpleTypeDecl.fBase;
            }
            return xSSimpleTypeDecl;
        }
        return null;
    }

    public XSSimpleTypeDefinition getItemType() {
        if (this.fVariety == 2) {
            return this.fItemType;
        }
        return null;
    }

    public XSObjectList getMemberTypes() {
        if (this.fVariety == 3) {
            return new XSObjectListImpl(this.fMemberTypes, this.fMemberTypes.length);
        }
        return null;
    }

    public void applyFacets(XSFacets xSFacets, short s2, short s3, ValidationContext validationContext) throws InvalidDatatypeFacetException {
        this.applyFacets(xSFacets, s2, s3, (short)0, validationContext);
    }

    void applyFacets1(XSFacets xSFacets, short s2, short s3) {
        try {
            this.applyFacets(xSFacets, s2, s3, (short)0, fDummyContext);
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            throw new RuntimeException("internal error");
        }
        this.fIsImmutable = true;
    }

    void applyFacets1(XSFacets xSFacets, short s2, short s3, short s4) {
        try {
            this.applyFacets(xSFacets, s2, s3, s4, fDummyContext);
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            throw new RuntimeException("internal error");
        }
        this.fIsImmutable = true;
    }

    void applyFacets(XSFacets xSFacets, short s2, short s3, short s4, ValidationContext validationContext) throws InvalidDatatypeFacetException {
        Serializable serializable;
        if (this.fIsImmutable) {
            return;
        }
        ValidatedInfo validatedInfo = new ValidatedInfo();
        this.fFacetsDefined = 0;
        this.fFixedFacet = 0;
        int n2 = 0;
        short s5 = fDVs[this.fValidationDV].getAllowedFacets();
        if ((s2 & 1) != 0) {
            if ((s5 & 1) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"length"});
            } else {
                this.fLength = xSFacets.length;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
                if ((s3 & 1) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 1);
                }
            }
        }
        if ((s2 & 2) != 0) {
            if ((s5 & 2) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"minLength"});
            } else {
                this.fMinLength = xSFacets.minLength;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
                if ((s3 & 2) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 2);
                }
            }
        }
        if ((s2 & 4) != 0) {
            if ((s5 & 4) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"maxLength"});
            } else {
                this.fMaxLength = xSFacets.maxLength;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
                if ((s3 & 4) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 4);
                }
            }
        }
        if ((s2 & 8) != 0) {
            if ((s5 & 8) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"pattern"});
            } else {
                serializable = null;
                try {
                    serializable = new RegularExpression(xSFacets.pattern, "X");
                }
                catch (Exception exception) {
                    this.reportError("InvalidRegex", new Object[]{xSFacets.pattern, exception.getLocalizedMessage()});
                }
                if (serializable != null) {
                    this.fPattern = new Vector();
                    this.fPattern.addElement(serializable);
                    this.fPatternStr = new Vector();
                    this.fPatternStr.addElement(xSFacets.pattern);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    if ((s3 & 8) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 8);
                    }
                }
            }
        }
        if ((s2 & 0x800) != 0) {
            if ((s5 & 0x800) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"enumeration"});
            } else {
                this.fEnumeration = new Vector();
                serializable = xSFacets.enumeration;
                Vector vector = xSFacets.enumNSDecls;
                ValidationContextImpl validationContextImpl = new ValidationContextImpl(validationContext);
                int n3 = 0;
                while (n3 < ((Vector)serializable).size()) {
                    if (vector != null) {
                        validationContextImpl.setNSContext((NamespaceContext)vector.elementAt(n3));
                    }
                    try {
                        this.fEnumeration.addElement(this.fBase.validate((String)((Vector)serializable).elementAt(n3), (ValidationContext)validationContextImpl, validatedInfo));
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        this.reportError("enumeration-valid-restriction", new Object[]{((Vector)serializable).elementAt(n3)});
                    }
                    ++n3;
                }
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x800);
                if ((s3 & 0x800) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x800);
                }
            }
        }
        if ((s2 & 0x10) != 0) {
            if ((s5 & 0x10) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"whiteSpace"});
            } else {
                this.fWhiteSpace = xSFacets.whiteSpace;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                if ((s3 & 0x10) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x10);
                }
            }
        }
        boolean bl = true;
        if ((s2 & 0x20) != 0) {
            if ((s5 & 0x20) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"maxInclusive"});
            } else {
                try {
                    this.fMaxInclusive = this.getActualValue(xSFacets.maxInclusive, validationContext, validatedInfo, true);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                    if ((s3 & 0x20) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x20);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportError("FacetValueFromBase", new Object[]{xSFacets.maxInclusive, "maxInclusive"});
                }
                if ((this.fBase.fFacetsDefined & 0x20) != 0) {
                    n2 = fDVs[this.fValidationDV].compare(this.fMaxInclusive, this.fBase.fMaxInclusive);
                    if ((this.fBase.fFixedFacet & 0x20) != 0 && n2 != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"maxInclusive", this.fMaxInclusive, this.fBase.fMaxInclusive});
                    }
                    if (n2 == 0) {
                        bl = false;
                    }
                }
                if (bl) {
                    try {
                        this.fBase.validate(validationContext, validatedInfo);
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        this.reportError("FacetValueFromBase", new Object[]{xSFacets.maxInclusive, "maxInclusive"});
                    }
                }
            }
        }
        bl = true;
        if ((s2 & 0x40) != 0) {
            if ((s5 & 0x40) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"maxExclusive"});
            } else {
                try {
                    this.fMaxExclusive = this.getActualValue(xSFacets.maxExclusive, validationContext, validatedInfo, true);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                    if ((s3 & 0x40) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x40);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportError("FacetValueFromBase", new Object[]{xSFacets.maxExclusive, "maxExclusive"});
                }
                if ((this.fBase.fFacetsDefined & 0x40) != 0) {
                    n2 = fDVs[this.fValidationDV].compare(this.fMaxExclusive, this.fBase.fMaxExclusive);
                    if ((this.fBase.fFixedFacet & 0x40) != 0 && n2 != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"maxExclusive", xSFacets.maxExclusive, this.fBase.fMaxExclusive});
                    }
                    if (n2 == 0) {
                        bl = false;
                    }
                }
                if (bl) {
                    try {
                        this.fBase.validate(validationContext, validatedInfo);
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        this.reportError("FacetValueFromBase", new Object[]{xSFacets.maxExclusive, "maxExclusive"});
                    }
                }
            }
        }
        bl = true;
        if ((s2 & 0x80) != 0) {
            if ((s5 & 0x80) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"minExclusive"});
            } else {
                try {
                    this.fMinExclusive = this.getActualValue(xSFacets.minExclusive, validationContext, validatedInfo, true);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                    if ((s3 & 0x80) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x80);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportError("FacetValueFromBase", new Object[]{xSFacets.minExclusive, "minExclusive"});
                }
                if ((this.fBase.fFacetsDefined & 0x80) != 0) {
                    n2 = fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fBase.fMinExclusive);
                    if ((this.fBase.fFixedFacet & 0x80) != 0 && n2 != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"minExclusive", xSFacets.minExclusive, this.fBase.fMinExclusive});
                    }
                    if (n2 == 0) {
                        bl = false;
                    }
                }
                if (bl) {
                    try {
                        this.fBase.validate(validationContext, validatedInfo);
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        this.reportError("FacetValueFromBase", new Object[]{xSFacets.minExclusive, "minExclusive"});
                    }
                }
            }
        }
        bl = true;
        if ((s2 & 0x100) != 0) {
            if ((s5 & 0x100) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"minInclusive"});
            } else {
                try {
                    this.fMinInclusive = this.getActualValue(xSFacets.minInclusive, validationContext, validatedInfo, true);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                    if ((s3 & 0x100) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x100);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportError("FacetValueFromBase", new Object[]{xSFacets.minInclusive, "minInclusive"});
                }
                if ((this.fBase.fFacetsDefined & 0x100) != 0) {
                    n2 = fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fBase.fMinInclusive);
                    if ((this.fBase.fFixedFacet & 0x100) != 0 && n2 != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"minInclusive", xSFacets.minInclusive, this.fBase.fMinInclusive});
                    }
                    if (n2 == 0) {
                        bl = false;
                    }
                }
                if (bl) {
                    try {
                        this.fBase.validate(validationContext, validatedInfo);
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        this.reportError("FacetValueFromBase", new Object[]{xSFacets.minInclusive, "minInclusive"});
                    }
                }
            }
        }
        if ((s2 & 0x200) != 0) {
            if ((s5 & 0x200) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"totalDigits"});
            } else {
                this.fTotalDigits = xSFacets.totalDigits;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x200);
                if ((s3 & 0x200) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x200);
                }
            }
        }
        if ((s2 & 0x400) != 0) {
            if ((s5 & 0x400) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"fractionDigits"});
            } else {
                this.fFractionDigits = xSFacets.fractionDigits;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x400);
                if ((s3 & 0x400) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x400);
                }
            }
        }
        if (s4 != 0) {
            this.fPatternType = s4;
        }
        if (this.fFacetsDefined != 0) {
            if ((this.fFacetsDefined & 1) != 0 && ((this.fFacetsDefined & 2) != 0 || (this.fFacetsDefined & 4) != 0)) {
                this.reportError("length-minLength-maxLength", null);
            }
            if ((this.fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 4) != 0 && this.fMinLength > this.fMaxLength) {
                this.reportError("minLength-less-than-equal-to-maxLength", new Object[]{Integer.toString(this.fMinLength), Integer.toString(this.fMaxLength)});
            }
            if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x20) != 0) {
                this.reportError("maxInclusive-maxExclusive", null);
            }
            if ((this.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x100) != 0) {
                this.reportError("minInclusive-minExclusive", null);
            }
            if ((this.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x100) != 0 && (n2 = fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fMaxInclusive)) != -1 && n2 != 0) {
                this.reportError("minInclusive-less-than-equal-to-maxInclusive", new Object[]{this.fMinInclusive, this.fMaxInclusive});
            }
            if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x80) != 0 && (n2 = fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fMaxExclusive)) != -1 && n2 != 0) {
                this.reportError("minExclusive-less-than-equal-to-maxExclusive", new Object[]{this.fMinExclusive, this.fMaxExclusive});
            }
            if ((this.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x80) != 0 && fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fMaxInclusive) != -1) {
                this.reportError("minExclusive-less-than-maxInclusive", new Object[]{this.fMinExclusive, this.fMaxInclusive});
            }
            if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x100) != 0 && fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fMaxExclusive) != -1) {
                this.reportError("minInclusive-less-than-maxExclusive", new Object[]{this.fMinInclusive, this.fMaxExclusive});
            }
            if ((this.fFacetsDefined & 0x400) != 0 && (this.fFacetsDefined & 0x200) != 0 && this.fFractionDigits > this.fTotalDigits) {
                this.reportError("fractionDigits-totalDigits", new Object[]{Integer.toString(this.fFractionDigits), Integer.toString(this.fTotalDigits)});
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fBase.fFacetsDefined & 4) != 0 || (this.fBase.fFacetsDefined & 2) != 0) {
                    this.reportError("length-minLength-maxLength", null);
                } else if ((this.fBase.fFacetsDefined & 1) != 0 && this.fLength != this.fBase.fLength) {
                    this.reportError("length-valid-restriction", new Object[]{Integer.toString(this.fLength), Integer.toString(this.fBase.fLength)});
                }
            }
            if ((this.fBase.fFacetsDefined & 1) != 0 && ((this.fFacetsDefined & 4) != 0 || (this.fFacetsDefined & 2) != 0)) {
                this.reportError("length-minLength-maxLength", null);
            }
            if ((this.fFacetsDefined & 2) != 0) {
                if ((this.fBase.fFacetsDefined & 4) != 0) {
                    if (this.fMinLength > this.fBase.fMaxLength) {
                        this.reportError("minLength-less-than-equal-to-maxLength", new Object[]{Integer.toString(this.fMinLength), Integer.toString(this.fBase.fMaxLength)});
                    }
                } else if ((this.fBase.fFacetsDefined & 2) != 0) {
                    if ((this.fBase.fFixedFacet & 2) != 0 && this.fMinLength != this.fBase.fMinLength) {
                        this.reportError("FixedFacetValue", new Object[]{"minLength", Integer.toString(this.fMinLength), Integer.toString(this.fBase.fMinLength)});
                    }
                    if (this.fMinLength < this.fBase.fMinLength) {
                        this.reportError("minLength-valid-restriction", new Object[]{Integer.toString(this.fMinLength), Integer.toString(this.fBase.fMinLength)});
                    }
                }
            }
            if ((this.fFacetsDefined & 4) != 0 && (this.fBase.fFacetsDefined & 2) != 0 && this.fMaxLength < this.fBase.fMinLength) {
                this.reportError("minLength-less-than-equal-to-maxLength", new Object[]{Integer.toString(this.fBase.fMinLength), Integer.toString(this.fMaxLength)});
            }
            if ((this.fFacetsDefined & 4) != 0 && (this.fBase.fFacetsDefined & 4) != 0) {
                if ((this.fBase.fFixedFacet & 4) != 0 && this.fMaxLength != this.fBase.fMaxLength) {
                    this.reportError("FixedFacetValue", new Object[]{"maxLength", Integer.toString(this.fMaxLength), Integer.toString(this.fBase.fMaxLength)});
                }
                if (this.fMaxLength > this.fBase.fMaxLength) {
                    this.reportError("maxLength-valid-restriction", new Object[]{Integer.toString(this.fMaxLength), Integer.toString(this.fBase.fMaxLength)});
                }
            }
            if ((this.fFacetsDefined & 0x200) != 0 && (this.fBase.fFacetsDefined & 0x200) != 0) {
                if ((this.fBase.fFixedFacet & 0x200) != 0 && this.fTotalDigits != this.fBase.fTotalDigits) {
                    this.reportError("FixedFacetValue", new Object[]{"totalDigits", Integer.toString(this.fTotalDigits), Integer.toString(this.fBase.fTotalDigits)});
                }
                if (this.fTotalDigits > this.fBase.fTotalDigits) {
                    this.reportError("totalDigits-valid-restriction", new Object[]{Integer.toString(this.fTotalDigits), Integer.toString(this.fBase.fTotalDigits)});
                }
            }
            if ((this.fFacetsDefined & 0x400) != 0 && (this.fBase.fFacetsDefined & 0x200) != 0 && this.fFractionDigits > this.fBase.fTotalDigits) {
                this.reportError("fractionDigits-totalDigits", new Object[]{Integer.toString(this.fFractionDigits), Integer.toString(this.fTotalDigits)});
            }
            if ((this.fFacetsDefined & 0x400) != 0 && (this.fBase.fFacetsDefined & 0x400) != 0 && (this.fBase.fFixedFacet & 0x400) != 0 && this.fFractionDigits != this.fBase.fFractionDigits) {
                this.reportError("FixedFacetValue", new Object[]{"fractionDigits", Integer.toString(this.fFractionDigits), Integer.toString(this.fBase.fFractionDigits)});
            }
            if ((this.fFacetsDefined & 0x10) != 0 && (this.fBase.fFacetsDefined & 0x10) != 0) {
                if ((this.fBase.fFixedFacet & 0x10) != 0 && this.fWhiteSpace != this.fBase.fWhiteSpace) {
                    this.reportError("FixedFacetValue", new Object[]{"whiteSpace", this.whiteSpaceValue(this.fWhiteSpace), this.whiteSpaceValue(this.fBase.fWhiteSpace)});
                }
                if ((this.fWhiteSpace == 0 || this.fWhiteSpace == 1) && this.fBase.fWhiteSpace == 2) {
                    this.reportError("whiteSpace-valid-restriction.1", null);
                }
                if (this.fWhiteSpace == 0 && this.fBase.fWhiteSpace == 1) {
                    this.reportError("whiteSpace-valid-restriction.2", null);
                }
            }
        }
        if ((this.fFacetsDefined & 1) == 0 && (this.fBase.fFacetsDefined & 1) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
            this.fLength = this.fBase.fLength;
        }
        if ((this.fFacetsDefined & 2) == 0 && (this.fBase.fFacetsDefined & 2) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
            this.fMinLength = this.fBase.fMinLength;
        }
        if ((this.fFacetsDefined & 4) == 0 && (this.fBase.fFacetsDefined & 4) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
            this.fMaxLength = this.fBase.fMaxLength;
        }
        if ((this.fBase.fFacetsDefined & 8) != 0) {
            if ((this.fFacetsDefined & 8) == 0) {
                this.fPattern = this.fBase.fPattern;
                this.fPatternStr = this.fBase.fPatternStr;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
            } else {
                int n4 = this.fBase.fPattern.size() - 1;
                while (n4 >= 0) {
                    this.fPattern.addElement(this.fBase.fPattern.elementAt(n4));
                    this.fPatternStr.addElement(this.fBase.fPatternStr.elementAt(n4));
                    --n4;
                }
            }
        }
        if ((this.fFacetsDefined & 0x10) == 0 && (this.fBase.fFacetsDefined & 0x10) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
            this.fWhiteSpace = this.fBase.fWhiteSpace;
        }
        if ((this.fFacetsDefined & 0x800) == 0 && (this.fBase.fFacetsDefined & 0x800) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x800);
            this.fEnumeration = this.fBase.fEnumeration;
        }
        if ((this.fBase.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x20) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
            this.fMaxExclusive = this.fBase.fMaxExclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x20) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
            this.fMaxInclusive = this.fBase.fMaxInclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x80) == 0 && (this.fFacetsDefined & 0x100) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
            this.fMinExclusive = this.fBase.fMinExclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x80) == 0 && (this.fFacetsDefined & 0x100) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
            this.fMinInclusive = this.fBase.fMinInclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x200) != 0 && (this.fFacetsDefined & 0x200) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x200);
            this.fTotalDigits = this.fBase.fTotalDigits;
        }
        if ((this.fBase.fFacetsDefined & 0x400) != 0 && (this.fFacetsDefined & 0x400) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x400);
            this.fFractionDigits = this.fBase.fFractionDigits;
        }
        if (this.fPatternType == 0 && this.fBase.fPatternType != 0) {
            this.fPatternType = this.fBase.fPatternType;
        }
        this.fFixedFacet = (short)(this.fFixedFacet | this.fBase.fFixedFacet);
        this.caclFundamentalFacets();
    }

    public Object validate(String string, ValidationContext validationContext, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (validationContext == null) {
            validationContext = fEmptyContext;
        }
        if (validatedInfo == null) {
            validatedInfo = new ValidatedInfo();
        } else {
            validatedInfo.memberType = null;
        }
        boolean bl = validationContext == null || validationContext.needToNormalize();
        Object object = this.getActualValue(string, validationContext, validatedInfo, bl);
        this.validate(validationContext, validatedInfo);
        return object;
    }

    public Object validate(Object object, ValidationContext validationContext, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (validationContext == null) {
            validationContext = fEmptyContext;
        }
        if (validatedInfo == null) {
            validatedInfo = new ValidatedInfo();
        } else {
            validatedInfo.memberType = null;
        }
        boolean bl = validationContext == null || validationContext.needToNormalize();
        Object object2 = this.getActualValue(object, validationContext, validatedInfo, bl);
        this.validate(validationContext, validatedInfo);
        return object2;
    }

    public void validate(ValidationContext validationContext, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (validationContext == null) {
            validationContext = fEmptyContext;
        }
        if (validationContext.needFacetChecking() && this.fFacetsDefined != 0 && this.fFacetsDefined != 16) {
            this.checkFacets(validatedInfo);
        }
        if (validationContext.needExtraChecking()) {
            this.checkExtraRules(validationContext, validatedInfo);
        }
    }

    private void checkFacets(ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        int n2;
        Object object = validatedInfo.actualValue;
        String string = validatedInfo.normalizedValue;
        if (this.fValidationDV != 18 && this.fValidationDV != 19) {
            n2 = fDVs[this.fValidationDV].getDataLength(object);
            if ((this.fFacetsDefined & 4) != 0 && n2 > this.fMaxLength) {
                throw new InvalidDatatypeValueException("cvc-maxLength-valid", new Object[]{string, Integer.toString(n2), Integer.toString(this.fMaxLength)});
            }
            if ((this.fFacetsDefined & 2) != 0 && n2 < this.fMinLength) {
                throw new InvalidDatatypeValueException("cvc-minLength-valid", new Object[]{string, Integer.toString(n2), Integer.toString(this.fMinLength)});
            }
            if ((this.fFacetsDefined & 1) != 0 && n2 != this.fLength) {
                throw new InvalidDatatypeValueException("cvc-length-valid", new Object[]{string, Integer.toString(n2), Integer.toString(this.fLength)});
            }
        }
        if ((this.fFacetsDefined & 0x800) != 0) {
            n2 = 0;
            int n3 = 0;
            while (n3 < this.fEnumeration.size()) {
                if (this.fEnumeration.elementAt(n3).equals(object)) {
                    n2 = 1;
                    break;
                }
                ++n3;
            }
            if (n2 == 0) {
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{string, this.fEnumeration.toString()});
            }
        }
        if ((this.fFacetsDefined & 0x400) != 0 && (n2 = fDVs[this.fValidationDV].getFractionDigits(object)) > this.fFractionDigits) {
            throw new InvalidDatatypeValueException("cvc-fractionDigits-valid", new Object[]{string, Integer.toString(n2), Integer.toString(this.fFractionDigits)});
        }
        if ((this.fFacetsDefined & 0x200) != 0 && (n2 = fDVs[this.fValidationDV].getTotalDigits(object)) > this.fTotalDigits) {
            throw new InvalidDatatypeValueException("cvc-totalDigits-valid", new Object[]{string, Integer.toString(n2), Integer.toString(this.fTotalDigits)});
        }
        if ((this.fFacetsDefined & 0x20) != 0 && (n2 = fDVs[this.fValidationDV].compare(object, this.fMaxInclusive)) != -1 && n2 != 0) {
            throw new InvalidDatatypeValueException("cvc-maxInclusive-valid", new Object[]{string, this.fMaxInclusive});
        }
        if ((this.fFacetsDefined & 0x40) != 0 && (n2 = fDVs[this.fValidationDV].compare(object, this.fMaxExclusive)) != -1) {
            throw new InvalidDatatypeValueException("cvc-maxExclusive-valid", new Object[]{string, this.fMaxExclusive});
        }
        if ((this.fFacetsDefined & 0x100) != 0 && (n2 = fDVs[this.fValidationDV].compare(object, this.fMinInclusive)) != 1 && n2 != 0) {
            throw new InvalidDatatypeValueException("cvc-minInclusive-valid", new Object[]{string, this.fMinInclusive});
        }
        if ((this.fFacetsDefined & 0x80) != 0 && (n2 = fDVs[this.fValidationDV].compare(object, this.fMinExclusive)) != 1) {
            throw new InvalidDatatypeValueException("cvc-minExclusive-valid", new Object[]{string, this.fMinExclusive});
        }
    }

    private void checkExtraRules(ValidationContext validationContext, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        Object object = validatedInfo.actualValue;
        if (this.fVariety == 1) {
            fDVs[this.fValidationDV].checkExtraRules(object, validationContext);
        } else if (this.fVariety == 2) {
            ListDV.ListData listData = (ListDV.ListData)object;
            int n2 = listData.length();
            if (this.fItemType.fVariety == 3) {
                XSSimpleTypeDecl[] xSSimpleTypeDeclArray = (XSSimpleTypeDecl[])validatedInfo.memberTypes;
                XSSimpleType xSSimpleType = validatedInfo.memberType;
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    validatedInfo.actualValue = listData.item(n3);
                    validatedInfo.memberType = xSSimpleTypeDeclArray[n3];
                    this.fItemType.checkExtraRules(validationContext, validatedInfo);
                    --n3;
                }
                validatedInfo.memberType = xSSimpleType;
            } else {
                int n4 = n2 - 1;
                while (n4 >= 0) {
                    validatedInfo.actualValue = listData.item(n4);
                    this.fItemType.checkExtraRules(validationContext, validatedInfo);
                    --n4;
                }
            }
            validatedInfo.actualValue = listData;
        } else {
            ((XSSimpleTypeDecl)validatedInfo.memberType).checkExtraRules(validationContext, validatedInfo);
        }
    }

    private Object getActualValue(Object object, ValidationContext validationContext, ValidatedInfo validatedInfo, boolean bl) throws InvalidDatatypeValueException {
        Object object2;
        int n2;
        String string = bl ? this.normalize(object, this.fWhiteSpace) : object.toString();
        if ((this.fFacetsDefined & 8) != 0) {
            n2 = this.fPattern.size() - 1;
            while (n2 >= 0) {
                object2 = (RegularExpression)this.fPattern.elementAt(n2);
                if (!((RegularExpression)object2).matches(string)) {
                    throw new InvalidDatatypeValueException("cvc-pattern-valid", new Object[]{object, this.fPatternStr.elementAt(n2)});
                }
                --n2;
            }
        }
        if (this.fVariety == 1) {
            if (this.fPatternType != 0) {
                boolean bl2 = false;
                if (this.fPatternType == 1) {
                    bl2 = !XMLChar.isValidNmtoken(string);
                } else if (this.fPatternType == 2) {
                    bl2 = !XMLChar.isValidName(string);
                } else if (this.fPatternType == 3) {
                    boolean bl3 = bl2 = !XMLChar.isValidNCName(string);
                }
                if (bl2) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, SPECIAL_PATTERN_STRING[this.fPatternType]});
                }
            }
            validatedInfo.normalizedValue = string;
            validatedInfo.actualValue = object2 = fDVs[this.fValidationDV].getActualValue(string, validationContext);
            return object2;
        }
        if (this.fVariety == 2) {
            object2 = new StringTokenizer(string, " ");
            n2 = ((StringTokenizer)object2).countTokens();
            Object[] objectArray = new Object[n2];
            XSSimpleTypeDecl[] xSSimpleTypeDeclArray = new XSSimpleTypeDecl[n2];
            int n3 = 0;
            while (n3 < n2) {
                objectArray[n3] = this.fItemType.getActualValue(((StringTokenizer)object2).nextToken(), validationContext, validatedInfo, false);
                if (validationContext.needFacetChecking() && this.fItemType.fFacetsDefined != 0 && this.fItemType.fFacetsDefined != 16) {
                    this.fItemType.checkFacets(validatedInfo);
                }
                xSSimpleTypeDeclArray[n3] = (XSSimpleTypeDecl)validatedInfo.memberType;
                ++n3;
            }
            ListDV.ListData listData = new ListDV.ListData(objectArray);
            validatedInfo.actualValue = listData;
            validatedInfo.memberType = null;
            validatedInfo.memberTypes = xSSimpleTypeDeclArray;
            validatedInfo.normalizedValue = string;
            return listData;
        }
        int n4 = 0;
        while (n4 < this.fMemberTypes.length) {
            try {
                Object object3 = this.fMemberTypes[n4].getActualValue(object, validationContext, validatedInfo, true);
                if (validationContext.needFacetChecking() && this.fMemberTypes[n4].fFacetsDefined != 0 && this.fMemberTypes[n4].fFacetsDefined != 16) {
                    this.fMemberTypes[n4].checkFacets(validatedInfo);
                }
                validatedInfo.memberType = this.fMemberTypes[n4];
                return object3;
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                ++n4;
            }
        }
        throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.2", new Object[]{object, this.fTypeName});
    }

    public boolean isEqual(Object object, Object object2) {
        if (object == null) {
            return false;
        }
        return object.equals(object2);
    }

    /*
     * Unable to fully structure code
     */
    public static String normalize(String var0, short var1_1) {
        block8: {
            block7: {
                v0 = var2_2 = var0 == null ? 0 : var0.length();
                if (var2_2 == 0 || var1_1 == 0) {
                    return var0;
                }
                var3_3 = new StringBuffer();
                if (var1_1 != 1) break block7;
                var5_4 = 0;
                while (var5_4 < var2_2) {
                    var4_6 = var0.charAt(var5_4);
                    if (var4_6 != '\t' && var4_6 != '\n' && var4_6 != '\r') {
                        var3_3.append(var4_6);
                    } else {
                        var3_3.append(' ');
                    }
                    ++var5_4;
                }
                break block8;
            }
            var6_8 = true;
            var5_5 = 0;
            while (var5_5 < var2_2) {
                block9: {
                    var4_7 = var0.charAt(var5_5);
                    if (var4_7 == '\t' || var4_7 == '\n' || var4_7 == '\r' || var4_7 == ' ') ** GOTO lbl30
                    var3_3.append(var4_7);
                    var6_8 = false;
                    break block9;
                    while ((var4_7 = var0.charAt(var5_5 + 1)) == '\t' || var4_7 == '\n' || var4_7 == '\r' || var4_7 == ' ') {
                        ++var5_5;
lbl30:
                        // 2 sources

                        if (var5_5 < var2_2 - 1) continue;
                    }
                    if (var5_5 < var2_2 - 1 && !var6_8) {
                        var3_3.append(' ');
                    }
                }
                ++var5_5;
            }
        }
        return var3_3.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected String normalize(Object var1_1, short var2_2) {
        block13: {
            block12: {
                if (var1_1 == null) {
                    return null;
                }
                if ((this.fFacetsDefined & 8) == 0) {
                    var3_3 = XSSimpleTypeDecl.fDVNormalizeType[this.fValidationDV];
                    if (var3_3 == 0) {
                        return var1_1.toString();
                    }
                    if (var3_3 == 1) {
                        return var1_1.toString().trim();
                    }
                }
                if (!(var1_1 instanceof StringBuffer)) {
                    var3_4 = var1_1.toString();
                    return XSSimpleTypeDecl.normalize(var3_4, var2_2);
                }
                var3_5 = (StringBuffer)var1_1;
                var4_6 = var3_5.length();
                if (var4_6 == 0) {
                    return "";
                }
                if (var2_2 == 0) {
                    return var3_5.toString();
                }
                if (var2_2 != 1) break block12;
                var6_7 = 0;
                while (var6_7 < var4_6) {
                    var5_9 = var3_5.charAt(var6_7);
                    if (var5_9 == '\t' || var5_9 == '\n' || var5_9 == '\r') {
                        var3_5.setCharAt(var6_7, ' ');
                    }
                    ++var6_7;
                }
                break block13;
            }
            var7_11 = 0;
            var8_12 = true;
            var6_8 = 0;
            while (var6_8 < var4_6) {
                block14: {
                    var5_10 = var3_5.charAt(var6_8);
                    if (var5_10 == '\t' || var5_10 == '\n' || var5_10 == '\r' || var5_10 == ' ') ** GOTO lbl39
                    var3_5.setCharAt(var7_11++, var5_10);
                    var8_12 = false;
                    break block14;
                    while ((var5_10 = var3_5.charAt(var6_8 + 1)) == '\t' || var5_10 == '\n' || var5_10 == '\r' || var5_10 == ' ') {
                        ++var6_8;
lbl39:
                        // 2 sources

                        if (var6_8 < var4_6 - 1) continue;
                    }
                    if (var6_8 < var4_6 - 1 && !var8_12) {
                        var3_5.setCharAt(var7_11++, ' ');
                    }
                }
                ++var6_8;
            }
            var3_5.setLength(var7_11);
        }
        return var3_5.toString();
    }

    void reportError(String string, Object[] objectArray) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(string, objectArray);
    }

    private String whiteSpaceValue(short s2) {
        return WS_FACET_STRING[s2];
    }

    public short getOrdered() {
        return this.fOrdered;
    }

    public boolean getBounded() {
        return this.fBounded;
    }

    public boolean getFinite() {
        return this.fFinite;
    }

    public boolean getNumeric() {
        return this.fNumeric;
    }

    public boolean isDefinedFacet(short s2) {
        return (this.fFacetsDefined & s2) != 0;
    }

    public short getDefinedFacets() {
        return this.fFacetsDefined;
    }

    public boolean isFixedFacet(short s2) {
        return (this.fFixedFacet & s2) != 0;
    }

    public short getFixedFacets() {
        return this.fFixedFacet;
    }

    public String getLexicalFacetValue(short s2) {
        switch (s2) {
            case 1: {
                return Integer.toString(this.fLength);
            }
            case 2: {
                return Integer.toString(this.fMinLength);
            }
            case 4: {
                return Integer.toString(this.fMaxLength);
            }
            case 16: {
                return WS_FACET_STRING[this.fWhiteSpace];
            }
            case 32: {
                return this.fMaxInclusive.toString();
            }
            case 64: {
                return this.fMaxExclusive.toString();
            }
            case 128: {
                return this.fMinExclusive.toString();
            }
            case 256: {
                return this.fMinInclusive.toString();
            }
            case 512: {
                return Integer.toString(this.fTotalDigits);
            }
            case 1024: {
                return Integer.toString(this.fFractionDigits);
            }
        }
        return null;
    }

    public StringList getLexicalEnumeration() {
        if (this.fEnumeration == null) {
            return null;
        }
        int n2 = this.fEnumeration.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = this.fEnumeration.elementAt(n3).toString();
            ++n3;
        }
        return new StringListImpl(stringArray, n2);
    }

    public StringList getLexicalPattern() {
        String[] stringArray;
        int n2;
        if (this.fPatternType == 0 && this.fPatternStr == null) {
            return null;
        }
        int n3 = n2 = this.fPatternStr == null ? 0 : this.fPatternStr.size();
        if (this.fPatternType == 1) {
            stringArray = new String[n2 + 1];
            stringArray[n2] = "\\c+";
        } else if (this.fPatternType == 2) {
            stringArray = new String[n2 + 1];
            stringArray[n2] = "\\i\\c*";
        } else if (this.fPatternType == 3) {
            stringArray = new String[n2 + 2];
            stringArray[n2] = "\\i\\c*";
            stringArray[n2 + 1] = "[\\i-[:]][\\c-[:]]*";
        } else {
            stringArray = new String[n2];
        }
        int n4 = 0;
        while (n4 < n2) {
            stringArray[n4] = (String)this.fPatternStr.elementAt(n4);
            ++n4;
        }
        return new StringListImpl(stringArray, n2);
    }

    public XSAnnotation getAnnotation() {
        return null;
    }

    private void caclFundamentalFacets() {
        this.setOrdered();
        this.setNumeric();
        this.setBounded();
        this.setCardinality();
    }

    private void setOrdered() {
        if (this.fVariety == 1) {
            this.fOrdered = this.fBase.fOrdered;
        } else if (this.fVariety == 2) {
            this.fOrdered = 0;
        } else if (this.fVariety == 3) {
            int n2 = this.fMemberTypes.length;
            if (n2 == 0) {
                this.fOrdered = 1;
                return;
            }
            short s2 = this.getPrimitiveDV(this.fMemberTypes[0].fValidationDV);
            boolean bl = s2 != 0;
            boolean bl2 = this.fMemberTypes[0].fOrdered == 0;
            int n3 = 1;
            while (n3 < this.fMemberTypes.length && (bl || bl2)) {
                if (bl) {
                    boolean bl3 = bl = s2 == this.getPrimitiveDV(this.fMemberTypes[n3].fValidationDV);
                }
                if (bl2) {
                    bl2 = this.fMemberTypes[n3].fOrdered == 0;
                }
                ++n3;
            }
            this.fOrdered = bl ? this.fMemberTypes[0].fOrdered : (bl2 ? (short)0 : 1);
        }
    }

    private void setNumeric() {
        if (this.fVariety == 1) {
            this.fNumeric = this.fBase.fNumeric;
        } else if (this.fVariety == 2) {
            this.fNumeric = false;
        } else if (this.fVariety == 3) {
            XSSimpleTypeDecl[] xSSimpleTypeDeclArray = this.fMemberTypes;
            int n2 = 0;
            while (n2 < xSSimpleTypeDeclArray.length) {
                if (!xSSimpleTypeDeclArray[n2].getNumeric()) {
                    this.fNumeric = false;
                    return;
                }
                ++n2;
            }
            this.fNumeric = true;
        }
    }

    private void setBounded() {
        if (this.fVariety == 1) {
            this.fBounded = !((this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0 || (this.fFacetsDefined & 0x20) == 0 && (this.fFacetsDefined & 0x40) == 0);
        } else if (this.fVariety == 2) {
            this.fBounded = (this.fFacetsDefined & 1) != 0 || (this.fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 4) != 0;
        } else if (this.fVariety == 3) {
            XSSimpleTypeDecl[] xSSimpleTypeDeclArray = this.fMemberTypes;
            short s2 = 0;
            if (xSSimpleTypeDeclArray.length > 0) {
                s2 = this.getPrimitiveDV(xSSimpleTypeDeclArray[0].fValidationDV);
            }
            int n2 = 0;
            while (n2 < xSSimpleTypeDeclArray.length) {
                if (!xSSimpleTypeDeclArray[n2].getBounded() || s2 != this.getPrimitiveDV(xSSimpleTypeDeclArray[n2].fValidationDV)) {
                    this.fBounded = false;
                    return;
                }
                ++n2;
            }
            this.fBounded = true;
        }
    }

    private boolean specialCardinalityCheck() {
        return this.fBase.fValidationDV == 9 || this.fBase.fValidationDV == 10 || this.fBase.fValidationDV == 11 || this.fBase.fValidationDV == 12 || this.fBase.fValidationDV == 13 || this.fBase.fValidationDV == 14;
    }

    private void setCardinality() {
        if (this.fVariety == 1) {
            this.fFinite = this.fBase.fFinite ? true : ((this.fFacetsDefined & 1) != 0 || (this.fFacetsDefined & 4) != 0 || (this.fFacetsDefined & 0x200) != 0 ? true : (!((this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0 || (this.fFacetsDefined & 0x20) == 0 && (this.fFacetsDefined & 0x40) == 0) ? (this.fFacetsDefined & 0x400) != 0 || this.specialCardinalityCheck() : false));
        } else if (this.fVariety == 2) {
            this.fFinite = (this.fFacetsDefined & 1) != 0 || (this.fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 4) != 0;
        } else if (this.fVariety == 3) {
            XSSimpleTypeDecl[] xSSimpleTypeDeclArray = this.fMemberTypes;
            int n2 = 0;
            while (n2 < xSSimpleTypeDeclArray.length) {
                if (!xSSimpleTypeDeclArray[n2].getFinite()) {
                    this.fFinite = false;
                    return;
                }
                ++n2;
            }
            this.fFinite = true;
        }
    }

    private short getPrimitiveDV(short s2) {
        if (s2 == 20 || s2 == 21 || s2 == 22) {
            return 1;
        }
        if (s2 == 23) {
            return 3;
        }
        return s2;
    }

    public boolean derivedFromType(XSTypeDefinition xSTypeDefinition, short s2) {
        if (xSTypeDefinition == null) {
            return false;
        }
        if (xSTypeDefinition.getBaseType() == xSTypeDefinition) {
            return true;
        }
        XSTypeDefinition xSTypeDefinition2 = this;
        while (xSTypeDefinition2 != xSTypeDefinition && xSTypeDefinition2 != fAnySimpleType) {
            xSTypeDefinition2 = xSTypeDefinition2.getBaseType();
        }
        return xSTypeDefinition2 == xSTypeDefinition;
    }

    public boolean derivedFrom(String string, String string2, short s2) {
        if (string2 == null) {
            return false;
        }
        if (URI_SCHEMAFORSCHEMA.equals(string) && ANY_TYPE.equals(string2)) {
            return true;
        }
        XSTypeDefinition xSTypeDefinition = this;
        while (!(string2.equals(xSTypeDefinition.getName()) && (string == null && xSTypeDefinition.getNamespace() == null || string != null && string.equals(xSTypeDefinition.getNamespace())) || xSTypeDefinition == fAnySimpleType)) {
            xSTypeDefinition = xSTypeDefinition.getBaseType();
        }
        return xSTypeDefinition != fAnySimpleType;
    }

    public void reset() {
        if (this.fIsImmutable) {
            return;
        }
        this.fItemType = null;
        this.fMemberTypes = null;
        this.fTypeName = null;
        this.fTargetNamespace = null;
        this.fFinalSet = 0;
        this.fBase = null;
        this.fVariety = (short)-1;
        this.fValidationDV = (short)-1;
        this.fFacetsDefined = 0;
        this.fFixedFacet = 0;
        this.fWhiteSpace = 0;
        this.fLength = -1;
        this.fMinLength = -1;
        this.fMaxLength = -1;
        this.fTotalDigits = -1;
        this.fFractionDigits = -1;
        this.fPattern = null;
        this.fPatternStr = null;
        this.fEnumeration = null;
        this.fMaxInclusive = null;
        this.fMaxExclusive = null;
        this.fMinExclusive = null;
        this.fMinInclusive = null;
        this.fPatternType = 0;
    }

    public XSNamespaceItem getNamespaceItem() {
        return null;
    }

    public String toString() {
        return this.fTargetNamespace + "," + this.fTypeName;
    }

    class ValidationContextImpl
    implements ValidationContext {
        ValidationContext fExternal;
        NamespaceContext fNSContext;

        ValidationContextImpl(ValidationContext validationContext) {
            this.fExternal = validationContext;
        }

        void setNSContext(NamespaceContext namespaceContext) {
            this.fNSContext = namespaceContext;
        }

        public boolean needFacetChecking() {
            return this.fExternal.needFacetChecking();
        }

        public boolean needExtraChecking() {
            return this.fExternal.needExtraChecking();
        }

        public boolean needToNormalize() {
            return this.fExternal.needToNormalize();
        }

        public boolean isEntityDeclared(String string) {
            return this.fExternal.isEntityDeclared(string);
        }

        public boolean isEntityUnparsed(String string) {
            return this.fExternal.isEntityUnparsed(string);
        }

        public boolean isIdDeclared(String string) {
            return this.fExternal.isIdDeclared(string);
        }

        public void addId(String string) {
            this.fExternal.addId(string);
        }

        public void addIdRef(String string) {
            this.fExternal.addIdRef(string);
        }

        public String getSymbol(String string) {
            return this.fExternal.getSymbol(string);
        }

        public String getURI(String string) {
            if (this.fNSContext == null) {
                return this.fExternal.getURI(string);
            }
            return this.fNSContext.getURI(string);
        }
    }
}

