/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EnvironmentCheck {
    public static final String ERROR = "ERROR.";
    public static final String WARNING = "WARNING.";
    public static final String ERROR_FOUND = "At least one error was found!";
    public static final String VERSION = "version.";
    public static final String FOUNDCLASSES = "foundclasses.";
    public static final String CLASS_PRESENT = "present-unknown-version";
    public static final String CLASS_NOTPRESENT = "not-present";
    public String[] jarNames = new String[]{"xalan.jar", "xalansamples.jar", "xalanj1compat.jar", "xalanservlet.jar", "xerces.jar", "testxsl.jar", "crimson.jar", "lotusxsl.jar", "jaxp.jar", "parser.jar", "dom.jar", "sax.jar", "xml.jar", "xml-apis.jar", "xsltc.jar"};
    protected static Hashtable jarVersions = new Hashtable();
    protected PrintWriter outWriter = new PrintWriter(System.out, true);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$xml$sax$Attributes;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$xalan$xslt$EnvironmentCheck;

    public static void main(String[] args) {
        PrintWriter sendOutputTo = new PrintWriter(System.out, true);
        int i2 = 0;
        while (i2 < args.length) {
            if ("-out".equalsIgnoreCase(args[i2])) {
                if (++i2 < args.length) {
                    try {
                        sendOutputTo = new PrintWriter(new FileWriter(args[i2], true));
                    }
                    catch (Exception e2) {
                        System.err.println("# WARNING: -out " + args[i2] + " threw " + e2.toString());
                    }
                } else {
                    System.err.println("# WARNING: -out argument should have a filename, output sent to console");
                }
            }
            ++i2;
        }
        EnvironmentCheck app = new EnvironmentCheck();
        app.checkEnvironment(sendOutputTo);
    }

    public boolean checkEnvironment(PrintWriter pw) {
        Hashtable hash;
        boolean environmentHasErrors;
        if (null != pw) {
            this.outWriter = pw;
        }
        if (environmentHasErrors = this.writeEnvironmentReport(hash = this.getEnvironmentHash())) {
            this.logMsg("# WARNING: Potential problems found in your environment!");
            this.logMsg("#    Check any 'ERROR' items above against the Xalan FAQs");
            this.logMsg("#    to correct potential problems with your classes/jars");
            this.logMsg("#    http://xml.apache.org/xalan-j/faq.html");
            if (null != this.outWriter) {
                this.outWriter.flush();
            }
            return false;
        }
        this.logMsg("# YAHOO! Your environment seems to be OK.");
        if (null != this.outWriter) {
            this.outWriter.flush();
        }
        return true;
    }

    public Hashtable getEnvironmentHash() {
        Hashtable hash = new Hashtable();
        this.checkJAXPVersion(hash);
        this.checkProcessorVersion(hash);
        this.checkParserVersion(hash);
        this.checkAntVersion(hash);
        this.checkDOMVersion(hash);
        this.checkSAXVersion(hash);
        this.checkSystemProperties(hash);
        return hash;
    }

    protected boolean writeEnvironmentReport(Hashtable h2) {
        if (null == h2) {
            this.logMsg("# ERROR: writeEnvironmentReport called with null Hashtable");
            return false;
        }
        boolean errors = false;
        this.logMsg("#---- BEGIN writeEnvironmentReport($Revision: 1.9 $): Useful stuff found: ----");
        Enumeration enumeration = h2.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            String keyStr = (String)key;
            try {
                if (keyStr.startsWith(FOUNDCLASSES)) {
                    Vector v2 = (Vector)h2.get(keyStr);
                    errors |= this.logFoundJars(v2, keyStr);
                    continue;
                }
                if (keyStr.startsWith(ERROR)) {
                    errors = true;
                }
                this.logMsg(keyStr + "=" + h2.get(keyStr));
            }
            catch (Exception e2) {
                this.logMsg("Reading-" + key + "= threw: " + e2.toString());
            }
        }
        this.logMsg("#----- END writeEnvironmentReport: Useful properties found: -----");
        return errors;
    }

    protected boolean logFoundJars(Vector v2, String desc) {
        if (null == v2 || v2.size() < 1) {
            return false;
        }
        boolean errors = false;
        this.logMsg("#---- BEGIN Listing XML-related jars in: " + desc + " ----");
        int i2 = 0;
        while (i2 < v2.size()) {
            Hashtable subhash = (Hashtable)v2.elementAt(i2);
            Enumeration enumeration = subhash.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                String keyStr = (String)key;
                try {
                    if (keyStr.startsWith(ERROR)) {
                        errors = true;
                    }
                    this.logMsg(keyStr + "=" + subhash.get(keyStr));
                }
                catch (Exception e2) {
                    errors = true;
                    this.logMsg("Reading-" + key + "= threw: " + e2.toString());
                }
            }
            ++i2;
        }
        this.logMsg("#----- END Listing XML-related jars in: " + desc + " -----");
        return errors;
    }

    public void appendEnvironmentReport(Node container, Document factory, Hashtable h2) {
        if (null == container || null == factory) {
            return;
        }
        try {
            Element envCheckNode = factory.createElement("EnvironmentCheck");
            envCheckNode.setAttribute("version", "$Revision: 1.9 $");
            container.appendChild(envCheckNode);
            if (null == h2) {
                Element statusNode = factory.createElement("status");
                statusNode.setAttribute("result", "ERROR");
                statusNode.appendChild(factory.createTextNode("appendEnvironmentReport called with null Hashtable!"));
                envCheckNode.appendChild(statusNode);
                return;
            }
            boolean errors = false;
            Element hashNode = factory.createElement("environment");
            envCheckNode.appendChild(hashNode);
            Enumeration enumeration = h2.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                String keyStr = (String)key;
                try {
                    if (keyStr.startsWith(FOUNDCLASSES)) {
                        Vector v2 = (Vector)h2.get(keyStr);
                        errors |= this.appendFoundJars(hashNode, factory, v2, keyStr);
                        continue;
                    }
                    if (keyStr.startsWith(ERROR)) {
                        errors = true;
                    }
                    Element node = factory.createElement("item");
                    node.setAttribute("key", keyStr);
                    node.appendChild(factory.createTextNode((String)h2.get(keyStr)));
                    hashNode.appendChild(node);
                }
                catch (Exception e2) {
                    errors = true;
                    Element node = factory.createElement("item");
                    node.setAttribute("key", keyStr);
                    node.appendChild(factory.createTextNode("ERROR. Reading " + key + " threw: " + e2.toString()));
                    hashNode.appendChild(node);
                }
            }
            Element statusNode = factory.createElement("status");
            statusNode.setAttribute("result", errors ? "ERROR" : "OK");
            envCheckNode.appendChild(statusNode);
        }
        catch (Exception e2) {
            System.err.println("appendEnvironmentReport threw: " + e2.toString());
            e2.printStackTrace();
        }
    }

    protected boolean appendFoundJars(Node container, Document factory, Vector v2, String desc) {
        if (null == v2 || v2.size() < 1) {
            return false;
        }
        boolean errors = false;
        int i2 = 0;
        while (i2 < v2.size()) {
            Hashtable subhash = (Hashtable)v2.elementAt(i2);
            Enumeration enumeration = subhash.keys();
            while (enumeration.hasMoreElements()) {
                Element node;
                Object key = enumeration.nextElement();
                try {
                    String keyStr = (String)key;
                    if (keyStr.startsWith(ERROR)) {
                        errors = true;
                    }
                    node = factory.createElement("foundJar");
                    node.setAttribute("name", keyStr.substring(0, keyStr.indexOf("-")));
                    node.setAttribute("desc", keyStr.substring(keyStr.indexOf("-") + 1));
                    node.appendChild(factory.createTextNode((String)subhash.get(keyStr)));
                    container.appendChild(node);
                }
                catch (Exception e2) {
                    errors = true;
                    node = factory.createElement("foundJar");
                    node.appendChild(factory.createTextNode("ERROR. Reading " + key + " threw: " + e2.toString()));
                    container.appendChild(node);
                }
            }
            ++i2;
        }
        return errors;
    }

    protected void checkSystemProperties(Hashtable h2) {
        if (null == h2) {
            h2 = new Hashtable<String, Object>();
        }
        try {
            String javaVersion = System.getProperty("java.version");
            h2.put("java.version", javaVersion);
        }
        catch (SecurityException se) {
            h2.put("java.version", "WARNING: SecurityException thrown accessing system version properties");
        }
        try {
            String othercp;
            String cp = System.getProperty("java.class.path");
            h2.put("java.class.path", cp);
            Vector classpathJars = this.checkPathForJars(cp, this.jarNames);
            if (null != classpathJars) {
                h2.put("foundclasses.java.class.path", classpathJars);
            }
            if (null != (othercp = System.getProperty("sun.boot.class.path"))) {
                h2.put("sun.boot.class.path", othercp);
                classpathJars = this.checkPathForJars(othercp, this.jarNames);
                if (null != classpathJars) {
                    h2.put("foundclasses.sun.boot.class.path", classpathJars);
                }
            }
            if (null != (othercp = System.getProperty("java.ext.dirs"))) {
                h2.put("java.ext.dirs", othercp);
                classpathJars = this.checkPathForJars(othercp, this.jarNames);
                if (null != classpathJars) {
                    h2.put("foundclasses.java.ext.dirs", classpathJars);
                }
            }
        }
        catch (SecurityException se2) {
            h2.put("java.class.path", "WARNING: SecurityException thrown accessing system classpath properties");
        }
    }

    protected Vector checkPathForJars(String cp, String[] jars) {
        if (null == cp || null == jars || 0 == cp.length() || 0 == jars.length) {
            return null;
        }
        Vector v2 = new Vector();
        StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String filename = st.nextToken().toLowerCase();
            int i2 = 0;
            while (i2 < jars.length) {
                if (filename.indexOf(jars[i2]) > -1) {
                    Hashtable<String, String> h2;
                    File f2 = new File(filename);
                    if (f2.exists()) {
                        try {
                            h2 = new Hashtable(2);
                            h2.put(jars[i2] + "-path", f2.getAbsolutePath());
                            h2.put(jars[i2] + "-apparent.version", this.getApparentVersion(jars[i2], f2.length()));
                            v2.addElement(h2);
                        }
                        catch (Exception e2) {}
                    } else {
                        h2 = new Hashtable<String, String>(2);
                        h2.put(jars[i2] + "-path", "WARNING. Classpath entry: " + filename + " does not exist");
                        h2.put(jars[i2] + "-apparent.version", CLASS_NOTPRESENT);
                        v2.addElement(h2);
                    }
                }
                ++i2;
            }
        }
        return v2;
    }

    protected String getApparentVersion(String jarName, long jarSize) {
        String foundSize = (String)jarVersions.get(new Long(jarSize));
        if (null != foundSize && foundSize.startsWith(jarName)) {
            return foundSize;
        }
        if ("xerces.jar".equalsIgnoreCase(jarName) || "xalan.jar".equalsIgnoreCase(jarName)) {
            return jarName + " " + WARNING + CLASS_PRESENT;
        }
        return jarName + " " + CLASS_PRESENT;
    }

    protected void checkJAXPVersion(Hashtable h2) {
        if (null == h2) {
            h2 = new Hashtable<String, String>();
        }
        Class[] noArgs = new Class[]{};
        Class clazz = null;
        try {
            clazz = EnvironmentCheck.classForName("javax.xml.parsers.DocumentBuilder");
            Method method = clazz.getMethod("getDOMImplementation", noArgs);
            h2.put("version.JAXP", "1.1");
        }
        catch (Exception e2) {
            if (null != clazz) {
                h2.put("ERROR.version.JAXP", "1.0.1");
                h2.put(ERROR, ERROR_FOUND);
            }
            h2.put("ERROR.version.JAXP", CLASS_NOTPRESENT);
            h2.put(ERROR, ERROR_FOUND);
        }
    }

    protected void checkProcessorVersion(Hashtable h2) {
        Field f2;
        StringBuffer buf;
        Class clazz;
        if (null == h2) {
            h2 = new Hashtable<String, String>();
        }
        try {
            clazz = EnvironmentCheck.classForName("org.apache.xalan.xslt.XSLProcessorVersion");
            buf = new StringBuffer();
            f2 = clazz.getField("PRODUCT");
            buf.append(f2.get(null));
            buf.append(';');
            f2 = clazz.getField("LANGUAGE");
            buf.append(f2.get(null));
            buf.append(';');
            f2 = clazz.getField("S_VERSION");
            buf.append(f2.get(null));
            buf.append(';');
            h2.put("version.xalan1", buf.toString());
        }
        catch (Exception e1) {
            h2.put("version.xalan1", CLASS_NOTPRESENT);
        }
        try {
            clazz = EnvironmentCheck.classForName("org.apache.xalan.processor.XSLProcessorVersion");
            buf = new StringBuffer();
            f2 = clazz.getField("S_VERSION");
            buf.append(f2.get(null));
            h2.put("version.xalan2x", buf.toString());
        }
        catch (Exception e2) {
            h2.put("version.xalan2x", CLASS_NOTPRESENT);
        }
        try {
            Class[] noArgs = new Class[]{};
            Class clazz2 = EnvironmentCheck.classForName("org.apache.xalan.Version");
            Method method = clazz2.getMethod("getVersion", noArgs);
            Object returnValue = method.invoke(null, new Object[0]);
            h2.put("version.xalan2_2", (String)returnValue);
        }
        catch (Exception e2) {
            h2.put("version.xalan2_2", CLASS_NOTPRESENT);
        }
    }

    protected void checkParserVersion(Hashtable h2) {
        String parserVersion;
        Field f2;
        Class clazz;
        if (null == h2) {
            h2 = new Hashtable<String, String>();
        }
        try {
            clazz = EnvironmentCheck.classForName("org.apache.xerces.framework.Version");
            f2 = clazz.getField("fVersion");
            parserVersion = (String)f2.get(null);
            h2.put("version.xerces1", parserVersion);
        }
        catch (Exception e2) {
            h2.put("version.xerces1", CLASS_NOTPRESENT);
        }
        try {
            clazz = EnvironmentCheck.classForName("org.apache.xerces.impl.Version");
            f2 = clazz.getField("fVersion");
            parserVersion = (String)f2.get(null);
            h2.put("version.xerces2", parserVersion);
        }
        catch (Exception e3) {
            h2.put("version.xerces2", CLASS_NOTPRESENT);
        }
        try {
            clazz = EnvironmentCheck.classForName("org.apache.crimson.parser.Parser2");
            h2.put("version.crimson", CLASS_PRESENT);
        }
        catch (Exception e4) {
            h2.put("version.crimson", CLASS_NOTPRESENT);
        }
    }

    protected void checkAntVersion(Hashtable h2) {
        if (null == h2) {
            h2 = new Hashtable<String, String>();
        }
        try {
            Class[] noArgs = new Class[]{};
            Class clazz = EnvironmentCheck.classForName("org.apache.tools.ant.Main");
            Method method = clazz.getMethod("getAntVersion", noArgs);
            Object returnValue = method.invoke(null, new Object[0]);
            h2.put("version.ant", (String)returnValue);
        }
        catch (Exception e2) {
            h2.put("version.ant", CLASS_NOTPRESENT);
        }
    }

    protected void checkDOMVersion(Hashtable h2) {
        if (null == h2) {
            h2 = new Hashtable<String, String>();
        }
        Class[] twoStringArgs = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EnvironmentCheck.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EnvironmentCheck.class$("java.lang.String")) : class$java$lang$String};
        try {
            Class clazz = EnvironmentCheck.classForName("org.w3c.dom.Document");
            Method method = clazz.getMethod("createElementNS", twoStringArgs);
            h2.put("version.DOM", "2.0");
            try {
                clazz = EnvironmentCheck.classForName("org.w3c.dom.Node");
                method = clazz.getMethod("supported", twoStringArgs);
                h2.put("ERROR.version.DOM.draftlevel", "2.0wd");
                h2.put(ERROR, ERROR_FOUND);
            }
            catch (Exception e2) {
                try {
                    clazz = EnvironmentCheck.classForName("org.w3c.dom.Node");
                    method = clazz.getMethod("isSupported", twoStringArgs);
                    h2.put("version.DOM.draftlevel", "2.0fd");
                }
                catch (Exception e3) {
                    h2.put("ERROR.version.DOM.draftlevel", "2.0unknown");
                    h2.put(ERROR, ERROR_FOUND);
                }
            }
        }
        catch (Exception e2) {
            h2.put("ERROR.version.DOM", "ERROR attempting to load DOM level 2 class: " + e2.toString());
            h2.put(ERROR, ERROR_FOUND);
        }
    }

    protected void checkSAXVersion(Hashtable h2) {
        if (null == h2) {
            h2 = new Hashtable<String, String>();
        }
        Class[] oneStringArg = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EnvironmentCheck.class$("java.lang.String")) : class$java$lang$String};
        Class[] attributesArg = new Class[]{class$org$xml$sax$Attributes == null ? (class$org$xml$sax$Attributes = EnvironmentCheck.class$("org.xml.sax.Attributes")) : class$org$xml$sax$Attributes};
        try {
            Class clazz = EnvironmentCheck.classForName("org.xml.sax.helpers.AttributesImpl");
            Method method = clazz.getMethod("setAttributes", attributesArg);
            h2.put("version.SAX", "2.0");
        }
        catch (Exception e2) {
            h2.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + e2.toString());
            h2.put(ERROR, ERROR_FOUND);
            try {
                Class clazz = EnvironmentCheck.classForName("org.xml.sax.XMLReader");
                Method method = clazz.getMethod("parse", oneStringArg);
                h2.put("version.SAX-backlevel", "2.0beta2-or-earlier");
            }
            catch (Exception e22) {
                h2.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + e2.toString());
                h2.put(ERROR, ERROR_FOUND);
                try {
                    Class clazz = EnvironmentCheck.classForName("org.xml.sax.Parser");
                    Method method = clazz.getMethod("parse", oneStringArg);
                    h2.put("version.SAX-backlevel", "1.0");
                }
                catch (Exception e3) {
                    h2.put("ERROR.version.SAX-backlevel", "ERROR attempting to load SAX version 1 class: " + e3.toString());
                }
            }
        }
    }

    protected static Class classForName(String className) throws ClassNotFoundException {
        ClassLoader classLoader = EnvironmentCheck.findClassLoader();
        if (classLoader == null) {
            return Class.forName(className);
        }
        return classLoader.loadClass(className);
    }

    protected static ClassLoader findClassLoader() throws ClassNotFoundException {
        Object classLoader = null;
        Method m2 = null;
        try {
            m2 = (class$java$lang$Thread == null ? (class$java$lang$Thread = EnvironmentCheck.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException e2) {
            return (class$org$apache$xalan$xslt$EnvironmentCheck == null ? (class$org$apache$xalan$xslt$EnvironmentCheck = EnvironmentCheck.class$("org.apache.xalan.xslt.EnvironmentCheck")) : class$org$apache$xalan$xslt$EnvironmentCheck).getClassLoader();
        }
        try {
            return (ClassLoader)m2.invoke((Object)Thread.currentThread(), null);
        }
        catch (Exception e3) {
            throw new RuntimeException(e3.toString());
        }
    }

    protected void logMsg(String s2) {
        this.outWriter.println(s2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        jarVersions.put(new Long(857192L), "xalan.jar from xalan-j_1_1");
        jarVersions.put(new Long(440237L), "xalan.jar from xalan-j_1_2");
        jarVersions.put(new Long(436094L), "xalan.jar from xalan-j_1_2_1");
        jarVersions.put(new Long(426249L), "xalan.jar from xalan-j_1_2_2");
        jarVersions.put(new Long(702536L), "xalan.jar from xalan-j_2_0_0");
        jarVersions.put(new Long(720930L), "xalan.jar from xalan-j_2_0_1");
        jarVersions.put(new Long(732330L), "xalan.jar from xalan-j_2_1_0");
        jarVersions.put(new Long(872241L), "xalan.jar from xalan-j_2_2_D10");
        jarVersions.put(new Long(882739L), "xalan.jar from xalan-j_2_2_D11");
        jarVersions.put(new Long(857171L), "xalan.jar from lotusxsl-j_1_0_1");
        jarVersions.put(new Long(802165L), "xalan.jar from lotusxsl-j_2_0_0");
        jarVersions.put(new Long(857692L), "xalan.jar from lotusxsl-j_2_2");
        jarVersions.put(new Long(424490L), "xalan.jar from Xerces Tools releases - ERROR:DO NOT USE!");
        jarVersions.put(new Long(1591855L), "xerces.jar from xalan-j_1_1 from xerces-1...");
        jarVersions.put(new Long(1498679L), "xerces.jar from xalan-j_1_2 from xerces-1_2_0.bin");
        jarVersions.put(new Long(1484896L), "xerces.jar from xalan-j_1_2_1 from xerces-1_2_1.bin");
        jarVersions.put(new Long(804460L), "xerces.jar from xalan-j_1_2_2 from xerces-1_2_2.bin");
        jarVersions.put(new Long(1499244L), "xerces.jar from xalan-j_2_0_0 from xerces-1_2_3.bin");
        jarVersions.put(new Long(1605266L), "xerces.jar from xalan-j_2_0_1 from xerces-1_3_0.bin");
        jarVersions.put(new Long(904030L), "xerces.jar from xalan-j_2_1_0 from xerces-1_4.bin");
        jarVersions.put(new Long(1190776L), "xerces.jar from lotusxsl_1_0_1 apparently-from xerces-1_0_3.bin");
        jarVersions.put(new Long(1489400L), "xerces.jar from lotusxsl-j_2_0_0 from XML4J-3_1_1");
        jarVersions.put(new Long(1787796L), "xerces.jar from lotusxsl-j_2_2 or xerces-1_4_1.bin");
        jarVersions.put(new Long(904030L), "xerces.jar from xerces-1_4_0.bin");
        jarVersions.put(new Long(1802885L), "xerces.jar from xerces-1_4_2.bin");
        jarVersions.put(new Long(1734594L), "xerces.jar from Xerces-J-bin.2.0.0.beta3");
        jarVersions.put(new Long(1808883L), "xerces.jar from xalan-j_2_2_D10,D11,D12 or xerces-1_4_3.bin");
        jarVersions.put(new Long(1803877L), "xerces.jar from XML4J-3_2_1");
        jarVersions.put(new Long(37485L), "xalanj1compat.jar from xalan-j_2_0_0");
        jarVersions.put(new Long(38100L), "xalanj1compat.jar from xalan-j_2_0_1");
        jarVersions.put(new Long(18779L), "xalanservlet.jar from xalan-j_2_0_0");
        jarVersions.put(new Long(21453L), "xalanservlet.jar from xalan-j_2_0_1");
        jarVersions.put(new Long(5618L), "jaxp.jar from jaxp1.0.1");
        jarVersions.put(new Long(136133L), "parser.jar from jaxp1.0.1");
        jarVersions.put(new Long(28404L), "jaxp.jar from jaxp-1.1");
        jarVersions.put(new Long(187162L), "crimson.jar from jaxp-1.1");
        jarVersions.put(new Long(801714L), "xalan.jar from jaxp-1.1");
        jarVersions.put(new Long(196399L), "crimson.jar from crimson-1.1.1");
        jarVersions.put(new Long(33323L), "jaxp.jar from crimson-1.1.1 or jakarta-ant-1.4.1b1");
        jarVersions.put(new Long(152717L), "crimson.jar from crimson-1.1.2beta2");
        jarVersions.put(new Long(88143L), "xml-apis.jar from crimson-1.1.2beta2");
        jarVersions.put(new Long(206384L), "crimson.jar from crimson-1.1.3 or jakarta-ant-1.4.1b1");
        jarVersions.put(new Long(136198L), "parser.jar from jakarta-ant-1.3 or 1.2");
        jarVersions.put(new Long(5537L), "jaxp.jar from jakarta-ant-1.3 or 1.2");
        jarVersions.put(new Long(120274L), "lotusxsl.jar from lotusxsl-0_16_4");
        jarVersions.put(new Long(120293L), "lotusxsl.jar from lotusxsl-0_16_5");
        jarVersions.put(new Long(283777L), "lotusxsl.jar from lotusxsl-0_17_2");
        jarVersions.put(new Long(305577L), "lotusxsl.jar from lotusxsl-0_17_3");
        jarVersions.put(new Long(304500L), "lotusxsl.jar from lotusxsl-0_17_4");
        jarVersions.put(new Long(714959L), "lotusxsl.jar from lotusxsl-0_18_1");
        jarVersions.put(new Long(717674L), "lotusxsl.jar from lotusxsl-0_18_2");
        jarVersions.put(new Long(752343L), "lotusxsl.jar from lotusxsl-0_18_3");
        jarVersions.put(new Long(907101L), "lotusxsl.jar from lotusxsl-0_18_4");
    }
}

