/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xalan.transformer.KeyIterator;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.objects.XObject;

public class KeyWalker
extends AxesWalker {
    transient int m_nextAttr;
    transient boolean m_foundAttrs;
    XMLString m_lookupKey;

    public KeyWalker(LocPathIterator locPathIterator) {
        super(locPathIterator, 5);
    }

    public void setRoot(int root) {
        this.m_nextAttr = -1;
        this.m_foundAttrs = false;
        super.setRoot(root);
    }

    protected int getNextNode() {
        int next;
        int currentNode = this.getCurrentNode();
        DTM dtm = this.m_lpi.getXPathContext().getDTM(currentNode);
        if (!this.m_foundAttrs) {
            this.m_nextAttr = dtm.getFirstAttribute(currentNode);
            this.m_foundAttrs = true;
            if (-1 != this.m_nextAttr) {
                return this.m_nextAttr;
            }
        } else if (-1 != this.m_nextAttr) {
            this.m_nextAttr = dtm.getNextAttribute(this.m_nextAttr);
            if (-1 != this.m_nextAttr) {
                return this.m_nextAttr;
            }
        }
        if (-1 != (next = super.getNextNode())) {
            this.m_foundAttrs = false;
        }
        return next;
    }

    /*
     * WARNING - void declaration
     */
    public short acceptNode(int testNode) {
        boolean foundKey = false;
        KeyIterator ki = (KeyIterator)this.m_lpi;
        Vector keys = ki.getKeyDeclarations();
        QName name = ki.getName();
        try {
            XMLString lookupKey = this.m_lookupKey;
            int nDeclarations = keys.size();
            int i2 = 0;
            while (i2 < nDeclarations) {
                KeyDeclaration kd = (KeyDeclaration)keys.elementAt(i2);
                if (kd.getName().equals(name)) {
                    foundKey = true;
                    ki.getXPathContext().setNamespaceContext(ki.getPrefixResolver());
                    double score = kd.getMatch().getMatchScore(ki.getXPathContext(), testNode);
                    kd.getMatch();
                    if (score != Double.NEGATIVE_INFINITY) {
                        XObject xuse = kd.getUse().execute(ki.getXPathContext(), testNode, ki.getPrefixResolver());
                        if (xuse.getType() != 4) {
                            XMLString exprResult = xuse.xstr();
                            ((KeyIterator)this.m_lpi).addRefNode(exprResult, testNode);
                            if (lookupKey.equals(exprResult)) {
                                return 1;
                            }
                        } else {
                            int useNode;
                            DTMIterator nl = xuse.iter();
                            short result = -1;
                            while (-1 != (useNode = nl.nextNode())) {
                                void var14_14;
                                DTM dtm = this.getDTM((int)var14_14);
                                XMLString exprResult = dtm.getStringValue((int)var14_14);
                                ((KeyIterator)this.m_lpi).addRefNode(exprResult, testNode);
                                if (null == exprResult || !lookupKey.equals(exprResult)) continue;
                                result = 1;
                            }
                            if (-1 != result) {
                                return result;
                            }
                        }
                    }
                }
                ++i2;
            }
        }
        catch (TransformerException se) {
            // empty catch block
        }
        if (!foundKey) {
            throw new RuntimeException(XSLMessages.createMessage(58, new Object[]{name.getLocalName()}));
        }
        return 2;
    }

    public int nextNode() {
        int node = super.nextNode();
        if (node == -1) {
            ((KeyIterator)this.m_lpi).setLookForMoreNodes(false);
        }
        return node;
    }
}

