/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;

public class StylesheetComposed
extends Stylesheet {
    private int m_importNumber = -1;
    private int m_importCountComposed;
    private transient Vector m_includesComposed;

    public StylesheetComposed(Stylesheet parent) {
        super(parent);
    }

    public boolean isAggregatedType() {
        return true;
    }

    public void recompose(Vector recomposableElements) throws TransformerException {
        this.recomposeImports();
        this.recomposeIncludes(this);
        int n2 = this.getIncludeCountComposed();
        int i2 = -1;
        while (i2 < n2) {
            Stylesheet included = this.getIncludeComposed(i2);
            int s2 = included.getOutputCount();
            int j2 = 0;
            while (j2 < s2) {
                recomposableElements.addElement(included.getOutput(j2));
                ++j2;
            }
            s2 = included.getAttributeSetCount();
            int j3 = 0;
            while (j3 < s2) {
                recomposableElements.addElement(included.getAttributeSet(j3));
                ++j3;
            }
            s2 = included.getDecimalFormatCount();
            int j4 = 0;
            while (j4 < s2) {
                recomposableElements.addElement(included.getDecimalFormat(j4));
                ++j4;
            }
            s2 = included.getKeyCount();
            int j5 = 0;
            while (j5 < s2) {
                recomposableElements.addElement(included.getKey(j5));
                ++j5;
            }
            s2 = included.getNamespaceAliasCount();
            int j6 = 0;
            while (j6 < s2) {
                recomposableElements.addElement(included.getNamespaceAlias(j6));
                ++j6;
            }
            s2 = included.getTemplateCount();
            int j7 = 0;
            while (j7 < s2) {
                recomposableElements.addElement(included.getTemplate(j7));
                ++j7;
            }
            s2 = included.getVariableOrParamCount();
            int j8 = 0;
            while (j8 < s2) {
                recomposableElements.addElement(included.getVariableOrParam(j8));
                ++j8;
            }
            s2 = included.getStripSpaceCount();
            int j9 = 0;
            while (j9 < s2) {
                recomposableElements.addElement(included.getStripSpace(j9));
                ++j9;
            }
            s2 = included.getPreserveSpaceCount();
            int j10 = 0;
            while (j10 < s2) {
                recomposableElements.addElement(included.getPreserveSpace(j10));
                ++j10;
            }
            ++i2;
        }
    }

    void recomposeImports() {
        this.m_importNumber = this.getStylesheetRoot().getImportNumber(this);
        StylesheetRoot root = this.getStylesheetRoot();
        int globalImportCount = root.getGlobalImportCount();
        this.m_importCountComposed = globalImportCount - this.m_importNumber - 1;
    }

    public StylesheetComposed getImportComposed(int i2) throws ArrayIndexOutOfBoundsException {
        StylesheetRoot root = this.getStylesheetRoot();
        return root.getGlobalImport(1 + this.m_importNumber + i2);
    }

    public int getImportCountComposed() {
        return this.m_importCountComposed;
    }

    void recomposeIncludes(Stylesheet including) {
        int n2 = including.getIncludeCount();
        if (n2 > 0) {
            if (null == this.m_includesComposed) {
                this.m_includesComposed = new Vector();
            }
            int i2 = 0;
            while (i2 < n2) {
                Stylesheet included = including.getInclude(i2);
                this.m_includesComposed.addElement(included);
                this.recomposeIncludes(included);
                ++i2;
            }
        }
    }

    public Stylesheet getIncludeComposed(int i2) throws ArrayIndexOutOfBoundsException {
        if (-1 == i2) {
            return this;
        }
        if (null == this.m_includesComposed) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Stylesheet)this.m_includesComposed.elementAt(i2);
    }

    public int getIncludeCountComposed() {
        return null != this.m_includesComposed ? this.m_includesComposed.size() : 0;
    }

    public void recomposeTemplates(boolean flushFirst) throws TransformerException {
    }
}

