/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.Encodings;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;

public class OutputProperties
extends ElemTemplateElement
implements Cloneable {
    static final String S_XSLT_PREFIX = "xslt.output.";
    static final int S_XSLT_PREFIX_LEN = "xslt.output.".length();
    static final String S_XALAN_PREFIX = "org.apache.xslt.";
    static final int S_XALAN_PREFIX_LEN = "org.apache.xslt.".length();
    static final String S_BUILTIN_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xslt}";
    private transient Hashtable m_propertiesLevels;
    private Properties m_properties = null;
    public static String S_KEY_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    public static String S_KEY_CONTENT_HANDLER = "{http://xml.apache.org/xslt}content-handler";
    public static String S_KEY_ENTITIES = "{http://xml.apache.org/xslt}entities";
    public static String S_USE_URL_ESCAPING = "{http://xml.apache.org/xslt}use-url-escaping";
    public static String S_OMIT_META_TAG = "{http://xml.apache.org/xslt}omit-meta-tag";
    private static Properties m_xml_properties = null;
    private static Properties m_html_properties = null;
    private static Properties m_text_properties = null;
    private static Integer m_synch_object = new Integer(1);
    private static final Class[] NO_CLASSES = new Class[0];
    private static final Object[] NO_OBJS = new Object[0];
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$xalan$templates$OutputProperties;

    public OutputProperties() {
        this("xml");
    }

    public OutputProperties(Properties defaults) {
        this.m_properties = new Properties(defaults);
    }

    public OutputProperties(String method) {
        this.m_properties = new Properties(OutputProperties.getDefaultMethodProperties(method));
    }

    private static String fixupPropertyString(String s2, boolean doClipping) {
        int index;
        if (doClipping && s2.startsWith(S_XSLT_PREFIX)) {
            s2 = s2.substring(S_XSLT_PREFIX_LEN);
        }
        if (s2.startsWith(S_XALAN_PREFIX)) {
            s2 = S_BUILTIN_EXTENSIONS_UNIVERSAL + s2.substring(S_XALAN_PREFIX_LEN);
        }
        if ((index = s2.indexOf("\\u003a")) > 0) {
            String temp = s2.substring(index + 6);
            s2 = s2.substring(0, index) + ":" + temp;
        }
        return s2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadPropertiesFile(String resourceName, Properties defaults) throws IOException {
        InputStream is;
        Properties props;
        block21: {
            props = new Properties(defaults);
            is = null;
            BufferedInputStream bis = null;
            try {
                try {
                    try {
                        Method getCCL = (class$java$lang$Thread == null ? (class$java$lang$Thread = OutputProperties.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", NO_CLASSES);
                        if (getCCL != null) {
                            ClassLoader contextClassLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), NO_OBJS);
                            is = contextClassLoader.getResourceAsStream("org/apache/xalan/templates/" + resourceName);
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (is == null) {
                        is = (class$org$apache$xalan$templates$OutputProperties == null ? (class$org$apache$xalan$templates$OutputProperties = OutputProperties.class$("org.apache.xalan.templates.OutputProperties")) : class$org$apache$xalan$templates$OutputProperties).getResourceAsStream(resourceName);
                    }
                    bis = new BufferedInputStream(is);
                    props.load(bis);
                }
                catch (IOException ioe) {
                    if (defaults == null) {
                        throw ioe;
                    }
                    throw new WrappedRuntimeException(XSLMessages.createMessage(143, new Object[]{resourceName}), ioe);
                }
                catch (SecurityException se) {
                    if (defaults == null) {
                        throw se;
                    }
                    throw new WrappedRuntimeException(XSLMessages.createMessage(143, new Object[]{resourceName}), se);
                }
                Object var8_10 = null;
                if (bis == null) break block21;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (bis != null) {
                    bis.close();
                }
                if (is != null) {
                    is.close();
                }
                throw throwable;
            }
            bis.close();
        }
        if (is != null) {
            is.close();
        }
        Enumeration keys = ((Hashtable)((Properties)((Hashtable)props).clone())).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = null;
            try {
                value = System.getProperty(key);
            }
            catch (SecurityException se) {
                // empty catch block
            }
            if (value == null) {
                value = (String)((Hashtable)props).get(key);
            }
            String newKey = OutputProperties.fixupPropertyString(key, true);
            String newValue = null;
            try {
                newValue = System.getProperty(newKey);
            }
            catch (SecurityException se) {
                // empty catch block
            }
            newValue = newValue == null ? OutputProperties.fixupPropertyString(value, false) : OutputProperties.fixupPropertyString(newValue, false);
            if (key == newKey && value == newValue) continue;
            ((Hashtable)props).remove(key);
            ((Hashtable)props).put(newKey, newValue);
        }
        return props;
    }

    public static Properties getDefaultMethodProperties(String method) {
        String fileName = null;
        Properties defaultProperties = null;
        try {
            Integer n2 = m_synch_object;
            synchronized (n2) {
                if (null == m_xml_properties) {
                    fileName = "output_xml.properties";
                    m_xml_properties = OutputProperties.loadPropertiesFile(fileName, null);
                }
            }
            if (method.equals("xml")) {
                defaultProperties = m_xml_properties;
            } else if (method.equals("html")) {
                if (null == m_html_properties) {
                    fileName = "output_html.properties";
                    m_html_properties = OutputProperties.loadPropertiesFile(fileName, m_xml_properties);
                }
                defaultProperties = m_html_properties;
            } else if (method.equals("text")) {
                if (null == m_text_properties && null == (m_text_properties = OutputProperties.loadPropertiesFile(fileName = "output_text.properties", m_xml_properties)).getProperty("encoding")) {
                    String mimeEncoding = Encodings.getMimeEncoding(null);
                    ((Hashtable)m_text_properties).put("encoding", mimeEncoding);
                }
                defaultProperties = m_text_properties;
            } else {
                defaultProperties = m_xml_properties;
            }
        }
        catch (IOException ioe) {
            throw new WrappedRuntimeException("Output method is " + method + " could not load " + fileName + " (check CLASSPATH)", ioe);
        }
        return defaultProperties;
    }

    public Object clone() {
        try {
            OutputProperties cloned = (OutputProperties)super.clone();
            cloned.m_properties = (Properties)((Hashtable)cloned.m_properties).clone();
            return cloned;
        }
        catch (CloneNotSupportedException e2) {
            return null;
        }
    }

    public void setProperty(QName key, String value) {
        this.setProperty(key.toNamespacedString(), value);
    }

    public void setProperty(String key, String value) {
        if (key.equals("method")) {
            this.setMethodDefaults(value);
        }
        ((Hashtable)this.m_properties).put(key, value);
    }

    public String getProperty(QName key) {
        return this.m_properties.getProperty(key.toNamespacedString());
    }

    public String getProperty(String key) {
        return this.m_properties.getProperty(key);
    }

    public void setBooleanProperty(QName key, boolean value) {
        ((Hashtable)this.m_properties).put(key.toNamespacedString(), value ? "yes" : "no");
    }

    public void setBooleanProperty(String key, boolean value) {
        ((Hashtable)this.m_properties).put(key, value ? "yes" : "no");
    }

    public boolean getBooleanProperty(QName key) {
        return this.getBooleanProperty(key.toNamespacedString());
    }

    public boolean getBooleanProperty(String key) {
        return OutputProperties.getBooleanProperty(key, this.m_properties);
    }

    public static boolean getBooleanProperty(String key, Properties props) {
        String s2 = props.getProperty(key);
        return null != s2 && s2.equals("yes");
    }

    public void setIntProperty(QName key, int value) {
        this.setIntProperty(key.toNamespacedString(), value);
    }

    public void setIntProperty(String key, int value) {
        ((Hashtable)this.m_properties).put(key, Integer.toString(value));
    }

    public int getIntProperty(QName key) {
        return this.getIntProperty(key.toNamespacedString());
    }

    public int getIntProperty(String key) {
        return OutputProperties.getIntProperty(key, this.m_properties);
    }

    public static int getIntProperty(String key, Properties props) {
        String s2 = props.getProperty(key);
        if (null == s2) {
            return 0;
        }
        return Integer.parseInt(s2);
    }

    public void setQNameProperty(QName key, QName value) {
        this.setQNameProperty(key.toNamespacedString(), value);
    }

    public void setMethodDefaults(String method) {
        String defaultMethod = this.m_properties.getProperty("method");
        if (null == defaultMethod || !defaultMethod.equals(method)) {
            Properties savedProps = this.m_properties;
            Properties newDefaults = OutputProperties.getDefaultMethodProperties(method);
            this.m_properties = new Properties(newDefaults);
            this.copyFrom(savedProps, false);
        }
    }

    public void setQNameProperty(String key, QName value) {
        this.setProperty(key, value.toNamespacedString());
    }

    public QName getQNameProperty(QName key) {
        return this.getQNameProperty(key.toNamespacedString());
    }

    public QName getQNameProperty(String key) {
        return OutputProperties.getQNameProperty(key, this.m_properties);
    }

    public static QName getQNameProperty(String key, Properties props) {
        String s2 = props.getProperty(key);
        if (null != s2) {
            return QName.getQNameFromString(s2);
        }
        return null;
    }

    public void setQNameProperties(QName key, Vector v2) {
        this.setQNameProperties(key.toNamespacedString(), v2);
    }

    public void setQNameProperties(String key, Vector v2) {
        int s2 = v2.size();
        FastStringBuffer fsb = new FastStringBuffer(9, 9);
        int i2 = 0;
        while (i2 < s2) {
            QName qname = (QName)v2.elementAt(i2);
            fsb.append(qname.toNamespacedString());
            if (i2 < s2 - 1) {
                fsb.append(' ');
            }
            ++i2;
        }
        ((Hashtable)this.m_properties).put(key, fsb.toString());
    }

    public Vector getQNameProperties(QName key) {
        return this.getQNameProperties(key.toNamespacedString());
    }

    public Vector getQNameProperties(String key) {
        return OutputProperties.getQNameProperties(key, this.m_properties);
    }

    public static Vector getQNameProperties(String key, Properties props) {
        block6: {
            String s2 = props.getProperty(key);
            if (null == s2) break block6;
            Vector<QName> v2 = new Vector<QName>();
            int l2 = s2.length();
            boolean inCurly = false;
            FastStringBuffer buf = new FastStringBuffer();
            int i2 = 0;
            while (i2 < l2) {
                block9: {
                    char c2;
                    block8: {
                        block7: {
                            c2 = s2.charAt(i2);
                            if (!Character.isWhitespace(c2)) break block7;
                            if (inCurly) break block8;
                            if (buf.length() > 0) {
                                QName qname = QName.getQNameFromString(buf.toString());
                                v2.addElement(qname);
                                buf.reset();
                            }
                            break block9;
                        }
                        if ('{' == c2) {
                            inCurly = true;
                        } else if ('}' == c2) {
                            inCurly = false;
                        }
                    }
                    buf.append(c2);
                }
                ++i2;
            }
            if (buf.length() > 0) {
                QName qname = QName.getQNameFromString(buf.toString());
                v2.addElement(qname);
                buf.reset();
            }
            return v2;
        }
        return null;
    }

    public void recompose(StylesheetRoot root) throws TransformerException {
        root.recomposeOutput(this);
    }

    public void compose(StylesheetRoot sroot) throws TransformerException {
        super.compose(sroot);
        this.m_propertiesLevels = null;
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public void copyFrom(Properties src) {
        this.copyFrom(src, true);
    }

    public void copyFrom(Properties src, boolean shouldResetDefaults) {
        Enumeration enumeration = ((Hashtable)src).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Object oldValue = ((Hashtable)this.m_properties).get(key);
            if (null == oldValue) {
                String val = (String)((Hashtable)src).get(key);
                if (shouldResetDefaults && key.equals("method")) {
                    this.setMethodDefaults(val);
                }
                ((Hashtable)this.m_properties).put(key, val);
                continue;
            }
            if (!key.equals("cdata-section-elements")) continue;
            ((Hashtable)this.m_properties).put(key, (String)oldValue + " " + (String)((Hashtable)src).get(key));
        }
    }

    public void copyFrom(OutputProperties opsrc) throws TransformerException {
        this.checkDuplicates(opsrc);
        this.copyFrom(opsrc.getProperties());
    }

    private void checkDuplicates(OutputProperties newProps) throws TransformerException {
        if (null == this.m_propertiesLevels) {
            this.m_propertiesLevels = new Hashtable();
        }
        int newPrecedence = newProps.getStylesheetComposed().getImportCountComposed();
        Properties p2 = newProps.getProperties();
        Enumeration enumeration = ((Hashtable)p2).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (key.equals("cdata-section-elements")) continue;
            Integer oldPrecedence = (Integer)this.m_propertiesLevels.get(key);
            if (null == oldPrecedence) {
                this.m_propertiesLevels.put(key, new Integer(newPrecedence));
                continue;
            }
            if (newPrecedence < oldPrecedence) continue;
            String oldValue = (String)((Hashtable)this.m_properties).get(key);
            String newValue = (String)((Hashtable)newProps.m_properties).get(key);
            if ((oldValue != null || newValue == null) && oldValue.equals(newValue)) continue;
            String msg = key + " can not be multiply defined at the same " + "import level! Old value = " + oldValue + "; New value = " + newValue;
            throw new TransformerException(msg, newProps);
        }
    }

    public boolean isLegalPropertyKey(String key) {
        return key.equals("cdata-section-elements") || key.equals("doctype-public") || key.equals("doctype-system") || key.equals("encoding") || key.equals("indent") || key.equals("media-type") || key.equals("method") || key.equals("omit-xml-declaration") || key.equals("standalone") || key.equals("version") || key.length() > 0 && key.charAt(0) == '{';
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

