/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.AVTPart;
import org.apache.xalan.templates.AVTPartSimple;
import org.apache.xalan.templates.AVTPartXPath;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.StringBufferPool;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.xml.sax.SAXException;

public class AVT
implements Serializable {
    private String m_simpleString;
    private Vector m_parts;
    private String m_rawName;
    private String m_name;
    private String m_uri;

    public String getRawName() {
        return this.m_rawName;
    }

    public void setRawName(String rawName) {
        this.m_rawName = rawName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getURI() {
        return this.m_uri;
    }

    public void setURI(String uri) {
        this.m_uri = uri;
    }

    public AVT(StylesheetHandler handler, String uri, String name, String rawName, String stringedValue) throws TransformerException {
        block32: {
            int nTokens;
            StringTokenizer tokenizer;
            block31: {
                this.m_simpleString = null;
                this.m_parts = null;
                this.m_uri = uri;
                this.m_name = name;
                this.m_rawName = rawName;
                tokenizer = new StringTokenizer(stringedValue, "{}\"'", true);
                nTokens = tokenizer.countTokens();
                if (nTokens >= 2) break block31;
                this.m_simpleString = stringedValue;
                break block32;
            }
            FastStringBuffer buffer = StringBufferPool.get();
            FastStringBuffer exprBuffer = StringBufferPool.get();
            try {
                this.m_parts = new Vector(nTokens + 1);
                String t2 = null;
                String lookahead = null;
                String error = null;
                while (tokenizer.hasMoreTokens()) {
                    block30: {
                        block33: {
                            if (lookahead != null) {
                                t2 = lookahead;
                                lookahead = null;
                            } else {
                                t2 = tokenizer.nextToken();
                            }
                            if (t2.length() != 1) break block33;
                            switch (t2.charAt(0)) {
                                case '\"': 
                                case '\'': {
                                    buffer.append(t2);
                                    break;
                                }
                                case '{': {
                                    try {
                                        lookahead = tokenizer.nextToken();
                                        if (lookahead.equals("{")) {
                                            buffer.append(lookahead);
                                            lookahead = null;
                                            break;
                                        }
                                        if (buffer.length() > 0) {
                                            this.m_parts.addElement(new AVTPartSimple(buffer.toString()));
                                            buffer.setLength(0);
                                        }
                                        exprBuffer.setLength(0);
                                        while (null != lookahead) {
                                            if (lookahead.length() == 1) {
                                                switch (lookahead.charAt(0)) {
                                                    case '\"': 
                                                    case '\'': {
                                                        exprBuffer.append(lookahead);
                                                        String quote = lookahead;
                                                        lookahead = tokenizer.nextToken();
                                                        while (!lookahead.equals(quote)) {
                                                            exprBuffer.append(lookahead);
                                                            lookahead = tokenizer.nextToken();
                                                        }
                                                        exprBuffer.append(lookahead);
                                                        lookahead = tokenizer.nextToken();
                                                        break;
                                                    }
                                                    case '{': {
                                                        error = XSLMessages.createMessage(1, null);
                                                        lookahead = null;
                                                        break;
                                                    }
                                                    case '}': {
                                                        buffer.setLength(0);
                                                        XPath xpath = handler.createXPath(exprBuffer.toString());
                                                        this.m_parts.addElement(new AVTPartXPath(xpath));
                                                        lookahead = null;
                                                        break;
                                                    }
                                                    default: {
                                                        exprBuffer.append(lookahead);
                                                        lookahead = tokenizer.nextToken();
                                                        break;
                                                    }
                                                }
                                                continue;
                                            }
                                            exprBuffer.append(lookahead);
                                            lookahead = tokenizer.nextToken();
                                        }
                                        if (error != null) {
                                            // empty if block
                                        }
                                        break block30;
                                    }
                                    catch (NoSuchElementException ex) {
                                        error = XSLMessages.createMessage(93, new Object[]{name, stringedValue});
                                    }
                                    break block30;
                                }
                                case '}': {
                                    lookahead = tokenizer.nextToken();
                                    if (lookahead.equals("}")) {
                                        buffer.append(lookahead);
                                        lookahead = null;
                                        break;
                                    }
                                    try {
                                        handler.warn(1, null);
                                    }
                                    catch (SAXException se) {
                                        throw new TransformerException(se);
                                    }
                                    buffer.append("}");
                                    break;
                                }
                                default: {
                                    buffer.append(t2);
                                    break;
                                }
                            }
                            break block30;
                        }
                        buffer.append(t2);
                    }
                    if (null == error) continue;
                    try {
                        handler.warn(14, new Object[]{error});
                        break;
                    }
                    catch (SAXException se) {
                        throw new TransformerException(se);
                    }
                }
                if (buffer.length() > 0) {
                    this.m_parts.addElement(new AVTPartSimple(buffer.toString()));
                    buffer.setLength(0);
                }
                Object var15_17 = null;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                StringBufferPool.free(buffer);
                StringBufferPool.free(exprBuffer);
                throw throwable;
            }
            StringBufferPool.free(buffer);
            StringBufferPool.free(exprBuffer);
            {
            }
        }
        if (null == this.m_parts && null == this.m_simpleString) {
            this.m_simpleString = "";
        }
    }

    public String getSimpleString() {
        if (null != this.m_simpleString) {
            return this.m_simpleString;
        }
        if (null != this.m_parts) {
            String s2;
            FastStringBuffer buf = StringBufferPool.get();
            try {
                buf.setLength(0);
                int n2 = this.m_parts.size();
                int i2 = 0;
                while (i2 < n2) {
                    AVTPart part = (AVTPart)this.m_parts.elementAt(i2);
                    buf.append(part.getSimpleString());
                    ++i2;
                }
                s2 = buf.toString();
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                StringBufferPool.free(buf);
                throw throwable;
            }
            StringBufferPool.free(buf);
            return s2;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String evaluate(XPathContext xctxt, int context, PrefixResolver nsNode) throws TransformerException {
        String string;
        FastStringBuffer buf;
        block6: {
            String string2;
            block5: {
                buf = StringBufferPool.get();
                try {
                    if (null != this.m_simpleString) {
                        string2 = this.m_simpleString;
                        Object var9_8 = null;
                        break block5;
                    }
                    if (null != this.m_parts) {
                        buf.setLength(0);
                        int n2 = this.m_parts.size();
                        int i2 = 0;
                        while (true) {
                            if (i2 >= n2) break;
                            AVTPart part = (AVTPart)this.m_parts.elementAt(i2);
                            part.evaluate(xctxt, buf, context, nsNode);
                            ++i2;
                        }
                        String string3 = buf.toString();
                        Object var9_9 = null;
                        StringBufferPool.free(buf);
                        return string3;
                    }
                    string = "";
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    StringBufferPool.free(buf);
                    throw throwable;
                }
            }
            StringBufferPool.free(buf);
            return string2;
        }
        Object var9_10 = null;
        StringBufferPool.free(buf);
        return string;
    }

    public boolean isContextInsensitive() {
        return null != this.m_simpleString;
    }

    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_parts) {
            int n2 = this.m_parts.size();
            int i2 = 0;
            while (i2 < n2) {
                AVTPart part = (AVTPart)this.m_parts.elementAt(i2);
                if (part.canTraverseOutsideSubtree()) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        if (null != this.m_parts) {
            int n2 = this.m_parts.size();
            int i2 = 0;
            while (i2 < n2) {
                AVTPart part = (AVTPart)this.m_parts.elementAt(i2);
                part.fixupVariables(vars, globalsSize);
                ++i2;
            }
        }
    }
}

