/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class WriterToUTF8
extends Writer {
    private final OutputStream m_os;

    public WriterToUTF8(OutputStream os) throws UnsupportedEncodingException {
        this.m_os = os;
    }

    public void write(int c2) throws IOException {
        if (c2 < 128) {
            this.m_os.write(c2);
        } else if (c2 < 2048) {
            this.m_os.write(192 + (c2 >> 6));
            this.m_os.write(128 + (c2 & 0x3F));
        } else {
            this.m_os.write(224 + (c2 >> 12));
            this.m_os.write(128 + (c2 >> 6 & 0x3F));
            this.m_os.write(128 + (c2 & 0x3F));
        }
    }

    public void write(char[] chars, int start, int length) throws IOException {
        OutputStream os = this.m_os;
        int n2 = length + start;
        int i2 = start;
        while (i2 < n2) {
            char c2 = chars[i2];
            if (c2 < '\u0080') {
                os.write(c2);
            } else if (c2 < '\u0800') {
                os.write(192 + (c2 >> 6));
                os.write(128 + (c2 & 0x3F));
            } else {
                os.write(224 + (c2 >> 12));
                os.write(128 + (c2 >> 6 & 0x3F));
                os.write(128 + (c2 & 0x3F));
            }
            ++i2;
        }
    }

    public void write(String s2) throws IOException {
        int n2 = s2.length();
        OutputStream os = this.m_os;
        int i2 = 0;
        while (i2 < n2) {
            char c2 = s2.charAt(i2);
            if (c2 < '\u0080') {
                os.write(c2);
            } else if (c2 < '\u0800') {
                os.write(192 + (c2 >> 6));
                os.write(128 + (c2 & 0x3F));
            } else {
                os.write(224 + (c2 >> 12));
                os.write(128 + (c2 >> 6 & 0x3F));
                os.write(128 + (c2 & 0x3F));
            }
            ++i2;
        }
    }

    public void flush() throws IOException {
        this.m_os.flush();
    }

    public void close() throws IOException {
        this.m_os.close();
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }
}

