/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import org.apache.xalan.serialize.CharInfo;
import org.apache.xalan.serialize.SerializerToXML;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SerializerToText
extends SerializerToXML {
    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        this.flushWriter();
    }

    public void startElement(String namespaceURI, String localName, String name, Attributes atts) throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String name) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeNormalizedChars(ch, start, length, false);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        this.flushWriter();
    }

    public void charactersRaw(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeNormalizedChars(ch, start, length, false);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        this.flushWriter();
    }

    protected int writeUTF16Surrogate(char c2, char[] ch, int i2, int end) throws IOException, SAXException {
        int surrogateValue = this.getURF16SurrogateValue(c2, ch, i2, end);
        this.m_writer.write(surrogateValue);
        return ++i2;
    }

    void writeNormalizedChars(char[] ch, int start, int length, boolean isCData) throws IOException, SAXException {
        int end = start + length;
        int i2 = start;
        while (i2 < end) {
            char c2 = ch[i2];
            if (CharInfo.S_LINEFEED == c2) {
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            } else if (isCData && c2 > this.m_maxCharacter) {
                if (i2 != 0) {
                    this.m_writer.write("]]>");
                }
                if (SerializerToXML.isUTF16Surrogate(c2)) {
                    i2 = this.writeUTF16Surrogate(c2, ch, i2, end);
                } else {
                    this.m_writer.write(c2);
                }
                if (i2 != 0 && i2 < end - 1) {
                    this.m_writer.write("<![CDATA[");
                }
            } else if (isCData && i2 < end - 2 && ']' == c2 && ']' == ch[i2 + 1] && '>' == ch[i2 + 2]) {
                this.m_writer.write("]]]]><![CDATA[>");
                i2 += 2;
            } else if (c2 <= this.m_maxCharacter) {
                this.m_writer.write(c2);
            } else if (SerializerToXML.isUTF16Surrogate(c2)) {
                i2 = this.writeUTF16Surrogate(c2, ch, i2, end);
            } else {
                this.m_writer.write(c2);
            }
            ++i2;
        }
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeNormalizedChars(ch, start, length, false);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        this.flushWriter();
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeNormalizedChars(ch, start, length, false);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        this.flushWriter();
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void comment(String data) throws SAXException {
    }

    public void entityReference(String name) throws SAXException {
    }
}

