/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import org.apache.xalan.serialize.EncodingInfo;

public class Encodings {
    static final int m_defaultLastPrintable = 127;
    public static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final EncodingInfo[] _encodings = new EncodingInfo[]{new EncodingInfo("WINDOWS-1250", "Cp1250", 255), new EncodingInfo("WINDOWS-1252", "Cp1252", 255), new EncodingInfo("UTF-8", "UTF8", 65535), new EncodingInfo("US-ASCII", "ISO8859_1", 127), new EncodingInfo("ISO-8859-1", "ISO8859_1", 255), new EncodingInfo("ISO-8859-1", "ISO8859-1", 255), new EncodingInfo("ISO-8859-2", "ISO8859_2", 255), new EncodingInfo("ISO-8859-2", "ISO8859-2", 255), new EncodingInfo("ISO-8859-3", "ISO8859_3", 255), new EncodingInfo("ISO-8859-3", "ISO8859-3", 255), new EncodingInfo("ISO-8859-4", "ISO8859_4", 255), new EncodingInfo("ISO-8859-4", "ISO8859-4", 255), new EncodingInfo("ISO-8859-5", "ISO8859_5", 255), new EncodingInfo("ISO-8859-5", "ISO8859-5", 255), new EncodingInfo("ISO-8859-6", "ISO8859_6", 255), new EncodingInfo("ISO-8859-6", "ISO8859-6", 255), new EncodingInfo("ISO-8859-7", "ISO8859_7", 255), new EncodingInfo("ISO-8859-7", "ISO8859-7", 255), new EncodingInfo("ISO-8859-8", "ISO8859_8", 255), new EncodingInfo("ISO-8859-8", "ISO8859-8", 255), new EncodingInfo("ISO-8859-9", "ISO8859_9", 255), new EncodingInfo("ISO-8859-9", "ISO8859-9", 255), new EncodingInfo("US-ASCII", "8859_1", 255), new EncodingInfo("ISO-8859-1", "8859_1", 255), new EncodingInfo("ISO-8859-2", "8859_2", 255), new EncodingInfo("ISO-8859-3", "8859_3", 255), new EncodingInfo("ISO-8859-4", "8859_4", 255), new EncodingInfo("ISO-8859-5", "8859_5", 255), new EncodingInfo("ISO-8859-6", "8859_6", 255), new EncodingInfo("ISO-8859-7", "8859_7", 255), new EncodingInfo("ISO-8859-8", "8859_8", 255), new EncodingInfo("ISO-8859-9", "8859_9", 255), new EncodingInfo("ISO-8859-1", "8859-1", 255), new EncodingInfo("ISO-8859-2", "8859-2", 255), new EncodingInfo("ISO-8859-3", "8859-3", 255), new EncodingInfo("ISO-8859-4", "8859-4", 255), new EncodingInfo("ISO-8859-5", "8859-5", 255), new EncodingInfo("ISO-8859-6", "8859-6", 255), new EncodingInfo("ISO-8859-7", "8859-7", 255), new EncodingInfo("ISO-8859-8", "8859-8", 255), new EncodingInfo("ISO-8859-9", "8859-9", 255), new EncodingInfo("ISO-2022-JP", "JIS", 65535), new EncodingInfo("SHIFT_JIS", "SJIS", 65535), new EncodingInfo("EUC-JP", "EUC_JP", 65535), new EncodingInfo("EUC-KR", "EUC_KR", 65535), new EncodingInfo("EUC-CN", "EUC_CN", 65535), new EncodingInfo("EUC-TW", "EUC_TW", 65535), new EncodingInfo("GB2312", "EUC_CN", 65535), new EncodingInfo("EUC-JP", "EUC-JP", 65535), new EncodingInfo("EUC-KR", "EUC-KR", 65535), new EncodingInfo("EUC-CN", "EUC-CN", 65535), new EncodingInfo("EUC-TW", "EUC-TW", 65535), new EncodingInfo("GB2312", "EUC-CN", 65535), new EncodingInfo("GB2312", "GB2312", 65535), new EncodingInfo("BIG5", "Big5", 65535), new EncodingInfo("EUC-JP", "EUCJIS", 65535), new EncodingInfo("EUC-KR", "KSC5601", 65535), new EncodingInfo("ISO-2022-KR", "ISO2022KR", 65535), new EncodingInfo("KOI8-R", "KOI8_R", 65535), new EncodingInfo("EBCDIC-CP-US", "Cp037", 255), new EncodingInfo("EBCDIC-CP-CA", "Cp037", 255), new EncodingInfo("EBCDIC-CP-NL", "Cp037", 255), new EncodingInfo("EBCDIC-CP-DK", "Cp277", 255), new EncodingInfo("EBCDIC-CP-NO", "Cp277", 255), new EncodingInfo("EBCDIC-CP-FI", "Cp278", 255), new EncodingInfo("EBCDIC-CP-SE", "Cp278", 255), new EncodingInfo("EBCDIC-CP-IT", "Cp280", 255), new EncodingInfo("EBCDIC-CP-ES", "Cp284", 255), new EncodingInfo("EBCDIC-CP-GB", "Cp285", 255), new EncodingInfo("EBCDIC-CP-FR", "Cp297", 255), new EncodingInfo("EBCDIC-CP-AR1", "Cp420", 255), new EncodingInfo("EBCDIC-CP-HE", "Cp424", 255), new EncodingInfo("EBCDIC-CP-CH", "Cp500", 255), new EncodingInfo("EBCDIC-CP-ROECE", "Cp870", 255), new EncodingInfo("EBCDIC-CP-YU", "Cp870", 255), new EncodingInfo("EBCDIC-CP-IS", "Cp871", 255), new EncodingInfo("EBCDIC-CP-AR2", "Cp918", 255), new EncodingInfo("MacRoman", "MacTEC", 255), new EncodingInfo("ASCII", "ASCII", 127), new EncodingInfo("ISO-Latin-1", "ASCII", 255), new EncodingInfo("UTF-8", "UTF8", 65535), new EncodingInfo("UNICODE", "Unicode", 65535), new EncodingInfo("UTF-16", "Unicode", 65535)};
    static /* synthetic */ Class class$java$lang$String;

    public static Writer getWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        int i2 = 0;
        while (i2 < _encodings.length) {
            if (Encodings._encodings[i2].name.equalsIgnoreCase(encoding)) {
                try {
                    return new OutputStreamWriter(output, Encodings._encodings[i2].javaName);
                }
                catch (IllegalArgumentException iae) {
                }
                catch (UnsupportedEncodingException usee) {
                    // empty catch block
                }
            }
            ++i2;
        }
        try {
            return new OutputStreamWriter(output, encoding);
        }
        catch (IllegalArgumentException iae) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    public static Object getCharToByteConverter(String encoding) {
        Class<?> charToByteConverterClass = null;
        Method getConverterMethod = null;
        try {
            charToByteConverterClass = Class.forName("sun.io.CharToByteConverter");
            Class[] argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Encodings.class$("java.lang.String")) : class$java$lang$String};
            getConverterMethod = charToByteConverterClass.getMethod("getConverter", argTypes);
        }
        catch (Exception e2) {
            System.err.println("Warning: Could not get charToByteConverterClass!");
            return null;
        }
        Object[] args = new Object[1];
        int i2 = 0;
        while (i2 < _encodings.length) {
            if (Encodings._encodings[i2].name.equalsIgnoreCase(encoding)) {
                try {
                    args[0] = Encodings._encodings[i2].javaName;
                    Object converter = getConverterMethod.invoke(null, args);
                    if (null != converter) {
                        return converter;
                    }
                }
                catch (Exception iae) {
                    // empty catch block
                }
            }
            ++i2;
        }
        return null;
    }

    public static int getLastPrintable(String encoding) {
        int i2 = 0;
        while (i2 < _encodings.length) {
            if (Encodings._encodings[i2].name.equalsIgnoreCase(encoding) || Encodings._encodings[i2].javaName.equalsIgnoreCase(encoding)) {
                return Encodings._encodings[i2].lastPrintable;
            }
            ++i2;
        }
        return 127;
    }

    public static int getLastPrintable() {
        return 127;
    }

    public static String getMimeEncoding(String encoding) {
        block5: {
            if (null == encoding) {
                try {
                    encoding = System.getProperty("file.encoding", "UTF8");
                    if (null != encoding) {
                        String jencoding = encoding.equalsIgnoreCase("Cp1252") || encoding.equalsIgnoreCase("ISO8859_1") || encoding.equalsIgnoreCase("8859_1") || encoding.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(encoding);
                        encoding = null != jencoding ? jencoding : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    encoding = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException se) {
                    encoding = DEFAULT_MIME_ENCODING;
                }
            } else {
                encoding = Encodings.convertJava2MimeEncoding(encoding);
            }
        }
        return encoding;
    }

    public static String convertJava2MimeEncoding(String encoding) {
        int i2 = 0;
        while (i2 < _encodings.length) {
            if (Encodings._encodings[i2].javaName.equalsIgnoreCase(encoding)) {
                return Encodings._encodings[i2].name;
            }
            ++i2;
        }
        return encoding;
    }

    public static String convertMime2JavaEncoding(String encoding) {
        int i2 = 0;
        while (i2 < _encodings.length) {
            if (Encodings._encodings[i2].name.equalsIgnoreCase(encoding)) {
                return Encodings._encodings[i2].javaName;
            }
            ++i2;
        }
        return encoding;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

