/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib;

import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.xslt.EnvironmentCheck;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXNotSupportedException;

public class Extensions {
    private Extensions() {
    }

    public static NodeSet nodeset(ExpressionContext myProcessor, Object rtf) {
        if (rtf instanceof NodeIterator) {
            return new NodeSet((NodeIterator)rtf);
        }
        String textNodeValue = rtf instanceof String ? (String)rtf : (rtf instanceof Boolean ? new XBoolean((boolean)((Boolean)rtf)).str() : (rtf instanceof Double ? new XNumber((Double)rtf).str() : rtf.toString()));
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db2 = dbf.newDocumentBuilder();
            Document myDoc = db2.newDocument();
            Text textNode = myDoc.createTextNode(textNodeValue);
            DocumentFragment docFrag = myDoc.createDocumentFragment();
            docFrag.appendChild(textNode);
            return new NodeSet(docFrag);
        }
        catch (ParserConfigurationException pce) {
            throw new WrappedRuntimeException(pce);
        }
    }

    public static NodeSet intersection(NodeIterator ni1, NodeIterator ni2) throws TransformerException {
        NodeSet ns1 = new NodeSet(ni1);
        NodeSet ns2 = new NodeSet(ni2);
        NodeSet inter = new NodeSet();
        inter.setShouldCacheNodes(true);
        int i2 = 0;
        while (i2 < ns1.getLength()) {
            Node n2 = ns1.elementAt(i2);
            if (ns2.contains(n2)) {
                inter.addElement(n2);
            }
            ++i2;
        }
        return inter;
    }

    public static NodeSet difference(NodeIterator ni1, NodeIterator ni2) throws TransformerException {
        NodeSet ns1 = new NodeSet(ni1);
        NodeSet ns2 = new NodeSet(ni2);
        NodeSet diff = new NodeSet();
        diff.setShouldCacheNodes(true);
        int i2 = 0;
        while (i2 < ns1.getLength()) {
            Node n2 = ns1.elementAt(i2);
            if (!ns2.contains(n2)) {
                diff.addElement(n2);
            }
            ++i2;
        }
        return diff;
    }

    public static NodeSet distinct(ExpressionContext myContext, NodeIterator ni) throws TransformerException {
        NodeSet dist = new NodeSet();
        dist.setShouldCacheNodes(true);
        Hashtable<String, Node> stringTable = new Hashtable<String, Node>();
        Node currNode = ni.nextNode();
        while (currNode != null) {
            String key = myContext.toString(currNode);
            if (!stringTable.containsKey(key)) {
                stringTable.put(key, currNode);
                dist.addElement(currNode);
            }
            currNode = ni.nextNode();
        }
        return dist;
    }

    public static boolean hasSameNodes(NodeIterator ni1, NodeIterator ni2) {
        NodeSet ns1 = new NodeSet(ni1);
        NodeSet ns2 = new NodeSet(ni2);
        if (ns1.getLength() != ns2.getLength()) {
            return false;
        }
        int i2 = 0;
        while (i2 < ns1.getLength()) {
            Node n2 = ns1.elementAt(i2);
            if (!ns2.contains(n2)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static XObject evaluate(ExpressionContext myContext, String xpathExpr) throws SAXNotSupportedException, Exception {
        if (myContext instanceof XPathContext.XPathExpressionContext) {
            XPathContext xctxt = ((XPathContext.XPathExpressionContext)myContext).getXPathContext();
            XPath dynamicXPath = new XPath(xpathExpr, xctxt.getSAXLocator(), xctxt.getNamespaceContext(), 0);
            return dynamicXPath.execute(xctxt, myContext.getContextNode(), xctxt.getNamespaceContext());
        }
        throw new SAXNotSupportedException(XSLMessages.createMessage(126, new Object[]{myContext}));
    }

    public static NodeSet tokenize(ExpressionContext myContext, String toTokenize, String delims) {
        Document lDoc;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db2 = dbf.newDocumentBuilder();
            lDoc = db2.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new WrappedRuntimeException(pce);
        }
        StringTokenizer lTokenizer = new StringTokenizer(toTokenize, delims);
        NodeSet resultSet = new NodeSet();
        while (lTokenizer.hasMoreTokens()) {
            resultSet.addNode(lDoc.createTextNode(lTokenizer.nextToken()));
        }
        return resultSet;
    }

    public static NodeSet tokenize(ExpressionContext myContext, String toTokenize) {
        return Extensions.tokenize(myContext, toTokenize, " \t\n\r");
    }

    public static Node checkEnvironment(ExpressionContext myContext) {
        Document factoryDocument;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db2 = dbf.newDocumentBuilder();
            factoryDocument = db2.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new WrappedRuntimeException(pce);
        }
        Element resultNode = null;
        try {
            resultNode = factoryDocument.createElement("checkEnvironmentExtension");
            EnvironmentCheck envChecker = new EnvironmentCheck();
            Hashtable h2 = envChecker.getEnvironmentHash();
            envChecker.appendEnvironmentReport(resultNode, factoryDocument, h2);
            envChecker = null;
        }
        catch (Exception e2) {
            throw new WrappedRuntimeException(e2);
        }
        return resultNode;
    }
}

