/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.soap.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    public static String nodeToString(Node node) {
        StringWriter stringWriter = new StringWriter();
        DOMWriter.serializeAsXML(node, stringWriter);
        return stringWriter.toString();
    }

    private static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string != null ? string.length() : 0;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            switch (c2) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': {
                    if (n3 > 0) {
                        char c3 = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c3 != '\r') {
                            stringBuffer.append(StringUtils.lineSeparator);
                            break;
                        }
                        stringBuffer.append('\n');
                        break;
                    }
                    stringBuffer.append(StringUtils.lineSeparator);
                    break;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static void print(Node node, PrintWriter printWriter) {
        if (node == null) {
            return;
        }
        boolean bl = false;
        short s2 = node.getNodeType();
        switch (s2) {
            case 9: {
                printWriter.println("<?xml version=\"1.0\"?>");
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n2 = nodeList.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    DOMWriter.print(nodeList.item(n3), printWriter);
                    ++n3;
                }
                break;
            }
            case 1: {
                Object object;
                printWriter.print(String.valueOf('<') + node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n4 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
                int n5 = 0;
                while (n5 < n4) {
                    object = (Attr)namedNodeMap.item(n5);
                    printWriter.print(String.valueOf(' ') + object.getNodeName() + "=\"" + DOMWriter.normalize(object.getValue()) + '\"');
                    ++n5;
                }
                object = node.getChildNodes();
                if (object != null) {
                    int n6 = object.getLength();
                    boolean bl2 = bl = n6 > 0;
                    if (bl) {
                        printWriter.print('>');
                    }
                    int n7 = 0;
                    while (n7 < n6) {
                        DOMWriter.print(object.item(n7), printWriter);
                        ++n7;
                    }
                } else {
                    bl = false;
                }
                if (bl) break;
                printWriter.print("/>");
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                break;
            }
            case 3: {
                printWriter.print(DOMWriter.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                printWriter.print("<!--");
                printWriter.print(node.getNodeValue());
                printWriter.print("-->");
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    printWriter.print(' ');
                    printWriter.print(string);
                }
                printWriter.println("?>");
                break;
            }
        }
        if (s2 == 1 && bl) {
            printWriter.print("</");
            printWriter.print(node.getNodeName());
            printWriter.print('>');
            bl = false;
        }
    }

    public static void serializeAsXML(Node node, Writer writer) {
        DOMWriter.print(node, new PrintWriter(writer));
    }
}

