/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.net;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.soap.util.net.Relay;

public class TcpTunnelGui
extends Frame {
    int listenPort;
    String tunnelHost;
    int tunnelPort;
    TextArea listenText;
    TextArea tunnelText;
    Label status;
    Relay inRelay;
    Relay outRelay;

    public TcpTunnelGui(int n2, String string, int n3) {
        this.listenPort = n2;
        this.tunnelHost = string;
        this.tunnelPort = n3;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setTitle("TCP Tunnel/Monitor: Tunneling localhost:" + n2 + " to " + string + ":" + n3);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label("From localhost:" + n2, 1);
        panel.add("West", label);
        Label label2 = new Label("From " + string + ":" + n3, 1);
        panel.add("East", label2);
        this.add("North", panel);
        panel = new Panel();
        panel.setLayout(new GridLayout(-1, 2));
        this.listenText = new TextArea();
        panel.add(this.listenText);
        this.tunnelText = new TextArea();
        panel.add(this.tunnelText);
        this.add("Center", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel = new Panel();
        Button button = new Button("Clear");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TcpTunnelGui.this.listenText.setText("");
                TcpTunnelGui.this.tunnelText.setText("");
            }
        });
        panel.add(button);
        panel2.add("Center", panel);
        this.status = new Label();
        panel2.add("South", this.status);
        this.add("South", panel2);
        this.pack();
        this.show();
        Font font = label.getFont();
        label.setFont(new Font(font.getName(), 1, font.getSize()));
        label2.setFont(new Font(font.getName(), 1, font.getSize()));
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public TextArea getListenText() {
        return this.listenText;
    }

    public Label getStatus() {
        return this.status;
    }

    public String getTunnelHost() {
        return this.tunnelHost;
    }

    public int getTunnelPort() {
        return this.tunnelPort;
    }

    public TextArea getTunnelText() {
        return this.tunnelText;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 3) {
            System.err.println("Usage: java TcpTunnelGui listenport tunnelhost tunnelport");
            System.exit(1);
        }
        int n2 = Integer.parseInt(stringArray[0]);
        String string = stringArray[1];
        int n3 = Integer.parseInt(stringArray[2]);
        TcpTunnelGui tcpTunnelGui = new TcpTunnelGui(n2, string, n3);
        Thread thread = new Thread(){

            public void run() {
                ServerSocket serverSocket = null;
                Label label = TcpTunnelGui.this.getStatus();
                try {
                    serverSocket = new ServerSocket(TcpTunnelGui.this.getListenPort());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
                while (true) {
                    try {
                        while (true) {
                            label.setText("Listening for connections on port " + TcpTunnelGui.this.getListenPort() + " ...");
                            Socket socket = serverSocket.accept();
                            Socket socket2 = new Socket(TcpTunnelGui.this.getTunnelHost(), TcpTunnelGui.this.getTunnelPort());
                            label.setText("Tunnelling port " + TcpTunnelGui.this.getListenPort() + " to port " + TcpTunnelGui.this.getTunnelPort() + " on host " + TcpTunnelGui.this.getTunnelHost() + " ...");
                            new Relay(socket.getInputStream(), socket2.getOutputStream(), TcpTunnelGui.this.getListenText()).start();
                            new Relay(socket2.getInputStream(), socket.getOutputStream(), TcpTunnelGui.this.getTunnelText()).start();
                        }
                    }
                    catch (Exception exception) {
                        label.setText("Ouch! [See console for details]: " + exception.getMessage());
                        exception.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        thread.start();
    }
}

